/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Substring
extends ScalarFunction {
    private final Expression source;
    private final Expression start;
    private final Expression length;

    public Substring(Location location, Expression source, Expression start, Expression length) {
        super(location, Arrays.asList(source, start, length));
        this.source = source;
        this.start = start;
        this.length = length;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = Expressions.typeMustBeString(this.source, this.functionName(), Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution startResolution = Expressions.typeMustBeNumeric(this.start, this.functionName(), Expressions.ParamOrdinal.SECOND);
        if (startResolution.unresolved()) {
            return startResolution;
        }
        return Expressions.typeMustBeNumeric(this.length, this.functionName(), Expressions.ParamOrdinal.THIRD);
    }

    @Override
    protected Pipe makePipe() {
        return new SubstringFunctionPipe(this.location(), this, Expressions.pipe(this.source), Expressions.pipe(this.start), Expressions.pipe(this.length));
    }

    @Override
    public boolean foldable() {
        return this.source.foldable() && this.start.foldable() && this.length.foldable();
    }

    @Override
    public Object fold() {
        return SubstringFunctionProcessor.doProcess(this.source.fold(), this.start.fold(), this.length.fold());
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Substring::new, this.source, this.start, this.length);
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate sourceScript = this.asScript(this.source);
        ScriptTemplate startScript = this.asScript(this.start);
        ScriptTemplate lengthScript = this.asScript(this.length);
        return this.asScriptFrom(sourceScript, startScript, lengthScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate sourceScript, ScriptTemplate startScript, ScriptTemplate lengthScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "substring", sourceScript.template(), startScript.template(), lengthScript.template()), ParamsBuilder.paramsBuilder().script(sourceScript.params()).script(startScript.params()).script(lengthScript.params()).build(), this.dataType());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.isInexact() ? field.exactAttribute().name() : field.name()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Substring(this.location(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

