/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.logical;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.sql.expression.predicate.Negatable;
import org.elasticsearch.xpack.sql.expression.predicate.logical.NotProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Not
extends UnaryScalarFunction {
    public Not(Location location, Expression child) {
        super(location, child);
    }

    @Override
    protected NodeInfo<Not> info() {
        return NodeInfo.create(this, Not::new, this.field());
    }

    @Override
    protected Not replaceChild(Expression newChild) {
        return new Not(this.location(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (DataType.BOOLEAN == this.field().dataType()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return Expressions.typeMustBeBoolean(this.field(), this.functionName(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    public Object fold() {
        return NotProcessor.INSTANCE.process(this.field().fold());
    }

    @Override
    protected Processor makeProcessor() {
        return NotProcessor.INSTANCE;
    }

    @Override
    public String processScript(String script) {
        return Scripts.formatTemplate("{sql}.not(" + script + ")");
    }

    @Override
    protected Expression canonicalize() {
        Expression canonicalChild = this.field().canonical();
        if (canonicalChild instanceof Negatable) {
            return ((Negatable)((Object)canonicalChild)).negate();
        }
        return this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }
}

