/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.sql.action.SqlClearCursorAction;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.RestSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.RestSqlTranslateAction;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.TransportSqlClearCursorAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlQueryAction;
import org.elasticsearch.xpack.sql.plugin.TransportSqlTranslateAction;

public class SqlPlugin
extends Plugin
implements ActionPlugin {
    private final boolean enabled;
    private final SqlLicenseChecker sqlLicenseChecker;

    SqlPlugin(boolean enabled, SqlLicenseChecker sqlLicenseChecker) {
        this.enabled = enabled;
        this.sqlLicenseChecker = sqlLicenseChecker;
    }

    public SqlPlugin(Settings settings) {
        this((Boolean)XPackSettings.SQL_ENABLED.get(settings), new SqlLicenseChecker(mode -> {
            XPackLicenseState licenseState = XPackPlugin.getSharedLicenseState();
            switch (mode) {
                case JDBC: {
                    if (licenseState.isJdbcAllowed()) break;
                    throw LicenseUtils.newComplianceException((String)"jdbc");
                }
                case ODBC: {
                    if (licenseState.isOdbcAllowed()) break;
                    throw LicenseUtils.newComplianceException((String)"odbc");
                }
                case PLAIN: {
                    if (licenseState.isSqlAllowed()) break;
                    throw LicenseUtils.newComplianceException((String)"sql");
                }
                default: {
                    throw new IllegalArgumentException("Unknown SQL mode " + mode);
                }
            }
        }));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        return this.createComponents(client, clusterService.getClusterName().value(), namedWriteableRegistry);
    }

    Collection<Object> createComponents(Client client, String clusterName, NamedWriteableRegistry namedWriteableRegistry) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        IndexResolver indexResolver = new IndexResolver(client, clusterName);
        return Arrays.asList(this.sqlLicenseChecker, indexResolver, new PlanExecutor(client, indexResolver, namedWriteableRegistry));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestSqlQueryAction(settings, restController), new RestSqlTranslateAction(settings, restController), new RestSqlClearCursorAction(settings, restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)SqlQueryAction.INSTANCE, TransportSqlQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)SqlTranslateAction.INSTANCE, TransportSqlTranslateAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)SqlClearCursorAction.INSTANCE, TransportSqlClearCursorAction.class, new Class[0]));
    }
}

