/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequestBuilder;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;

public class ShardChangesAction
extends Action<Request, Response, RequestBuilder> {
    public static final ShardChangesAction INSTANCE = new ShardChangesAction();
    public static final String NAME = "indices:data/read/xpack/ccr/shard_changes";
    static final Translog.Operation[] EMPTY_OPERATIONS_ARRAY = new Translog.Operation[0];

    private ShardChangesAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static Translog.Operation[] getOperations(IndexShard indexShard, long globalCheckpoint, long fromSeqNo, int maxOperationCount, String expectedHistoryUUID, ByteSizeValue maxBatchSize) throws IOException {
        if (indexShard.state() != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(indexShard.shardId(), indexShard.state());
        }
        String historyUUID = indexShard.getHistoryUUID();
        if (!historyUUID.equals(expectedHistoryUUID)) {
            throw new IllegalStateException("unexpected history uuid, expected [" + expectedHistoryUUID + "], actual [" + historyUUID + "]");
        }
        if (fromSeqNo > globalCheckpoint) {
            throw new IllegalStateException("not exposing operations from [" + fromSeqNo + "] greater than the global checkpoint [" + globalCheckpoint + "]");
        }
        int seenBytes = 0;
        long toSeqNo = Math.min(globalCheckpoint, fromSeqNo + (long)maxOperationCount - 1L);
        assert (fromSeqNo <= toSeqNo) : "invalid range from_seqno[" + fromSeqNo + "] > to_seqno[" + toSeqNo + "]";
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = indexShard.newChangesSnapshot("ccr", fromSeqNo, toSeqNo, true);){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
                if ((long)(seenBytes = (int)((long)seenBytes + op.estimateSize())) <= maxBatchSize.getBytes()) continue;
                break;
            }
        }
        return operations.toArray(EMPTY_OPERATIONS_ARRAY);
    }

    static Response getResponse(long mappingVersion, long settingsVersion, SeqNoStats seqNoStats, long maxSeqNoOfUpdates, Translog.Operation[] operations, long relativeStartNanos) {
        long tookInNanos = System.nanoTime() - relativeStartNanos;
        long tookInMillis = TimeUnit.NANOSECONDS.toMillis(tookInNanos);
        return new Response(mappingVersion, settingsVersion, seqNoStats.getGlobalCheckpoint(), seqNoStats.getMaxSeqNo(), maxSeqNoOfUpdates, operations, tookInMillis);
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final IndicesService indicesService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
            super(settings, ShardChangesAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, "search");
            this.indicesService = indicesService;
        }

        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(request.getShard().getIndex());
            IndexShard indexShard = indexService.getShard(request.getShard().id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            IndexMetaData indexMetaData = this.clusterService.state().metaData().index(shardId.getIndex());
            long mappingVersion = indexMetaData.getMappingVersion();
            long settingsVersion = indexMetaData.getSettingsVersion();
            Translog.Operation[] operations = ShardChangesAction.getOperations(indexShard, seqNoStats.getGlobalCheckpoint(), request.getFromSeqNo(), request.getMaxOperationCount(), request.getExpectedHistoryUUID(), request.getMaxBatchSize());
            long maxSeqNoOfUpdatesOrDeletes = indexShard.getMaxSeqNoOfUpdatesOrDeletes();
            return ShardChangesAction.getResponse(mappingVersion, settingsVersion, seqNoStats, maxSeqNoOfUpdatesOrDeletes, operations, request.relativeStartNanos);
        }

        protected void asyncShardOperation(Request request, ShardId shardId, ActionListener<Response> listener) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(request.getShard().getIndex());
            IndexShard indexShard = indexService.getShard(request.getShard().id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            if (request.getFromSeqNo() > seqNoStats.getGlobalCheckpoint()) {
                this.logger.trace("{} waiting for global checkpoint advancement from [{}] to [{}]", (Object)shardId, (Object)seqNoStats.getGlobalCheckpoint(), (Object)request.getFromSeqNo());
                indexShard.addGlobalCheckpointListener(request.getFromSeqNo(), (g, e) -> {
                    if (g != -2L) {
                        assert (request.getFromSeqNo() <= g) : shardId + " only advanced to [" + g + "] while waiting for [" + request.getFromSeqNo() + "]";
                        this.globalCheckpointAdvanced(shardId, g, request, listener);
                    } else {
                        assert (e != null);
                        this.globalCheckpointAdvancementFailure(shardId, e, request, listener, indexShard);
                    }
                }, request.getPollTimeout());
            } else {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            ActionListener wrappedListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof IllegalStateException && cause.getMessage().contains("Not all operations between from_seqno [")) {
                    String message = "Operations are no longer available for replicating. Maybe increase the retention setting [" + IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey() + "]?";
                    listener.onFailure((Exception)new ElasticsearchException(message, (Throwable)e, new Object[0]));
                } else {
                    listener.onFailure(e);
                }
            });
            super.doExecute(task, (ActionRequest)request, wrappedListener);
        }

        private void globalCheckpointAdvanced(ShardId shardId, long globalCheckpoint, Request request, ActionListener<Response> listener) {
            this.logger.trace("{} global checkpoint advanced to [{}] after waiting for [{}]", (Object)shardId, (Object)globalCheckpoint, (Object)request.getFromSeqNo());
            try {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
            catch (IOException caught) {
                listener.onFailure((Exception)caught);
            }
        }

        private void globalCheckpointAdvancementFailure(ShardId shardId, Exception e, Request request, ActionListener<Response> listener, IndexShard indexShard) {
            this.logger.trace(() -> new ParameterizedMessage("{} exception waiting for global checkpoint advancement to [{}]", (Object)shardId, (Object)request.getFromSeqNo()), (Throwable)e);
            if (e instanceof TimeoutException) {
                try {
                    IndexMetaData indexMetaData = this.clusterService.state().metaData().index(shardId.getIndex());
                    long mappingVersion = indexMetaData.getMappingVersion();
                    long settingsVersion = indexMetaData.getSettingsVersion();
                    SeqNoStats latestSeqNoStats = indexShard.seqNoStats();
                    long maxSeqNoOfUpdatesOrDeletes = indexShard.getMaxSeqNoOfUpdatesOrDeletes();
                    listener.onResponse((Object)ShardChangesAction.getResponse(mappingVersion, settingsVersion, latestSeqNoStats, maxSeqNoOfUpdatesOrDeletes, EMPTY_OPERATIONS_ARRAY, request.relativeStartNanos));
                }
                catch (Exception caught) {
                    caught.addSuppressed(e);
                    listener.onFailure(caught);
                }
            } else {
                listener.onFailure(e);
            }
        }

        protected boolean resolveIndex(Request request) {
            return false;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(request.concreteIndex(), ((Request)request.request()).getShard().id()).activeInitializingShardsRandomIt();
        }

        protected Response newResponse() {
            return new Response();
        }
    }

    static class RequestBuilder
    extends SingleShardOperationRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, Action<Request, Response, RequestBuilder> action) {
            super(client, action, (SingleShardRequest)new Request());
        }
    }

    public static final class Response
    extends ActionResponse {
        private long mappingVersion;
        private long settingsVersion;
        private long globalCheckpoint;
        private long maxSeqNo;
        private long maxSeqNoOfUpdatesOrDeletes;
        private Translog.Operation[] operations;
        private long tookInMillis;

        public long getMappingVersion() {
            return this.mappingVersion;
        }

        public long getSettingsVersion() {
            return this.settingsVersion;
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public long getMaxSeqNo() {
            return this.maxSeqNo;
        }

        public long getMaxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        public Translog.Operation[] getOperations() {
            return this.operations;
        }

        public long getTookInMillis() {
            return this.tookInMillis;
        }

        Response() {
        }

        Response(long mappingVersion, long settingsVersion, long globalCheckpoint, long maxSeqNo, long maxSeqNoOfUpdatesOrDeletes, Translog.Operation[] operations, long tookInMillis) {
            this.mappingVersion = mappingVersion;
            this.settingsVersion = settingsVersion;
            this.globalCheckpoint = globalCheckpoint;
            this.maxSeqNo = maxSeqNo;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.operations = operations;
            this.tookInMillis = tookInMillis;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.mappingVersion = in.readVLong();
            this.settingsVersion = in.readVLong();
            this.globalCheckpoint = in.readZLong();
            this.maxSeqNo = in.readZLong();
            this.maxSeqNoOfUpdatesOrDeletes = in.readZLong();
            this.operations = (Translog.Operation[])in.readArray(Translog.Operation::readOperation, Translog.Operation[]::new);
            this.tookInMillis = in.readVLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.mappingVersion);
            out.writeVLong(this.settingsVersion);
            out.writeZLong(this.globalCheckpoint);
            out.writeZLong(this.maxSeqNo);
            out.writeZLong(this.maxSeqNoOfUpdatesOrDeletes);
            out.writeArray(Translog.Operation::writeOperation, (Object[])this.operations);
            out.writeVLong(this.tookInMillis);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.mappingVersion == that.mappingVersion && this.settingsVersion == that.settingsVersion && this.globalCheckpoint == that.globalCheckpoint && this.maxSeqNo == that.maxSeqNo && this.maxSeqNoOfUpdatesOrDeletes == that.maxSeqNoOfUpdatesOrDeletes && Arrays.equals(this.operations, that.operations) && this.tookInMillis == that.tookInMillis;
        }

        public int hashCode() {
            return Objects.hash(this.mappingVersion, this.settingsVersion, this.globalCheckpoint, this.maxSeqNo, this.maxSeqNoOfUpdatesOrDeletes, Arrays.hashCode(this.operations), this.tookInMillis);
        }
    }

    public static class Request
    extends SingleShardRequest<Request> {
        private long fromSeqNo;
        private int maxOperationCount;
        private ShardId shardId;
        private String expectedHistoryUUID;
        private TimeValue pollTimeout = TransportResumeFollowAction.DEFAULT_READ_POLL_TIMEOUT;
        private ByteSizeValue maxBatchSize = TransportResumeFollowAction.DEFAULT_MAX_READ_REQUEST_SIZE;
        private long relativeStartNanos;

        public Request(ShardId shardId, String expectedHistoryUUID) {
            super(shardId.getIndexName());
            this.shardId = shardId;
            this.expectedHistoryUUID = expectedHistoryUUID;
        }

        Request() {
        }

        public ShardId getShard() {
            return this.shardId;
        }

        public long getFromSeqNo() {
            return this.fromSeqNo;
        }

        public void setFromSeqNo(long fromSeqNo) {
            this.fromSeqNo = fromSeqNo;
        }

        public int getMaxOperationCount() {
            return this.maxOperationCount;
        }

        public void setMaxOperationCount(int maxOperationCount) {
            this.maxOperationCount = maxOperationCount;
        }

        public ByteSizeValue getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public void setMaxBatchSize(ByteSizeValue maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public String getExpectedHistoryUUID() {
            return this.expectedHistoryUUID;
        }

        public TimeValue getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(TimeValue pollTimeout) {
            this.pollTimeout = Objects.requireNonNull(pollTimeout, "pollTimeout");
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.fromSeqNo < 0L) {
                validationException = ValidateActions.addValidationError((String)("fromSeqNo [" + this.fromSeqNo + "] cannot be lower than 0"), validationException);
            }
            if (this.maxOperationCount < 0) {
                validationException = ValidateActions.addValidationError((String)("maxOperationCount [" + this.maxOperationCount + "] cannot be lower than 0"), (ActionRequestValidationException)validationException);
            }
            if (this.maxBatchSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                validationException = ValidateActions.addValidationError((String)("maxBatchSize [" + this.maxBatchSize.getStringRep() + "] must be larger than 0"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.fromSeqNo = in.readVLong();
            this.maxOperationCount = in.readVInt();
            this.shardId = ShardId.readShardId((StreamInput)in);
            this.expectedHistoryUUID = in.readString();
            this.pollTimeout = in.readTimeValue();
            this.maxBatchSize = new ByteSizeValue(in);
            this.relativeStartNanos = System.nanoTime();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.fromSeqNo);
            out.writeVInt(this.maxOperationCount);
            this.shardId.writeTo(out);
            out.writeString(this.expectedHistoryUUID);
            out.writeTimeValue(this.pollTimeout);
            this.maxBatchSize.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.fromSeqNo == request.fromSeqNo && this.maxOperationCount == request.maxOperationCount && Objects.equals(this.shardId, request.shardId) && Objects.equals(this.expectedHistoryUUID, request.expectedHistoryUUID) && Objects.equals(this.pollTimeout, request.pollTimeout) && this.maxBatchSize.equals((Object)request.maxBatchSize);
        }

        public int hashCode() {
            return Objects.hash(this.fromSeqNo, this.maxOperationCount, this.shardId, this.expectedHistoryUUID, this.pollTimeout, this.maxBatchSize);
        }

        public String toString() {
            return "Request{fromSeqNo=" + this.fromSeqNo + ", maxOperationCount=" + this.maxOperationCount + ", shardId=" + this.shardId + ", expectedHistoryUUID=" + this.expectedHistoryUUID + ", pollTimeout=" + this.pollTimeout + ", maxBatchSize=" + this.maxBatchSize.getStringRep() + '}';
        }
    }
}

