/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TransportDeleteFilterAction
extends HandledTransportAction<DeleteFilterAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final ClusterService clusterService;

    @Inject
    public TransportDeleteFilterAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Client client) {
        super(settings, "cluster:admin/xpack/ml/filters/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteFilterAction.Request::new);
        this.clusterService = clusterService;
        this.client = client;
    }

    protected void doExecute(DeleteFilterAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        final String filterId = request.getFilterId();
        ClusterState state = this.clusterService.state();
        Map jobs = MlMetadata.getMlMetadata((ClusterState)state).getJobs();
        ArrayList<String> currentlyUsedBy = new ArrayList<String>();
        block0: for (Job job : jobs.values()) {
            List detectors = job.getAnalysisConfig().getDetectors();
            for (Detector detector : detectors) {
                if (!detector.extractReferencedFilters().contains(filterId)) continue;
                currentlyUsedBy.add(job.getId());
                continue block0;
            }
        }
        if (!currentlyUsedBy.isEmpty()) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot delete filter, currently used by jobs: " + currentlyUsedBy), (Object[])new Object[0]);
        }
        DeleteRequest deleteRequest = new DeleteRequest(".ml-meta", "doc", MlFilter.documentId((String)filterId));
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.add(deleteRequest);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkResponse) {
                if (bulkResponse.getItems()[0].status() == RestStatus.NOT_FOUND) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not delete filter with ID [" + filterId + "] because it does not exist", new Object[0]));
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Could not delete filter with ID [" + filterId + "]"), (Throwable)e));
            }
        });
    }
}

