/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;

public class TransportUpdateDatafeedAction
extends TransportMasterNodeAction<UpdateDatafeedAction.Request, PutDatafeedAction.Response> {
    @Inject
    public TransportUpdateDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/ml/datafeeds/update", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, UpdateDatafeedAction.Request::new);
    }

    protected String executor() {
        return "same";
    }

    protected PutDatafeedAction.Response newResponse() {
        return new PutDatafeedAction.Response();
    }

    protected void masterOperation(final UpdateDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) {
        final Map headers = this.threadPool.getThreadContext().getHeaders();
        this.clusterService.submitStateUpdateTask("update-datafeed-" + request.getUpdate().getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutDatafeedAction.Response>((AckedRequest)request, listener){
            private volatile DatafeedConfig updatedDatafeed;

            protected PutDatafeedAction.Response newResponse(boolean acknowledged) {
                if (acknowledged) {
                    TransportUpdateDatafeedAction.this.logger.info("Updated datafeed [{}]", (Object)request.getUpdate().getId());
                }
                return new PutDatafeedAction.Response(this.updatedDatafeed);
            }

            public ClusterState execute(ClusterState currentState) {
                DatafeedUpdate update = request.getUpdate();
                MlMetadata currentMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
                MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).updateDatafeed(update, persistentTasks, headers).build();
                this.updatedDatafeed = newMetadata.getDatafeed(update.getId());
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
            }
        });
    }

    protected ClusterBlockException checkBlock(UpdateDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

