/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.lucene.uid.PerThreadIDVersionAndSeqNoLookup;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class VersionsAndSeqNoResolver {
    static final ConcurrentMap<IndexReader.CacheKey, CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>> lookupStates = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ClosedListener removeLookupState = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)lookupStates.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDVersionAndSeqNoLookup[] getLookupState(IndexReader reader, String uidField) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookupState;
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> ctl = (CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>)lookupStates.get(cacheHelper.getKey());
        if (ctl == null) {
            ctl = new CloseableThreadLocal();
            CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> other = lookupStates.putIfAbsent(cacheHelper.getKey(), ctl);
            if (other == null) {
                cacheHelper.addClosedListener(removeLookupState);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDVersionAndSeqNoLookup[])ctl.get()) == null) {
            lookupState = new PerThreadIDVersionAndSeqNoLookup[reader.leaves().size()];
            for (LeafReaderContext leaf : reader.leaves()) {
                lookupState[leaf.ord] = new PerThreadIDVersionAndSeqNoLookup(leaf.reader(), uidField);
            }
            ctl.set((Object)lookupState);
        }
        if (lookupState.length != reader.leaves().size()) {
            throw new AssertionError((Object)("Mismatched numbers of leaves: " + lookupState.length + " != " + reader.leaves().size()));
        }
        if (lookupState.length > 0 && !Objects.equals(lookupState[0].uidField, uidField)) {
            throw new AssertionError((Object)("Index does not consistently use the same uid field: [" + uidField + "] != [" + lookupState[0].uidField + "]"));
        }
        return lookupState;
    }

    private VersionsAndSeqNoResolver() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndVersion result = lookup.lookupVersion(term.bytes(), leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndSeqNo loadDocIdAndSeqNo(IndexReader reader, Term term) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader, term.field());
        List leaves = reader.leaves();
        DocIdAndSeqNo latest = null;
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(i);
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            DocIdAndSeqNo result = lookup.lookupSeqNo(term.bytes(), leaf);
            if (result == null) continue;
            if (result.isLive) {
                assert (latest == null || latest.seqNo <= result.seqNo) : "the live doc does not have the highest seq_no; live_seq_no=" + result.seqNo + " < deleted_seq_no=" + latest.seqNo;
                return result;
            }
            if (latest != null && latest.seqNo >= result.seqNo) continue;
            latest = result;
        }
        return latest;
    }

    public static long loadVersion(IndexReader reader, Term term) throws IOException {
        DocIdAndVersion docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(reader, term);
        return docIdAndVersion == null ? -1L : docIdAndVersion.version;
    }

    public static class DocIdAndSeqNo {
        public final int docId;
        public final long seqNo;
        public final LeafReaderContext context;
        public final boolean isLive;

        DocIdAndSeqNo(int docId, long seqNo, LeafReaderContext context, boolean isLive) {
            this.docId = docId;
            this.seqNo = seqNo;
            this.context = context;
            this.isLive = isLive;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final LeafReader reader;
        public final int docBase;

        public DocIdAndVersion(int docId, long version, LeafReader reader, int docBase) {
            this.docId = docId;
            this.version = version;
            this.reader = reader;
            this.docBase = docBase;
        }
    }
}

