/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.joda.time.ReadableDateTime;

public class SqlQueryResponse
extends ActionResponse
implements ToXContentObject {
    private String cursor;
    private List<ColumnInfo> columns;
    private List<List<Object>> rows;

    public SqlQueryResponse() {
    }

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows) {
        this.cursor = cursor;
        this.columns = columns;
        this.rows = rows;
    }

    public String cursor() {
        return this.cursor;
    }

    public long size() {
        return this.rows.size();
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public SqlQueryResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public SqlQueryResponse columns(List<ColumnInfo> columns) {
        this.columns = columns;
        return this;
    }

    public SqlQueryResponse rows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        this.cursor = in.readString();
        if (in.readBoolean()) {
            int columnCount = in.readVInt();
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(columnCount);
            for (int c = 0; c < columnCount; ++c) {
                columns.add(SqlQueryResponse.readColumnInfo(in));
            }
            this.columns = Collections.unmodifiableList(columns);
        } else {
            this.columns = null;
        }
        int rowCount = in.readVInt();
        ArrayList rows = new ArrayList(rowCount);
        if (rowCount > 0) {
            int columnCount = in.readVInt();
            for (int r = 0; r < rowCount; ++r) {
                ArrayList<Object> row = new ArrayList<Object>(columnCount);
                for (int c = 0; c < columnCount; ++c) {
                    row.add(in.readGenericValue());
                }
                rows.add(Collections.unmodifiableList(row));
            }
        }
        this.rows = Collections.unmodifiableList(rows);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.cursor);
        if (this.columns == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.columns.size());
            for (ColumnInfo columnInfo : this.columns) {
                SqlQueryResponse.writeColumnInfo(out, columnInfo);
            }
        }
        out.writeVInt(this.rows.size());
        if (this.rows.size() > 0) {
            out.writeVInt(this.rows.get(0).size());
            for (List list : this.rows) {
                for (Object value : list) {
                    out.writeGenericValue(value);
                }
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Mode mode = Mode.fromString((String)params.param("mode"));
        builder.startObject();
        if (this.columns != null) {
            builder.startArray("columns");
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.startArray("rows");
        for (List list : this.rows()) {
            builder.startArray();
            for (Object value : list) {
                SqlQueryResponse.value(builder, mode, value);
            }
            builder.endArray();
        }
        builder.endArray();
        if (!this.cursor.equals("")) {
            builder.field(SqlQueryRequest.CURSOR.getPreferredName(), this.cursor);
        }
        return builder.endObject();
    }

    public static XContentBuilder value(XContentBuilder builder, Mode mode, Object value) throws IOException {
        if (Mode.isDriver((Mode)mode) && value instanceof ReadableDateTime) {
            builder.value(((ReadableDateTime)value).getMillis());
        } else {
            builder.value(value);
        }
        return builder;
    }

    public static ColumnInfo readColumnInfo(StreamInput in) throws IOException {
        int displaySize;
        JDBCType jdbcType;
        String table = in.readString();
        String name = in.readString();
        String esType = in.readString();
        if (in.readBoolean()) {
            jdbcType = JDBCType.valueOf(in.readVInt());
            displaySize = in.readVInt();
        } else {
            jdbcType = null;
            displaySize = 0;
        }
        return new ColumnInfo(table, name, esType, (SQLType)jdbcType, displaySize);
    }

    public static void writeColumnInfo(StreamOutput out, ColumnInfo columnInfo) throws IOException {
        out.writeString(columnInfo.table());
        out.writeString(columnInfo.name());
        out.writeString(columnInfo.esType());
        if (columnInfo.jdbcType() != null) {
            out.writeBoolean(true);
            out.writeVInt(columnInfo.jdbcType().getVendorTypeNumber().intValue());
            out.writeVInt(columnInfo.displaySize());
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlQueryResponse that = (SqlQueryResponse)((Object)o);
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.columns, this.rows);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

