/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGML;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterGEXF;
import org.gephi.ui.exporter.plugin.UIExporterGMLPanel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterGML
implements ExporterUI {
    ValidationPanel validationPanel;
    UIExporterGMLPanel panel;
    ExporterGML exporter;
    ExporterGMLSettings settings = new ExporterGMLSettings();

    public JPanel getPanel() {
        this.panel = new UIExporterGMLPanel();
        this.validationPanel = UIExporterGMLPanel.createValidationPanel(this.panel);
        return this.validationPanel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterGML)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGML;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGEXF.class, (String)"UIExporterGML.name");
    }

    private static class ExporterGMLSettings {
        private boolean exportLabel = true;
        private boolean exportCoordinates = true;
        private boolean exportNodeSize = true;
        private boolean exportEdgeSize = true;
        private boolean exportColor = true;
        private boolean exportNotRecognizedElements = true;
        private boolean normalize = false;
        private int spaces = 2;

        private ExporterGMLSettings() {
        }

        private void load(ExporterGML exporter) {
            exporter.setExportColor(this.exportColor);
            exporter.setExportCoordinates(this.exportCoordinates);
            exporter.setExportEdgeSize(this.exportEdgeSize);
            exporter.setExportLabel(this.exportLabel);
            exporter.setExportNodeSize(this.exportNodeSize);
            exporter.setExportNotRecognizedElements(this.exportNotRecognizedElements);
            exporter.setNormalize(this.normalize);
            exporter.setSpaces(this.spaces);
        }

        private void save(ExporterGML exporter) {
            this.exportColor = exporter.isExportColor();
            this.exportCoordinates = exporter.isExportCoordinates();
            this.exportEdgeSize = exporter.isExportEdgeSize();
            this.exportLabel = exporter.isExportLabel();
            this.exportNodeSize = exporter.isExportNodeSize();
            this.exportNotRecognizedElements = exporter.isExportNotRecognizedElements();
            this.normalize = exporter.isNormalize();
            this.spaces = exporter.getSpaces();
        }
    }
}

