/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.babel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.gui.WizardLayout;
import tim.prune.load.babel.BabelFilterPanel;
import tim.prune.load.babel.DiscardFilter;
import tim.prune.load.babel.DistanceFilter;
import tim.prune.load.babel.FilterDefinition;
import tim.prune.load.babel.InterpolateFilter;
import tim.prune.load.babel.SimplifyFilter;

public class AddFilterDialog {
    private BabelFilterPanel _parentPanel = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private WizardLayout _wizard = null;
    private FilterDefinition[] _filters = new FilterDefinition[4];
    private JButton _finishButton = null;
    private JButton _backButton = null;

    public AddFilterDialog(BabelFilterPanel babelFilterPanel, JFrame jFrame) {
        this._parentPanel = babelFilterPanel;
        this._parentFrame = jFrame;
    }

    public void showDialog() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.addfilter.title"), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._wizard.showFirstCard();
        this._backButton.setEnabled(false);
        this._finishButton.setEnabled(false);
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this._wizard = new WizardLayout(jPanel2);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(I18nManager.getText("dialog.gpsbabel.filter.discard"));
        jButton.addActionListener(new FilterTypeListener(1));
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("dialog.gpsbabel.filter.simplify"));
        jButton2.addActionListener(new FilterTypeListener(2));
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton(I18nManager.getText("dialog.gpsbabel.filter.distance"));
        jButton3.addActionListener(new FilterTypeListener(3));
        jPanel3.add(jButton3);
        JButton jButton4 = new JButton(I18nManager.getText("dialog.gpsbabel.filter.interpolate"));
        jButton4.addActionListener(new FilterTypeListener(4));
        jPanel3.add(jButton4);
        this._filters[0] = new DiscardFilter(this);
        this._filters[1] = new SimplifyFilter(this);
        this._filters[2] = new DistanceFilter(this);
        this._filters[3] = new InterpolateFilter(this);
        this._wizard.addCard(jPanel3);
        this._wizard.addCard(this._filters[0]);
        this._wizard.addCard(this._filters[1]);
        this._wizard.addCard(this._filters[2]);
        this._wizard.addCard(this._filters[3]);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddFilterDialog.this._wizard.showCard(0);
                AddFilterDialog.this._backButton.setEnabled(!AddFilterDialog.this._wizard.isFirstCard());
                AddFilterDialog.this._finishButton.setEnabled(false);
            }
        });
        this._backButton.setEnabled(false);
        jPanel4.add(this._backButton);
        this._finishButton = new JButton(I18nManager.getText("button.finish"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddFilterDialog.this.finish();
            }
        };
        this._finishButton.addActionListener(actionListener);
        this._finishButton.setEnabled(false);
        jPanel4.add(this._finishButton);
        JButton jButton5 = new JButton(I18nManager.getText("button.cancel"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddFilterDialog.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton5);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    public void filterParamsChanged() {
        int n = this._wizard.getCurrentCardIndex();
        if (n > 0 && n < 5) {
            this._finishButton.setEnabled(this._filters[n - 1].isFilterValid());
        }
    }

    private void finish() {
        int n = this._wizard.getCurrentCardIndex();
        if (n > 0 && n < 5) {
            this._parentPanel.addFilter(this._filters[n - 1].getString());
        }
        this._dialog.dispose();
    }

    class FilterTypeListener
    implements ActionListener {
        private int _index = 0;

        public FilterTypeListener(int n) {
            this._index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddFilterDialog.this._wizard.showCard(this._index);
            AddFilterDialog.this._backButton.setEnabled(true);
            AddFilterDialog.this.filterParamsChanged();
        }
    }
}

