/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.utils.Converter;

public class ZoomEvent
implements Event {
    private static final long serialVersionUID = -4658011539863774168L;
    private float _scale;
    private Location _center;
    private long _time;

    public ZoomEvent() {
        this._scale = 1.0f;
        this._center = new Location();
    }

    public ZoomEvent(float f, Location location, long l) {
        this._scale = f;
        this._center = location;
        this._time = l;
    }

    public float getScale() {
        return this._scale;
    }

    public long getTime() {
        return this._time;
    }

    public Location getCenter() {
        return this._center;
    }

    public void setCenter(Location location) {
        this._center = location;
    }

    public float getX() {
        return this._center.getX();
    }

    public float getY() {
        return this._center.getY();
    }

    public ZoomEvent(byte[] byArray) {
        if (byArray.length < 12) {
            System.err.println("Error constructing Zoom Event.");
            this._scale = 1.0f;
            this._center = new Location(0.0f, 0.0f);
        } else {
            this._scale = Converter.byteArrayToFloat(byArray, 0);
            this._center = new Location(Converter.byteArrayToFloat(byArray, 4), Converter.byteArrayToFloat(byArray, 8));
        }
    }

    @Override
    public int getEventType() {
        return 4;
    }

    @Override
    public byte[] serialize() {
        byte[] byArray = new byte[16];
        Converter.intToByteArray(byArray, 0, this.getEventType());
        Converter.floatToByteArray(byArray, 4, this._scale);
        Converter.floatToByteArray(byArray, 8, this._center.getX());
        Converter.floatToByteArray(byArray, 12, this._center.getY());
        return byArray;
    }

    public String toString() {
        return "ZOOM Scale: " + this._scale + ", Center: " + this._center.toString();
    }
}

