/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javajs.util.PT;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active;
    JCheckBox append;
    JCheckBox cartoons;
    JFileChooser chooser;
    private static boolean pdbCartoonChecked = true;
    private FPPanel display;
    Viewer vwr;

    public FilePreview(Viewer viewer, JFileChooser jFileChooser, boolean bl, Map<String, Object> map) {
        this.vwr = viewer;
        this.chooser = jFileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT.$("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilePreview.this.doPreviewAction(FilePreview.this.active.isSelected());
            }
        });
        box.add(this.active);
        this.display = new FPPanel(map);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        if (bl) {
            this.append = new JCheckBox(GT.$("Append models"), false);
            box.add(this.append);
            this.cartoons = new JCheckBox(GT.$("PDB cartoons"), pdbCartoonChecked);
            this.cartoons.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (FilePreview.this.active.isSelected()) {
                        FilePreview.this.doUpdatePreview(FilePreview.this.chooser.getSelectedFile());
                    }
                }
            });
            box.add(this.cartoons);
        }
        this.add(box);
        jFileChooser.setAccessory(this);
        jFileChooser.addPropertyChangeListener(this);
    }

    protected void doPreviewAction(boolean bl) {
        this.doUpdatePreview(bl ? this.chooser.getSelectedFile() : null);
    }

    public boolean isAppendSelected() {
        return this.append != null && this.append.isSelected();
    }

    public boolean isCartoonsSelected() {
        pdbCartoonChecked = this.cartoons != null && this.cartoons.isSelected();
        return pdbCartoonChecked;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(string = propertyChangeEvent.getPropertyName())) {
            this.doUpdatePreview((File)propertyChangeEvent.getNewValue());
        }
    }

    void doUpdatePreview(File file) {
        String string;
        if (file == null) {
            string = "zap";
        } else {
            String string2 = file.getAbsolutePath();
            String string3 = this.vwr.getLocalUrl(string2);
            if (string3 != null) {
                string2 = string3;
            }
            string2 = string2.replace('\\', '/');
            string = " \"" + string2 + "\"";
            if (string2.indexOf(".spt") >= 0) {
                string = "script " + string;
            } else {
                string = PT.rep((String)this.display.vwr.getP("defaultdropscript"), "\"%FILE\"", String.valueOf(string) + " 1");
                string = PT.rep(string, "%ALLOWCARTOONS", "" + (this.isCartoonsSelected() && !this.isAppendSelected()));
                System.out.println(string);
            }
        }
        this.display.vwr.evalStringQuiet(string);
    }

    public void setPreviewOptions(boolean bl) {
        if (this.append == null) {
            return;
        }
        this.append.setVisible(bl);
        this.cartoons.setVisible(bl);
    }

    private static class FPPanel
    extends JPanel {
        Viewer vwr;
        final Dimension currentSize = new Dimension();

        FPPanel(Map<String, Object> map) {
            map.put("previewOnly", Boolean.TRUE);
            Object object = map.get("display");
            map.put("display", this);
            this.vwr = new Viewer(map);
            map.put("display", object);
        }

        @Override
        public void paint(Graphics graphics) {
            this.getSize(this.currentSize);
            this.vwr.setScreenDimension(this.currentSize.width, this.currentSize.height);
            Rectangle rectangle = new Rectangle();
            graphics.getClipBounds(rectangle);
            this.vwr.renderScreenImage((Object)graphics, this.currentSize.width, this.currentSize.height);
        }
    }
}

