/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.STR;
import org.jmol.dssx.Bridge;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSP {
    private BioPolymer[] bioPolymers;
    private Lst<Bond> vHBonds;
    private BS[] done;
    private boolean doReport;
    private boolean dsspIgnoreHydrogens;
    private boolean setStructure;
    private char[][] labels;
    private BS bsBad;
    private int bioPolymerCount;
    private Map<String, Bridge> htBridges;
    private Map<int[][], Boolean> htLadders;
    private Lst<Bridge> bridgesA;
    private Lst<Bridge> bridgesP;
    private boolean isDSSP2;
    private int[][] sheetOffsets;

    public DSSP() {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[8];
        nArray[1] = -1;
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[7] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[4] = 1;
        nArray2[5] = -1;
        nArray2[6] = 1;
        nArray2[7] = -1;
        nArrayArray[1] = nArray2;
        this.sheetOffsets = nArrayArray;
    }

    public String calculateDssp(Object[] objectArray, int n, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
        int n3;
        int n4;
        String[] stringArray;
        this.bioPolymers = (BioPolymer[])objectArray;
        this.bioPolymerCount = n;
        this.vHBonds = (Lst)object;
        this.doReport = bl;
        this.dsspIgnoreHydrogens = bl2;
        this.setStructure = bl3;
        this.isDSSP2 = n2 > 1;
        BS bS = new BS();
        int n5 = 0;
        while (n5 < n) {
            if (this.bioPolymers[n5] instanceof AminoPolymer) {
                bS.set(n5);
            }
            ++n5;
        }
        if (bS.isEmpty()) {
            return "";
        }
        Model model = this.bioPolymers[0].model;
        SB sB = new SB();
        sB.append("Jmol ").append(Viewer.getJmolVersion()).append(" DSSP analysis for model ").append(model.ms.getModelNumberDotted(model.modelIndex)).append(" - ").append(model.ms.getModelTitle(model.modelIndex)).append("\n");
        if (model.modelIndex == 0) {
            sB.append("\nW. Kabsch and C. Sander, Biopolymers, vol 22, 1983, pp 2577-2637\n\nWe thank Wolfgang Kabsch and Chris Sander for writing the DSSP software,\nand we thank the CMBI for maintaining it to the extent that it was easy to\nre-engineer in Java for our purposes. \n\nSecond generation DSSP 2.0 is ").append(this.isDSSP2 ? "" : "NOT ").append("used in this analysis. See Int. J. Mol. Sci. 2014, 15, 7841-7864; doi:10.3390/ijms15057841.\n");
        }
        if (bl3 && model.modelIndex == 0) {
            sB.append("\nAll bioshapes have been deleted and must be regenerated.\n");
        }
        if (model.altLocCount > 0) {
            sB.append("\nNote: This model contains alternative locations. Use  'CONFIGURATION 1' to be consistent with CMBI DSSP.\n");
        }
        this.labels = new char[n][];
        this.done = new BS[n];
        this.bsBad = new BS();
        boolean bl4 = false;
        int n6 = bS.nextSetBit(0);
        while (n6 >= 0) {
            stringArray = (String[])this.bioPolymers[n6];
            if (!bl4 && ((AminoMonomer)stringArray.monomers[0]).getExplicitNH() != null) {
                if (bl2) {
                    sB.append(GT.o(GT.$("NOTE: Backbone amide hydrogen positions are present and will be ignored. Their positions will be approximated, as in standard DSSP analysis.\nUse {0} to not use this approximation.\n\n"), "SET dsspCalculateHydrogenAlways FALSE"));
                } else {
                    sB.append(GT.o(GT.$("NOTE: Backbone amide hydrogen positions are present and will be used. Results may differ significantly from standard DSSP analysis.\nUse {0} to ignore these hydrogen positions.\n\n"), "SET dsspCalculateHydrogenAlways TRUE"));
                }
                bl4 = true;
            }
            stringArray.recalculateLeadMidpointsAndWingVectors();
            n4 = stringArray.monomerCount;
            this.labels[n6] = new char[n4];
            this.done[n6] = new BS();
            n3 = 0;
            while (n3 < n4) {
                if (((AminoMonomer)stringArray.monomers[n3]).getCarbonylOxygenAtom() == null) {
                    this.bsBad.set(stringArray.monomers[n3].leadAtomIndex);
                }
                ++n3;
            }
            n6 = bS.nextSetBit(n6 + 1);
        }
        int[][][][] nArray = this.getDualHydrogenBondArray();
        this.bridgesA = new Lst();
        this.bridgesP = new Lst();
        this.htBridges = new Hashtable<String, Bridge>();
        this.htLadders = new Hashtable<int[][], Boolean>();
        this.getBridges(nArray);
        this.getSheetStructures();
        stringArray = new String[n];
        n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (nArray[n4] != null) {
                stringArray[n4] = this.findHelixes(n4, nArray[n4]);
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        if (bl) {
            SB sB2 = new SB();
            sB.append("\n------------------------------\n");
            n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                if (this.labels[n3] != null) {
                    AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n3];
                    sB2.append(this.dumpSummary(aminoPolymer, this.labels[n3]));
                    sB.append(stringArray[n3]).append(this.dumpTags(aminoPolymer, "$.1: " + String.valueOf(this.labels[n3]), this.bsBad, 2));
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
            if (this.bsBad.nextSetBit(0) >= 0) {
                sB.append("\nNOTE: '!' indicates a residue that is missing a backbone carbonyl oxygen atom.\n");
            }
            sB.append("\n").append("SUMMARY:" + sB2);
        }
        return sB.toString();
    }

    private int[][][][] getDualHydrogenBondArray() {
        int n;
        int[][][][] nArray = AU.newInt4(this.bioPolymerCount);
        int n2 = 0;
        while (n2 < this.bioPolymerCount) {
            if (this.bioPolymers[n2] instanceof AminoPolymer) {
                n = this.bioPolymers[n2].monomerCount;
                nArray[n2] = new int[n][2][3];
                int n3 = 0;
                while (n3 < n) {
                    nArray[n2][n3][1][1] = Integer.MIN_VALUE;
                    nArray[n2][n3][0][1] = Integer.MIN_VALUE;
                    nArray[n2][n3][1][2] = 0;
                    nArray[n2][n3][0][2] = 0;
                    ++n3;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.bioPolymerCount) {
            if (nArray[n2] != null) {
                n = 0;
                while (n < this.bioPolymerCount) {
                    if (nArray[n] != null) {
                        this.bioPolymers[n2].calcRasmolHydrogenBonds(this.bioPolymers[n], null, null, null, 2, nArray[n2], false, this.dsspIgnoreHydrogens);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return nArray;
    }

    private void getBridges(int[][][][] nArray) {
        Atom[] atomArray = this.bioPolymers[0].model.ms.at;
        Bridge bridge = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = 0;
        while (n < nArray.length) {
            block8: {
                if (!(this.bioPolymers[n] instanceof AminoPolymer)) break block8;
                AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
                int n2 = nArray[n].length - 1;
                int n3 = 1;
                while (n3 < n2) {
                    block9: {
                        int n4 = aminoPolymer.monomers[n3].leadAtomIndex;
                        if (this.bsBad.get(n4)) break block9;
                        int n5 = n;
                        while (n5 < nArray.length) {
                            block10: {
                                if (!(this.bioPolymers[n5] instanceof AminoPolymer)) break block10;
                                int n6 = n == n5 ? n3 + 3 : 1;
                                while (n6 < nArray[n5].length - 1) {
                                    block11: {
                                        int n7;
                                        block12: {
                                            AminoPolymer aminoPolymer2 = (AminoPolymer)this.bioPolymers[n5];
                                            n7 = aminoPolymer2.monomers[n6].leadAtomIndex;
                                            if (this.bsBad.get(n7)) break block11;
                                            bridge = this.getBridge(nArray, n, n3, n5, n6, this.bridgesP, atomArray[n4], atomArray[n7], aminoPolymer, aminoPolymer2, hashtable, false);
                                            if (bridge != null) break block12;
                                            bridge = this.getBridge(nArray, n, n3, n5, n6, this.bridgesA, atomArray[n4], atomArray[n7], aminoPolymer, aminoPolymer2, hashtable, true);
                                            if (bridge == null) break block11;
                                            bridge.isAntiparallel = true;
                                        }
                                        if (Logger.debugging) {
                                            Logger.debug("Bridge found " + bridge);
                                        }
                                        this.done[n].set(n3);
                                        this.done[n5].set(n6);
                                        this.htBridges.put(String.valueOf(n4) + "-" + n7, bridge);
                                    }
                                    ++n6;
                                }
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private Bridge getBridge(int[][][][] nArray, int n, int n2, int n3, int n4, Lst<Bridge> lst, Atom atom, Atom atom2, AminoPolymer aminoPolymer, AminoPolymer aminoPolymer2, Map<String, Boolean> map, boolean bl) {
        block5: {
            int[] nArray2;
            int n5;
            int[] nArray3;
            int[] nArray4;
            block4: {
                nArray4 = null;
                nArray3 = null;
                n5 = 0;
                nArray2 = bl ? this.sheetOffsets[1] : this.sheetOffsets[0];
                nArray4 = this.isHbonded(n2 + nArray2[0], n4 + nArray2[1], n, n3, nArray);
                if (nArray4 != null && (nArray3 = this.isHbonded(n4 + nArray2[2], n2 + nArray2[3], n3, n, nArray)) != null) break block4;
                n5 = 4;
                nArray4 = this.isHbonded(n2 + nArray2[4], n4 + nArray2[5], n, n3, nArray);
                if (nArray4 == null || (nArray3 = this.isHbonded(n4 + nArray2[6], n2 + nArray2[7], n3, n, nArray)) == null) break block5;
            }
            Bridge bridge = new Bridge(atom, atom2, this.htLadders);
            lst.addLast(bridge);
            if (this.vHBonds != null) {
                int n6 = bl ? 14336 : 6144;
                this.addHbond(aminoPolymer.monomers[n2 + nArray2[n5]], aminoPolymer2.monomers[n4 + nArray2[++n5]], nArray4[2], n6, map);
                this.addHbond(aminoPolymer2.monomers[n4 + nArray2[++n5]], aminoPolymer.monomers[n2 + nArray2[++n5]], nArray3[2], n6, map);
            }
            return bridge;
        }
        return null;
    }

    private void addHbond(Monomer monomer, Monomer monomer2, int n, int n2, Map<String, Boolean> map) {
        Atom atom = ((AminoMonomer)monomer).getNitrogenAtom();
        Atom atom2 = ((AminoMonomer)monomer2).getCarbonylOxygenAtom();
        if (map != null) {
            String string = String.valueOf(atom.i) + " " + atom2.i;
            if (map.containsKey(string)) {
                return;
            }
            map.put(string, Boolean.TRUE);
        }
        this.vHBonds.addLast(new HBond(atom, atom2, n2, 1, 0, (float)n / 1000.0f));
    }

    private void getSheetStructures() {
        if (this.bridgesA.size() == 0 && this.bridgesP.size() == 0) {
            return;
        }
        this.createLadders(this.bridgesA, true);
        this.createLadders(this.bridgesP, false);
        BS bS = new BS();
        BS bS2 = new BS();
        for (int[][] object2 : this.htLadders.keySet()) {
            if (object2[0][0] == object2[0][1] && object2[1][0] == object2[1][1]) {
                bS2.set(object2[0][0]);
                bS2.set(object2[1][0]);
                continue;
            }
            bS.setBits(object2[0][0], object2[0][1] + 1);
            bS.setBits(object2[1][0], object2[1][1] + 1);
        }
        BS bS3 = new BS();
        BS bS32 = new BS();
        int n = this.bioPolymers.length;
        while (--n >= 0) {
            if (!(this.bioPolymers[n] instanceof AminoPolymer)) continue;
            bS3.clearAll();
            bS32.clearAll();
            AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
            int n2 = 0;
            while (n2 < aminoPolymer.monomerCount) {
                int n3 = aminoPolymer.monomers[n2].leadAtomIndex;
                if (bS.get(n3)) {
                    int n4 = n2 + 1;
                    while (n4 < aminoPolymer.monomerCount && bS.get(aminoPolymer.monomers[n4].leadAtomIndex)) {
                        ++n4;
                    }
                    bS3.setBits(n2, n4);
                    n2 = n4;
                    continue;
                }
                if (bS2.get(n3)) {
                    bS32.set(n2);
                }
                ++n2;
            }
            if (this.doReport) {
                this.setTag(this.labels[n], bS32, 'B');
                this.setTag(this.labels[n], bS3, 'E');
            }
            if (this.setStructure) {
                aminoPolymer.setStructureBS(0, 3, STR.SHEET, bS3, false);
            }
            this.done[n].or(bS3);
            this.done[n].or(bS32);
        }
    }

    private void createLadders(Lst<Bridge> lst, boolean bl) {
        int n = bl ? -1 : 1;
        int n2 = lst.size();
        int n3 = 0;
        while (n3 < n2) {
            this.checkBridge((Bridge)lst.get(n3), bl, 1, n);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.checkBulge((Bridge)lst.get(n3), bl, 1);
            ++n3;
        }
    }

    private boolean checkBridge(Bridge bridge, boolean bl, int n, int n2) {
        Bridge bridge2 = this.htBridges.get(String.valueOf(bridge.a.getOffsetResidueAtom("\u0000", n)) + "-" + bridge.b.getOffsetResidueAtom("\u0000", n2));
        return bridge2 != null && bridge.addBridge(bridge2, this.htLadders);
    }

    private void checkBulge(Bridge bridge, boolean bl, int n) {
        int n2 = bl ? -1 : 1;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = n3 == 0 ? 1 : 0;
            while (n4 < 6) {
                this.checkBridge(bridge, bl, n3 * n, n4 * n2);
                if (n4 > n3) {
                    this.checkBridge(bridge, bl, n4 * n, n3 * n2);
                }
                ++n4;
            }
            ++n3;
        }
    }

    private String dumpSummary(AminoPolymer aminoPolymer, char[] cArray) {
        Atom atom = aminoPolymer.monomers[0].getLeadAtom();
        int n = atom.getChainID();
        String string = n == 0 ? "" : String.valueOf(atom.getChainIDStr()) + ":";
        SB sB = new SB();
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n2 = -1;
        int n3 = -1;
        int n4 = aminoPolymer.monomerCount;
        Monomer[] monomerArray = aminoPolymer.monomers;
        int n5 = 0;
        while (n5 <= n4) {
            if (n5 == n4 || cArray[n5] != c) {
                if (c != '\u0000') {
                    sB.appendC('\n').appendC(c).append(" : ").append(string).appendI(n2).append(c2 == '\u0000' ? "" : String.valueOf(c2)).append("_").append(string).appendI(n3).append(c3 == '\u0000' ? "" : String.valueOf(c3));
                }
                if (n5 == n4) break;
                c = cArray[n5];
                n2 = monomerArray[n5].getResno();
                c2 = monomerArray[n5].getInsertionCode();
            }
            n3 = monomerArray[n5].getResno();
            c3 = monomerArray[n5].getInsertionCode();
            ++n5;
        }
        return sB.toString();
    }

    private String dumpTags(AminoPolymer aminoPolymer, String string, BS bS, int n) {
        String string2 = String.valueOf(aminoPolymer.monomers[0].getLeadAtom().getChainID()) + "." + (aminoPolymer.bioPolymerIndexInModel + 1);
        string = PT.rep(string, "$", string2);
        int n2 = aminoPolymer.monomers[0].getResno();
        String string3 = "\n" + string2;
        SB sB = new SB();
        SB sB2 = new SB().append(String.valueOf(string3) + ".8: ");
        SB sB3 = new SB().append(String.valueOf(string3) + ".7: ");
        SB sB4 = new SB().append(String.valueOf(string3) + ".6: ");
        SB sB5 = new SB().append(String.valueOf(string3) + ".0: ");
        int n3 = n2;
        int n4 = aminoPolymer.monomerCount;
        int n5 = 0;
        while (n5 < n4) {
            n3 = aminoPolymer.monomers[n5].getResno();
            sB2.append(n3 % 100 == 0 ? "" + n3 / 100 % 100 : " ");
            sB3.append(n3 % 10 == 0 ? "" + n3 / 10 % 10 : " ");
            sB4.appendI(n3 % 10);
            sB5.appendC(bS.get(aminoPolymer.monomers[n5].leadAtomIndex) ? (char)'!' : aminoPolymer.monomers[n5].getGroup1());
            ++n5;
        }
        if ((n & 1) == 1) {
            sB.appendSB(sB2).appendSB(sB3).appendSB(sB4);
        }
        sB.append("\n");
        sB.append(string);
        if ((n & 2) == 2) {
            sB.appendSB(sB5);
            sB.append("\n\n");
        }
        return sB.toString().replace('\u0000', '.');
    }

    private int[] isHbonded(int n, int n2, int n3, int n4, int[][][][] nArray) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[][][] nArray2 = nArray[n3];
        int[][][] nArray3 = nArray[n4];
        if (n >= nArray2.length || n2 >= nArray3.length) {
            return null;
        }
        return nArray2[n][0][0] == n4 && nArray2[n][0][1] == n2 ? nArray2[n][0] : (nArray2[n][1][0] == n4 && nArray2[n][1][1] == n2 ? nArray2[n][1] : null);
    }

    private String findHelixes(int n, int[][][] nArray) {
        String string;
        String string2;
        String string3;
        AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
        if (Logger.debugging) {
            int n2 = 0;
            while (n2 < aminoPolymer.monomerCount) {
                Logger.debug(String.valueOf(n) + "." + aminoPolymer.monomers[n2].getResno() + "\t" + Escape.e(nArray[n2]));
                ++n2;
            }
        }
        BS bS = new BS();
        if (this.isDSSP2) {
            string3 = this.findHelixes2(0, n, 5, nArray, STR.HELIXPI, 12288, bS, true);
            string2 = this.findHelixes2(2, n, 4, nArray, STR.HELIXALPHA, 10240, bS, false);
            string = this.findHelixes2(4, n, 3, nArray, STR.HELIX310, 8192, bS, false);
        } else {
            string2 = this.findHelixes2(2, n, 4, nArray, STR.HELIXALPHA, 10240, bS, true);
            string = this.findHelixes2(4, n, 3, nArray, STR.HELIX310, 8192, bS, false);
            string3 = this.findHelixes2(0, n, 5, nArray, STR.HELIXPI, 12288, bS, false);
        }
        if (this.setStructure) {
            aminoPolymer.setStructureBS(0, 6, STR.TURN, bS, false);
        }
        if (this.doReport) {
            this.setTag(this.labels[n], bS, 'T');
            return this.dumpTags(aminoPolymer, "$.5: " + string3 + "\n" + "$.4: " + string2 + "\n" + "$.3: " + string, this.bsBad, 1);
        }
        return "";
    }

    private String findHelixes2(int n, int n2, int n3, int[][][] nArray, STR sTR, int n4, BS bS, boolean bl) {
        char[] cArray;
        AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n2];
        BS bS2 = new BS();
        BS bS3 = new BS();
        BS bS4 = new BS();
        BS bS5 = new BS();
        BS bS6 = new BS();
        BS bS7 = this.done[n2];
        String string = "";
        int n5 = aminoPolymer.monomerCount;
        int n6 = n3;
        while (n6 < n5) {
            block16: {
                int n7;
                int n8;
                block15: {
                    n8 = n6 - n3;
                    n7 = 0;
                    if (nArray[n6][0][0] == n2 && nArray[n6][0][1] == n8) break block15;
                    n7 = 1;
                    if (nArray[n6][1][0] != n2 || nArray[n6][1][1] != n8) break block16;
                }
                int n9 = aminoPolymer.monomers[n8].leadAtomIndex;
                int n10 = this.bsBad.nextSetBit(n9);
                Monomer monomer = aminoPolymer.monomers[n6];
                if (n10 < n9 || n10 > monomer.leadAtomIndex) {
                    bS2.set(n8);
                    bS3.setBits(n8 + 1, n6);
                    bS5.set(n6);
                    n10 = bS7.nextSetBit(n8);
                    boolean bl2 = n10 < 0 || n10 >= n6;
                    boolean bl3 = false;
                    if (n8 > 0 && bS2.get(n8 - 1) && (bl || bl2)) {
                        bS6.setBits(n8, n6);
                        if (!bl2) {
                            string = String.valueOf(string) + "  WARNING! Bridge to helix at " + aminoPolymer.monomers[n10];
                        }
                        bl3 = true;
                    } else if (bl2 || bS7.nextClearBit(n10) < n6) {
                        bl3 = true;
                    }
                    if (bS5.get(n8)) {
                        bS4.set(n8);
                    }
                    if (bl3 && this.vHBonds != null) {
                        this.addHbond(monomer, aminoPolymer.monomers[n8], nArray[n6][n7][2], n4, null);
                    }
                }
            }
            ++n6;
        }
        if (this.doReport) {
            cArray = new char[n5];
            this.setTag(cArray, bS3, (char)(48 + n3));
            this.setTag(cArray, bS2, '>');
            this.setTag(cArray, bS5, '<');
            this.setTag(cArray, bS4, 'X');
        } else {
            cArray = null;
        }
        bS7.or(bS6);
        bS3.andNot(bS7);
        bS.or(bS3);
        bS.andNot(bS6);
        if (this.setStructure) {
            aminoPolymer.setStructureBS(0, n, sTR, bS6, false);
        }
        if (this.doReport) {
            this.setTag(this.labels[n2], bS6, (char)(68 + n3));
            return String.valueOf(String.valueOf(cArray)) + string;
        }
        return "";
    }

    private void setTag(char[] cArray, BS bS, char c) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            cArray[n] = c;
            n = bS.nextSetBit(n + 1);
        }
    }
}

