/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.server.DatabaseLogEntry;

public class DatabaseCheckErrorLogEntry
extends DatabaseLogEntry {
    private final Calendar date;
    private final String type;
    private final Long server;
    private final Long client;
    private final Long user;
    private final Language languageSet;
    private final Language languageDetected;
    private final int textLength;
    private final String extra;

    public DatabaseCheckErrorLogEntry(String type, Long server, Long client, Long user, Language languageSet, Language languageDetected, int textLength, String extra) {
        this.type = type;
        this.server = server;
        this.client = client;
        this.user = user;
        this.languageSet = languageSet;
        this.languageDetected = languageDetected;
        this.textLength = textLength;
        this.extra = extra;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parameters.put("type", this.type);
        parameters.put("date", dateFormat.format(this.date.getTime()));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("language", this.languageSet.getShortCodeWithCountryAndVariant());
        parameters.put("language_detected", this.languageDetected.getShortCodeWithCountryAndVariant());
        parameters.put("text_length", this.textLength);
        parameters.put("extra", this.extra);
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.checkError";
    }

    @Override
    public void followup(Map<Object, Object> parameters) {
    }
}

