/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShaderAttributeSetRetained
extends NodeComponentRetained {
    private Map<String, ShaderAttributeRetained> attrs = new HashMap<String, ShaderAttributeRetained>();
    Object liveStateLock = new Object();

    ShaderAttributeSetRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(ShaderAttribute shaderAttribute) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)shaderAttribute.retained;
            assert (shaderAttributeRetained != null);
            this.attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
            if (this.source.isLive()) {
                shaderAttributeRetained.setLive(this.inBackgroundGroup, this.refCount);
                shaderAttributeRetained.copyMirrorUsers(this);
                this.sendMessage(1, shaderAttributeRetained.mirror);
            }
        }
    }

    ShaderAttribute get(String string) {
        return (ShaderAttribute)this.attrs.get((Object)string).source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String string) {
        Object object = this.liveStateLock;
        synchronized (object) {
            ShaderAttributeRetained shaderAttributeRetained = this.attrs.get(string);
            this.attrs.remove(string);
            if (this.source.isLive()) {
                shaderAttributeRetained.clearLive(this.refCount);
                shaderAttributeRetained.removeMirrorUsers(this);
                this.sendMessage(2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ShaderAttribute shaderAttribute) {
        Object object = this.liveStateLock;
        synchronized (object) {
            String string = shaderAttribute.getAttributeName();
            if (this.attrs.get(string) == shaderAttribute.retained) {
                this.attrs.remove(string);
                if (this.source.isLive()) {
                    ((ShaderAttributeRetained)shaderAttribute.retained).clearLive(this.refCount);
                    ((ShaderAttributeRetained)shaderAttribute.retained).removeMirrorUsers(this);
                    this.sendMessage(2, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.liveStateLock;
        synchronized (object) {
            this.attrs.clear();
            if (this.source.isLive()) {
                ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
                shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
                for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
                    shaderAttributeRetainedArray[i].clearLive(this.refCount);
                    shaderAttributeRetainedArray[i].removeMirrorUsers(this);
                }
                this.sendMessage(4, null);
            }
        }
    }

    ShaderAttribute[] getAll() {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        ShaderAttribute[] shaderAttributeArray = new ShaderAttribute[shaderAttributeRetainedArray.length];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeArray[i] = (ShaderAttribute)shaderAttributeRetainedArray[i].source;
        }
        return shaderAttributeArray;
    }

    int size() {
        return this.attrs.size();
    }

    void updateNative(Canvas3D canvas3D, ShaderProgramRetained shaderProgramRetained) {
        shaderProgramRetained.setShaderAttributes(canvas3D, this);
    }

    Map<String, ShaderAttributeRetained> getAttrs() {
        return this.attrs;
    }

    @Override
    void setLive(boolean bl, int n) {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].setLive(bl, n);
        }
        super.doSetLive(bl, n);
        super.markAsLive();
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape3DRetained) {
        super.addAMirrorUser(shape3DRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].addAMirrorUser(shape3DRetained);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape3DRetained) {
        super.removeAMirrorUser(shape3DRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].removeAMirrorUser(shape3DRetained);
        }
    }

    @Override
    synchronized void removeMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.removeMirrorUsers(nodeComponentRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].removeMirrorUsers(nodeComponentRetained);
        }
    }

    @Override
    synchronized void copyMirrorUsers(NodeComponentRetained nodeComponentRetained) {
        super.copyMirrorUsers(nodeComponentRetained);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].copyMirrorUsers(nodeComponentRetained);
        }
    }

    @Override
    void clearLive(int n) {
        super.clearLive(n);
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            shaderAttributeRetainedArray[i].clearLive(n);
        }
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeSetRetained shaderAttributeSetRetained = new ShaderAttributeSetRetained();
            this.mirror = shaderAttributeSetRetained;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    @Override
    void initMirrorObject() {
        ShaderAttributeRetained[] shaderAttributeRetainedArray = new ShaderAttributeRetained[this.attrs.size()];
        shaderAttributeRetainedArray = this.attrs.values().toArray(shaderAttributeRetainedArray);
        for (int i = 0; i < shaderAttributeRetainedArray.length; ++i) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)shaderAttributeRetainedArray[i].mirror;
            assert (shaderAttributeRetained != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
        }
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        ShaderAttributeSetRetained shaderAttributeSetRetained = (ShaderAttributeSetRetained)this.mirror;
        if ((n & 1) != 0) {
            ShaderAttributeRetained shaderAttributeRetained = (ShaderAttributeRetained)object;
            assert (shaderAttributeRetained != null);
            ((ShaderAttributeSetRetained)this.mirror).attrs.put(shaderAttributeRetained.attrName, shaderAttributeRetained);
        } else if ((n & 2) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrs.remove((String)object);
        } else if ((n & 4) != 0) {
            ((ShaderAttributeSetRetained)this.mirror).attrs.clear();
        } else assert (false);
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 64;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 64;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    void setFrequencyChangeMask(int n, int n2) {
        if (this.source.getCapability(n)) {
            this.changedFrequent |= n2;
        } else if (!this.source.isLive()) {
            this.changedFrequent &= ~n2;
        }
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 1) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

