/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg;

import com.sun.webpane.platform.UIClient;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.sg.Accessor;
import java.io.File;
import javafx.geometry.Rectangle2D;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class UIClientImpl
implements UIClient {
    private Accessor accessor;
    private FileChooser chooser;
    private ClipboardContent content;

    public UIClientImpl(Accessor accessor) {
        this.accessor = accessor;
    }

    private WebEngine getWebEngine() {
        return this.accessor.getEngine();
    }

    @Override
    public WebPage createPage(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getCreatePopupHandler() != null) {
            WebEngine webEngine2 = webEngine.getCreatePopupHandler().call(new PopupFeatures(bl, bl2, bl3, bl4));
            return Accessor.getPageFor(webEngine2);
        }
        return null;
    }

    @Override
    public void closePage() {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getOnVisibilityChanged() != null) {
            webEngine.getOnVisibilityChanged().handle(new WebEvent<Boolean>((Object)webEngine, WebEvent.VISIBILITY_CHANGED, false));
        }
    }

    @Override
    public void showView() {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getOnVisibilityChanged() != null) {
            webEngine.getOnVisibilityChanged().handle(new WebEvent<Boolean>((Object)webEngine, WebEvent.VISIBILITY_CHANGED, true));
        }
    }

    @Override
    public WCRectangle getViewBounds() {
        WebView webView = this.accessor.getView();
        Window window = null;
        if (webView != null && webView.getScene() != null && (window = webView.getScene().getWindow()) != null) {
            return new WCRectangle((float)window.getX(), (float)window.getY(), (float)window.getWidth(), (float)window.getHeight());
        }
        return null;
    }

    @Override
    public void setViewBounds(WCRectangle wCRectangle) {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getOnResized() != null) {
            WebEvent<Rectangle2D> webEvent = new WebEvent<Rectangle2D>((Object)webEngine, WebEvent.RESIZED, new Rectangle2D(wCRectangle.getX(), wCRectangle.getY(), wCRectangle.getWidth(), wCRectangle.getHeight()));
            webEngine.getOnResized().handle(webEvent);
        }
    }

    @Override
    public void setStatusbarText(String string) {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getOnStatusChanged() != null) {
            webEngine.getOnStatusChanged().handle(new WebEvent<String>((Object)webEngine, WebEvent.STATUS_CHANGED, string));
        }
    }

    @Override
    public void alert(String string) {
        WebEngine webEngine = this.getWebEngine();
        if (webEngine != null && webEngine.getOnAlert() != null) {
            webEngine.getOnAlert().handle(new WebEvent<String>((Object)webEngine, WebEvent.ALERT, string));
        }
    }

    @Override
    public boolean confirm(String string) {
        WebEngine webEngine = this.getWebEngine();
        return webEngine != null && webEngine.getConfirmHandler() != null ? webEngine.getConfirmHandler().call(string) : false;
    }

    @Override
    public String prompt(String string, String string2) {
        WebEngine webEngine = this.getWebEngine();
        return webEngine != null && webEngine.getPromptHandler() != null ? webEngine.getPromptHandler().call(new PromptData(string, string2)) : "";
    }

    @Override
    public String chooseFile(String string) {
        File file;
        Window window = null;
        WebView webView = this.accessor.getView();
        if (webView != null && webView.getScene() != null) {
            window = webView.getScene().getWindow();
        }
        if (this.chooser == null) {
            this.chooser = new FileChooser();
        }
        if (string != null) {
            for (file = new File(string); file != null && !file.isDirectory(); file = file.getParentFile()) {
            }
            this.chooser.setInitialDirectory(file);
        }
        return (file = this.chooser.showOpenDialog(window)) != null ? file.getAbsolutePath() : null;
    }

    @Override
    public void print() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataFormat getDataFormat(String string) {
        Class<DataFormat> clazz = DataFormat.class;
        synchronized (DataFormat.class) {
            DataFormat dataFormat = DataFormat.lookupMimeType(string);
            if (dataFormat == null) {
                dataFormat = new DataFormat(string);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dataFormat;
        }
    }

    @Override
    public void startDrag(WCImage wCImage, int n, int n2, int n3, int n4, String[] stringArray, Object[] objectArray) {
        this.content = new ClipboardContent();
        for (int i = 0; i < stringArray.length; ++i) {
            this.content.put(UIClientImpl.getDataFormat(stringArray[i]), objectArray[i]);
        }
    }

    @Override
    public void confirmStartDrag() {
        WebView webView = this.accessor.getView();
        if (webView != null && this.content != null) {
            Dragboard dragboard = webView.startDragAndDrop(TransferMode.ANY);
            dragboard.setContent(this.content);
        }
        this.content = null;
    }

    @Override
    public boolean isDragConfirmed() {
        return this.accessor.getView() != null && this.content != null;
    }
}

