// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 *
 **/
public interface LocatorRegistryPrx extends ObjectPrx
{
    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     **/
    public void setAdapterDirectProxy(String id, Ice.ObjectPrx proxy)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, java.util.Map<String, String> context)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, java.util.Map<String, String> context);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, Callback cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, java.util.Map<String, String> context, Callback cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, Callback_LocatorRegistry_setAdapterDirectProxy cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id, Ice.ObjectPrx proxy, java.util.Map<String, String> context, Callback_LocatorRegistry_setAdapterDirectProxy cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id,
                                                       Ice.ObjectPrx proxy,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id,
                                                       Ice.ObjectPrx proxy,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id,
                                                       Ice.ObjectPrx proxy,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setAdapterDirectProxy(String id,
                                                       Ice.ObjectPrx proxy,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param result The asynchronous result object.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     **/
    public void end_setAdapterDirectProxy(Ice.AsyncResult result)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     * @throws InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     *
     **/
    public void setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException,
               InvalidReplicaGroupIdException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     * @throws InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, java.util.Map<String, String> context)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException,
               InvalidReplicaGroupIdException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, java.util.Map<String, String> context);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, Callback cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, java.util.Map<String, String> context, Callback cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, Callback_LocatorRegistry_setReplicatedAdapterDirectProxy cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId, String replicaGroupId, Ice.ObjectPrx p, java.util.Map<String, String> context, Callback_LocatorRegistry_setReplicatedAdapterDirectProxy cb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId,
                                                                 String replicaGroupId,
                                                                 Ice.ObjectPrx p,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId,
                                                                 String replicaGroupId,
                                                                 Ice.ObjectPrx p,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId,
                                                                 String replicaGroupId,
                                                                 Ice.ObjectPrx p,
                                                                 java.util.Map<String, String> context,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setReplicatedAdapterDirectProxy(String adapterId,
                                                                 String replicaGroupId,
                                                                 Ice.ObjectPrx p,
                                                                 java.util.Map<String, String> context,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param result The asynchronous result object.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     * @throws InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     *
     **/
    public void end_setReplicatedAdapterDirectProxy(Ice.AsyncResult result)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException,
               InvalidReplicaGroupIdException;

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @throws ServerNotFoundException Raised if the server cannot
     * be found.
     *
     **/
    public void setServerProcessProxy(String id, ProcessPrx proxy)
        throws ServerNotFoundException;

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @throws ServerNotFoundException Raised if the server cannot
     * be found.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setServerProcessProxy(String id, ProcessPrx proxy, java.util.Map<String, String> context)
        throws ServerNotFoundException;

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy, java.util.Map<String, String> context);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy, Callback cb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy, java.util.Map<String, String> context, Callback cb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy, Callback_LocatorRegistry_setServerProcessProxy cb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id, ProcessPrx proxy, java.util.Map<String, String> context, Callback_LocatorRegistry_setServerProcessProxy cb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id,
                                                       ProcessPrx proxy,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id,
                                                       ProcessPrx proxy,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id,
                                                       ProcessPrx proxy,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Set the process proxy for a server.
     *
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setServerProcessProxy(String id,
                                                       ProcessPrx proxy,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_VoidCallback responseCb,
                                                       IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the process proxy for a server.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotFoundException Raised if the server cannot
     * be found.
     *
     **/
    public void end_setServerProcessProxy(Ice.AsyncResult result)
        throws ServerNotFoundException;
}
