/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "\u0433\u0443\u045f\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_bas = "\u0431\u0430\u0441\u0430";
        final String metaValue_nqo = "\u043d\u043a\u043e";
        final String metaValue_vai = "\u0432\u0430\u0458";
        final String metaValue_zbl = "\u0431\u043b\u0438\u0441\u0441\u0438\u043c\u0431\u043e\u043b\u0438";
        final Object[][] data = new Object[][] {
            { "ksh", "\u043a\u043e\u043b\u043e\u045a\u0441\u043a\u0438" },
            { "Ogam", "\u043e\u0433\u0430\u043c" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "Zsym", "\u0441\u0438\u043c\u0431\u043e\u043b\u0438" },
            { "cch", "\u0430\u0446\u0430\u043c" },
            { "mwr", "\u043c\u0430\u0440\u0432\u0430\u0440\u0438" },
            { "egl", "\u0435\u043c\u0438\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "Tagb", "\u0442\u0430\u0433\u0431\u0430\u043d\u0432\u0430\u043d\u0441\u043a\u043e" },
            { "Zsye", "\u0435\u043c\u043e\u045f\u0438" },
            { "xmf", "\u043c\u0435\u0433\u0440\u0435\u043b\u0441\u043a\u0438" },
            { "egy", "\u0441\u0442\u0430\u0440\u043e\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438" },
            { "raj", "\u0440\u0430\u045f\u0430\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "Phag", "\u043f\u0430\u0433\u0441\u043f\u0430" },
            { "tem", "\u0442\u0438\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0458\u0441\u043a\u0438" },
            { "ter", "\u0442\u0435\u0440\u0435\u043d\u043e" },
            { "AC", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0410\u0441\u0435\u043d\u0441\u0438\u043e\u043d" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u043a\u0438" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0430" },
            { "AE", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "AF", "\u0410\u0432\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "type.ca.ethiopic", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "glk", "\u0433\u0438\u043b\u0430\u043d\u0441\u043a\u0438" },
            { "AI", "\u0410\u043d\u0433\u0432\u0438\u043b\u0430" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430" },
            { "AM", "\u0415\u0440\u043c\u0435\u043d\u0438\u0458\u0430" },
            { "Teng", "\u0442\u0435\u043d\u0433\u0432\u0430\u0440" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "Prti", "\u043d\u0430\u0442\u043f\u0438\u0441\u043d\u043e \u043f\u0430\u0440\u0442\u0438\u0441\u043a\u043e" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u0458\u0430" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "AX", "\u041e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "mye", "\u043c\u0458\u0435\u043d\u0435" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "kum", "\u043a\u0443\u043c\u0438\u0447\u043a\u0438" },
            { "BE", "\u0411\u0435\u043b\u0433\u0438\u0458\u0430" },
            { "gmh", "\u0441\u0440\u0435\u0434\u043d\u043e\u0433\u043e\u0440\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u0443\u0433\u0430\u0440\u0438\u0458\u0430" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0438\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0432\u0435\u0442\u0438 \u0412\u0430\u0440\u0442\u043e\u043b\u043e\u043c\u0435\u0458" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0438" },
            { "kut", "\u043a\u0443\u0442\u0435\u043d\u0430\u0458\u0441\u043a\u0438" },
            { "myv", "\u0435\u0440\u0437\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0458" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430" },
            { "BQ", "\u041a\u0430\u0440\u0438\u043f\u0441\u043a\u0430 \u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b" },
            { "BS", "\u0411\u0430\u0445\u0430\u043c\u0438" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0411\u0443\u0432\u0435" },
            { "BW", "\u0411\u043e\u0446\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0458\u0430" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437\u0435" },
            { "Visp", "\u0432\u0438\u0434\u043b\u0438\u0432 \u0433\u043e\u0432\u043e\u0440" },
            { "type.ca.persian", "\u041f\u0435\u0440\u0441\u0438\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.nu.hebr", "\u0425\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0438 (\u041a\u0438\u043b\u0438\u043d\u0448\u043a\u0438) \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "mzn", "\u043c\u0430\u0437\u0435\u043d\u0434\u0435\u0440\u0430\u043d\u0441\u043a\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e - \u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0430\u0432\u0438\u043b" },
            { "CH", "\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0438\u0458\u0430" },
            { "CI", "\u0411\u0440\u0435\u0433\u043e\u0442 \u043d\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0442\u0430 \u041a\u043e\u0441\u043a\u0430" },
            { "CK", "\u041a\u0443\u043a\u043e\u0432\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "CL", "\u0427\u0438\u043b\u0435" },
            { "Kthi", "\u043a\u0430\u0458\u0442\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0438\u043d\u0430" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430" },
            { "CP", "\u041e\u0441\u0442\u0440\u043e\u0432 \u041a\u043b\u0438\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u0417\u0435\u043b\u0435\u043d \u2019\u0420\u0442" },
            { "CW", "\u041a\u0443\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0411\u043e\u0436\u0438\u045c\u0435\u043d \u041e\u0441\u0442\u0440\u043e\u0432" },
            { "CY", "\u041a\u0438\u043f\u0430\u0440" },
            { "CZ", "\u0427\u0435\u0448\u043a\u0430" },
            { "eka", "\u0435\u043a\u0430\u045f\u0443\u043a" },
            { "Pauc", "\u041f\u0430\u0443\u0447\u0438\u043d\u0445\u0430\u0443\u043e\u0432\u043e" },
            { "vls", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0444\u043b\u0430\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u0458\u0430" },
            { "goh", "\u0441\u0442\u0430\u0440\u043e\u0433\u043e\u0440\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "ace", "\u0430\u0447\u0435\u0448\u043a\u0438" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0458\u0430" },
            { "gom", "\u0433\u043e\u0430\u043d\u0441\u043a\u0438 \u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "type.nu.deva", "\u0414\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "DJ", "\u040f\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0441\u043a\u0430" },
            { "ach", "\u0430\u043a\u043e\u043b\u0438" },
            { "gon", "\u0433\u043e\u043d\u0434\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0458\u043e\u0432\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Brah", "\u0431\u0440\u0430\u043c\u0438" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "type.nu.armnlow", "\u0415\u0440\u043c\u0435\u043d\u0441\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "got", "\u0433\u043e\u0442\u0441\u043a\u0438" },
            { "vmf", "\u043c\u0430\u0458\u043d\u0441\u043a\u043e\u0444\u0440\u0430\u043d\u043a\u043e\u043d\u0441\u043a\u0438" },
            { "Mtei", "\u043c\u0435\u0458\u0442\u0435\u0458\u0441\u043a\u043e" },
            { "zun", "\u0437\u0443\u043d\u0438" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "Takr", "\u0442\u0430\u043a\u0440\u0438" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d\u0441\u043a\u0438" },
            { "pal", "\u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0438 \u041c\u0435\u043b\u0438\u0459\u0430" },
            { "chb", "\u0447\u0438\u0431\u0447\u0430" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "EC", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u0438\u0458\u0430\u043c\u0435\u043d\u0442\u043e" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "EE", "\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430" },
            { "tiv", "\u0442\u0438\u0432" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "chg", "\u0447\u0430\u0433\u0430\u0442\u0430\u0458\u0441\u043a\u0438" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "chk", "\u0447\u0443\u0447\u043a\u0438" },
            { "chn", "\u0447\u0438\u043d\u0443\u0447\u043a\u0438 \u0436\u0430\u0440\u0433\u043e\u043d" },
            { "chm", "\u043c\u0430\u0440\u0438\u0441\u043a\u0438" },
            { "chp", "\u0447\u0438\u043f\u0435\u0432\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0441\u043a\u0438" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438\u0441\u043a\u0438" },
            { "ER", "\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430" },
            { "ES", "\u0428\u043f\u0430\u043d\u0438\u0458\u0430" },
            { "ET", "\u0415\u0442\u0438\u043e\u043f\u0438\u0458\u0430" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0441\u043a\u0430 \u0443\u043d\u0438\u0458\u0430" },
            { "elx", "\u0435\u043b\u0430\u043c\u0441\u043a\u0438" },
            { "type.ca.gregorian", "\u0413\u0440\u0435\u0433\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "EZ", "\u0415\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "chy", "\u0447\u0435\u0458\u0435\u043d\u0441\u043a\u0438" },
            { "type.nu.gujr", "\u0413\u0443\u045f\u0430\u0440\u0430\u0442\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "Inds", "\u0445\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0458\u0441\u043a\u0438" },
            { "aeb", "\u0442\u0443\u043d\u0438\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "FI", "\u0424\u0438\u043d\u0441\u043a\u0430" },
            { "FJ", "\u0424\u0438\u045f\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "FO", "\u0424\u0430\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "Taml", "\u0442\u0430\u043c\u0438\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u0458\u0430" },
            { "Kpel", "\u043a\u043f\u0435\u043b\u0441\u043a\u043e" },
            { "pcd", "\u043f\u0438\u043a\u0430\u0440\u0434\u0441\u043a\u0438" },
            { "tkl", "\u0442\u043e\u043a\u0435\u043b\u0430\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "grb", "\u0433\u0440\u0435\u0431\u043e" },
            { "root", "\u043a\u043e\u0440\u0435\u043d" },
            { "type.ca.indian", "\u0418\u043d\u0434\u0438\u0441\u043a\u0438 \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u0435\u043d \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "rgn", "\u0440\u043e\u043c\u0430\u045a\u043e\u043b\u0441\u043a\u0438" },
            { "grc", "\u0441\u0442\u0430\u0440\u043e\u0433\u0440\u0447\u043a\u0438" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "tkr", "\u0446\u0430\u0445\u0443\u0440\u0441\u043a\u0438" },
            { "vot", "\u0432\u043e\u0442\u0441\u043a\u0438" },
            { "GB", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u043e \u041a\u0440\u0430\u043b\u0441\u0442\u0432\u043e" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0441\u043a\u0438 \u043f\u0438\u045f\u0438\u043d" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u0458\u0430" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0437\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "Tale", "\u0442\u0430\u0458 \u043b\u0435" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "afh", "\u0430\u0444\u0440\u0438\u0445\u0438\u043b\u0438" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434" },
            { "enm", "\u0441\u0440\u0435\u0434\u043d\u043e\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GP", "\u0413\u0432\u0430\u0434\u0430\u043b\u0443\u043f\u0435" },
            { "GQ", "\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u043a\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GR", "\u0413\u0440\u0446\u0438\u0458\u0430" },
            { "GS", "\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0438 \u0421\u0435\u043d\u0434\u0432\u0438\u0447\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "pdc", "\u043f\u0435\u043d\u0441\u0438\u043b\u0432\u0430\u043d\u0438\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u0443" },
            { "tli", "\u0442\u043b\u0438\u043d\u0433\u0438\u0442" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d\u0441\u043a\u0438" },
            { "Talu", "\u043d\u043e\u0432\u043e \u0442\u0430\u0458 \u043b\u0443\u0435" },
            { "GY", "\u0413\u0432\u0430\u0458\u0430\u043d\u0430" },
            { "ckb", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "zxx", "\u0431\u0435\u0437 \u043b\u0438\u043d\u0433\u0432\u0438\u0441\u0442\u0438\u0447\u043a\u0430 \u0441\u043e\u0434\u0440\u0436\u0438\u043d\u0430" },
            { "Jurc", "\u045f\u0443\u0440\u0447\u0435\u043d\u0441\u043a\u043e" },
            { "tly", "\u0442\u0430\u043b\u0438\u0448\u043a\u0438" },
            { "pdt", "\u043c\u0435\u043d\u043e\u043d\u0438\u0442\u0441\u043a\u0438 \u0434\u043e\u043b\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 \u0421.\u0410.\u0420 \u041a\u0438\u043d\u0430" },
            { "HM", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0425\u0435\u0440\u0434 \u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434" },
            { "HN", "\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0430" },
            { "agq", "\u0430\u0433\u0435\u043c\u0441\u043a\u0438" },
            { "gsw", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "type.ca.islamic-umalqura", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0423\u043c \u0430\u043b-\u041a\u0443\u0440\u0430)" },
            { "HT", "\u0425\u0430\u0438\u0442\u0438" },
            { "HU", "\u0423\u043d\u0433\u0430\u0440\u0438\u0458\u0430" },
            { "rif", "\u0440\u0438\u0444\u0441\u043a\u0438" },
            { "tmh", "\u0442\u0430\u043c\u0430\u0448\u0435\u043a" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "nan", "\u0458\u0443\u0436\u043d\u043e\u043c\u0438\u043d\u0441\u043a\u0438" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "peo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "IE", "\u0418\u0440\u0441\u043a\u0430" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0441\u043a\u0438" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Tang", "\u0442\u0430\u043d\u0433\u0443\u0442\u0441\u043a\u043e" },
            { "IL", "\u0418\u0437\u0440\u0430\u0435\u043b" },
            { "Nbat", "\u043d\u0430\u0431\u0430\u0442\u0435\u0458\u0441\u043a\u043e" },
            { "IM", "\u041e\u0441\u0442\u0440\u043e\u0432 \u041c\u0430\u043d" },
            { "IN", "\u0418\u043d\u0434\u0438\u0458\u0430" },
            { "type.co.eor", "\u0415\u0432\u0440\u043e\u043f\u0441\u043a\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0437\u0430 \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0418\u043d\u0434\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0430 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u0458\u0430" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u043a\u0430 \u043d\u043e\u0442\u0430\u0446\u0438\u0458\u0430" },
            { "type.nu.thai", "\u0422\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "vro", "\u0432\u0438\u0440\u0443" },
            { "guc", "\u0433\u0432\u0430\u0445\u0438\u0440\u043e" },
            { "type.nu.beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "pfl", "\u0444\u0430\u043b\u0435\u0447\u043a\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "JE", "\u040f\u0435\u0440\u0441\u0438" },
            { "type.ca.islamic", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "JM", "\u0408\u0430\u043c\u0430\u0458\u043a\u0430" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "JO", "\u0408\u043e\u0440\u0434\u0430\u043d" },
            { "gur", "\u0444\u0430\u0440\u0435\u0444\u0430\u0440\u0435" },
            { "JP", "\u0408\u0430\u043f\u043e\u043d\u0438\u0458\u0430" },
            { "ain", "\u0430\u0458\u043d\u0443" },
            { "Mend", "\u043c\u0435\u043d\u0434\u0441\u043a\u043e" },
            { "guz", "\u0433\u0443\u0441\u0438" },
            { "tog", "\u045a\u0430\u0441\u0430 \u0442\u043e\u043d\u0433\u0430" },
            { "type.nu.knda", "\u041a\u0430\u043d\u0430\u0434\u0430 \u0446\u0438\u0444\u0440\u0438" },
            { "Kali", "\u043a\u0430\u0458\u0430 \u043b\u0438" },
            { "Sidd", "\u0441\u0438\u0434\u0430\u043c" },
            { "de_CH", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0432\u0438\u0441\u043e\u043a\u043e-\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "izh", "\u0438\u0436\u043e\u0440\u0441\u043a\u0438" },
            { "type.ca.buddhist", "\u0411\u0443\u0434\u0438\u0441\u0442\u0438\u0447\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "KE", "\u041a\u0435\u043d\u0438\u0458\u0430" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u045f\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "Knda", metaValue_kn },
            { "KN", "\u0421\u0432\u0435\u0442\u0438 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441" },
            { "Zinh", "\u043d\u0430\u0441\u043b\u0435\u0434\u0435\u043d\u043e" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "KP", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "KR", "\u0408\u0443\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "Plrd", "\u041f\u043e\u043b\u0430\u0440\u0434\u043e\u0432\u043e" },
            { "fr_CH", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "KW", "\u041a\u0443\u0432\u0430\u0458\u0442" },
            { "tpi", "\u0442\u043e\u043a \u043f\u0438\u0441\u0438\u043d" },
            { "KY", "\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0431\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442 \u041b\u0443\u0441\u0438\u0458\u0430" },
            { "phn", "\u0444\u0435\u043d\u0438\u043a\u0438\u0441\u043a\u0438" },
            { "Cyrs", "\u0441\u0442\u0430\u0440\u043e\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0430 \u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0430" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d\u0441\u043a\u0438" },
            { "nds", "\u0434\u043e\u043b\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0430\u0458\u043d" },
            { "LK", "\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430" },
            { "akk", "\u0430\u043a\u0430\u0434\u0441\u043a\u0438" },
            { "cop", "\u043a\u043e\u043f\u0442\u0441\u043a\u0438" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430" },
            { "esu", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0458\u0443\u043f\u0438\u0447\u043a\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "Phlv", "\u043a\u043d\u0438\u0436\u0435\u0432\u043d\u043e \u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430\u043d\u0438\u0458\u0430" },
            { "LU", "\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u0458\u0430" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Sora", "\u0441\u043e\u0440\u0430\u043d\u0433 \u0441\u043e\u043c\u043f\u0435\u043d\u0433" },
            { "LY", "\u041b\u0438\u0431\u0438\u0458\u0430" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d\u043e" },
            { "vun", "\u0432\u0443\u043d\u045f\u043e" },
            { "akz", "\u0430\u043b\u0430\u0431\u0430\u043c\u0441\u043a\u0438" },
            { "lah", "\u043b\u0430\u043d\u0434\u0430" },
            { "Mahj", "\u043c\u0430\u0445\u0430\u045f\u0430\u043d\u0438" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432\u0438\u0458\u0430" },
            { "Nshu", "\u043d\u0438\u0448\u0443" },
            { "ME", "\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430" },
            { "MF", "\u0421\u0435\u043d\u0442 \u041c\u0430\u0440\u0442\u0438\u043d" },
            { "lam", "\u043b\u0430\u043c\u0431\u0430" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u0438" },
            { "Thai", "\u0442\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u0458\u0430\u043d\u043c\u0430\u0440 (\u0411\u0443\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u0458\u0430" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u0421\u0410\u0420" },
            { "aln", "\u0433\u0435\u0448\u043a\u0438 \u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "MP", "\u0421\u0435\u0432\u0435\u0440\u043d\u0438 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430" },
            { "MS", "\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u0442\u0430" },
            { "cps", "\u043a\u0430\u043f\u0438\u0437\u043d\u043e\u043d" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u0446\u0438\u0443\u0441" },
            { "alt", "\u0458\u0443\u0436\u043d\u043e\u0430\u043b\u0442\u0430\u0458\u0441\u043a\u0438" },
            { "MV", "\u041c\u0430\u043b\u0434\u0438\u0432\u0438" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u043e" },
            { "type.ca.japanese", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "MY", "\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "Phli", "\u043d\u0430\u0442\u043f\u0438\u0441\u043d\u043e \u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430" },
            { "202", "\u0421\u0443\u043f\u0441\u0430\u0445\u0430\u0440\u0441\u043a\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "type.ca.hebrew", "\u0415\u0432\u0440\u0435\u0458\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.dictionary", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u043f\u043e \u0430\u0437\u0431\u0443\u0447\u0435\u043d \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "NC", "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430" },
            { "%%WADEGILE", "\u0412\u0435\u0458\u0434-\u040f\u0430\u0458\u043b\u0441 \u0440\u043e\u043c\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0458\u0430" },
            { "tru", "\u0442\u0443\u0440\u043e\u0458\u043e" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u0448\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u0458\u0430" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "Phlp", "\u043f\u0441\u0430\u043b\u0442\u0438\u0440\u0441\u043a\u043e \u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0432\u0430" },
            { "Hmng", "\u043f\u0430\u0445\u0430\u0443\u0430\u043d\u0441\u043a\u043e \u0445\u043c\u043e\u043d\u0448\u043a\u043e" },
            { "NL", "\u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "tsd", "\u0446\u0430\u043a\u043e\u043d\u0441\u043a\u0438" },
            { "NU", "\u041d\u0438\u0443\u0458\u0435" },
            { "Phnx", "\u0444\u0435\u043d\u0438\u043a\u0438\u0441\u043a\u043e" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "tsi", "\u0446\u0438\u043c\u0448\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "NZ", "\u041d\u043e\u0432 \u0417\u0435\u043b\u0430\u043d\u0434" },
            { "Merc", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u043e \u0440\u0430\u043a\u043e\u043f\u0438\u0441\u043d\u043e" },
            { "rom", "\u0440\u043e\u043c\u0441\u043a\u0438" },
            { "Mero", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u043e" },
            { "crh", "\u043a\u0440\u0438\u043c\u0441\u043a\u043e\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "ang", "\u0441\u0442\u0430\u0440\u043e\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "crs", "\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438 (\u0421\u0435\u0441\u0435\u043b\u0432\u0430 \u043a\u0440\u0435\u043e\u043b\u0438)" },
            { "Xpeo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "type.ca.islamic-civil", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u0433\u0440\u0430\u0453\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "csb", "\u043a\u0430\u0448\u0443\u043f\u0441\u043a\u0438" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "ttt", "\u0442\u0430\u0442\u0441\u043a\u0438" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u0441\u043a\u0430" },
            { "ewo", "\u0435\u0432\u043e\u043d\u0434\u043e" },
            { "PM", "\u0421\u0435\u043d\u0442 \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u0430\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u0435\u0440\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "PR", "\u041f\u043e\u0440\u0442\u043e\u0440\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0438 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "Bali", "\u0431\u0430\u043b\u0438\u0441\u043a\u043e" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0458\u0430" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "nia", "\u043d\u0438\u0458\u0430\u0441" },
            { "type.nu.greklow", "\u0413\u0440\u0447\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "Hebr", "\u0445\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "jam", "\u0458\u0430\u043c\u0430\u0458\u0441\u043a\u0438 \u043a\u0440\u0435\u043e\u043b\u0441\u043a\u0438" },
            { "pms", "\u043f\u0438\u0435\u043c\u043e\u043d\u0442\u0441\u043a\u0438" },
            { "niu", "\u043d\u0438\u0443\u0458\u0435\u0441\u043a\u0438" },
            { "QO", "\u0417\u0430\u0432\u0438\u0441\u043d\u0438 \u0437\u0435\u043c\u0458\u0438 \u0432\u043e \u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "ext", "\u0435\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0438" },
            { "lez", "\u043b\u0435\u0437\u0433\u0438\u043d\u0441\u043a\u0438" },
            { "type.nu.ahom", "\u0410\u0445\u043e\u043c\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "Tavt", "\u0442\u0430\u0458 \u0432\u0458\u0435\u0442" },
            { "001", "\u0421\u0432\u0435\u0442" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "njo", "\u0430\u043e \u043d\u0430\u0433\u0430" },
            { "003", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "RE", "\u0420\u0435\u0443\u043d\u0438\u043e\u043d" },
            { "005", "\u0408\u0443\u0436\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "lfn", "\u043b\u0438\u043d\u0433\u0432\u0430 \u0444\u0440\u0430\u043d\u043a\u0430 \u043d\u043e\u0432\u0430" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "pnt", "\u043f\u043e\u043d\u0442\u0441\u043a\u0438" },
            { "Rjng", "\u0440\u0435\u045f\u0430\u043d\u0448\u043a\u043e" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "RO", "\u0420\u043e\u043c\u0430\u043d\u0438\u0458\u0430" },
            { "RS", "\u0421\u0440\u0431\u0438\u0458\u0430" },
            { "Mroo", "\u043c\u0440\u043e" },
            { "RU", "\u0420\u0443\u0441\u0438\u0458\u0430" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "Mani", "\u043c\u0430\u043d\u0438\u0445\u0435\u0458\u0441\u043a\u043e" },
            { "Ugar", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u043e" },
            { "Khar", "\u043a\u0430\u0440\u043e\u0448\u0442\u0438" },
            { "SA", "\u0421\u0430\u0443\u0434\u0438\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430" },
            { "pon", "\u043f\u043e\u043d\u043f\u0435\u0458\u0441\u043a\u0438" },
            { "Mand", "\u043c\u0430\u043d\u0434\u0435\u0458\u0441\u043a\u043e" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "twq", "\u0442\u0430\u0437\u0430\u0432\u0430\u043a" },
            { "011", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SC", "\u0421\u0435\u0458\u0448\u0435\u043b\u0438" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "013", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0434\u0441\u043a\u0430" },
            { "014", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "Loma", "\u043b\u043e\u043c\u0441\u043a\u043e" },
            { "015", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0432\u0435\u0442\u0430 \u0415\u043b\u0435\u043d\u0430" },
            { "type.lb.strict", "\u0421\u0442\u0440\u043e\u0433 \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "017", "\u0421\u0440\u0435\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430" },
            { "018", "\u0408\u0443\u0436\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0416\u0430\u043d \u041c\u0435\u0458\u0435\u043d" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0430" },
            { "Bamu", "\u0431\u0430\u043c\u0443\u043c\u0441\u043a\u043e" },
            { "Wole", "\u0432\u043e\u043b\u0435\u0430\u0458\u0441\u043a\u043e" },
            { "SL", "\u0421\u0438\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d \u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438\u0458\u0430" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u043a\u0438" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "type.nu.taml", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u0442\u0430\u043c\u0438\u043b\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "aro", "\u0430\u0440\u0430\u043e\u043d\u0430" },
            { "SS", "\u0408\u0443\u0436\u0435\u043d \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0435" },
            { "arq", "\u0430\u043b\u0436\u0438\u0440\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "SV", "\u0415\u043b \u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0432\u0435\u0442\u0438 \u041c\u0430\u0440\u0442\u0438\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438\u0458\u0430" },
            { "yao", "\u0458\u0430\u043e" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "arw", "\u0430\u0440\u0430\u0432\u0430\u0447\u043a\u0438" },
            { "arz", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "ary", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "yap", "\u0458\u0430\u043f\u0441\u043a\u0438" },
            { "rtm", "\u0440\u043e\u0442\u0443\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u045a\u0430" },
            { "asa", "\u0430\u0441\u0443" },
            { "type.ms.ussystem", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u043c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "021", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u043a\u043e\u043d\u0442\u0438\u043d\u0435\u043d\u0442\u0430\u043b\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "TC", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u0422\u0443\u0440\u043a\u0441 \u0438 \u041a\u0430\u0438\u043a\u043e\u0441" },
            { "yav", "\u0458\u0435\u043d\u0433\u0431\u0435\u043d" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438 \u0408\u0443\u0436\u043d\u0438 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "ase", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0437\u043d\u0430\u043a\u043e\u0432\u0435\u043d \u0458\u0430\u0437\u0438\u043a" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0458\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0438" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0422\u0438\u043c\u043e\u0440 (\u0422\u0438\u043c\u043e\u0440 \u041b\u0435\u0441\u0442\u0435)" },
            { "ybb", "\u0458\u0435\u043c\u0431\u0430" },
            { "type.co.searchjl", "\u041f\u0440\u0435\u0431\u0430\u0440\u0443\u0432\u0430\u045a\u0435 \u0441\u043f\u043e\u0440\u0435\u0434 \u043f\u043e\u0447\u0435\u0442\u043d\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043a\u0430 \u0445\u0430\u043d\u0433\u0443\u043b" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0446\u0438\u0458\u0430" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0458\u0432\u0430\u043d" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "rue", "\u0440\u0443\u0441\u0438\u043d\u0441\u043a\u0438" },
            { "rug", "\u0440\u043e\u0432\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "Orkh", "\u0441\u0442\u0430\u0440\u043e\u0442\u0443\u0440\u0441\u043a\u043e" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0458\u0430" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0438\u043e" },
            { "Zzzz", "\u043d\u0435\u043f\u043e\u0437\u043d\u0430\u0442\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Sind", "\u043a\u0443\u0434\u0430\u0431\u0430\u0434\u0438" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "lij", "\u043b\u0438\u0433\u0443\u0440\u0441\u043a\u0438" },
            { "rup", "\u0432\u043b\u0430\u0448\u043a\u0438" },
            { "030", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "tyv", "\u0442\u0443\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e\u0430\u043d\u0441\u043a\u0438 \u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "034", "\u0408\u0443\u0436\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "hai", "\u0445\u0430\u0458\u0434\u0430" },
            { "035", "\u0408\u0443\u0433\u043e\u0438\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "hak", "\u0445\u0430\u043a\u0430" },
            { "type.co.pinyin", "\u0421\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435 Pinyin" },
            { "039", "\u0408\u0443\u0436\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "Sinh", "\u0441\u0438\u043d\u0445\u0430\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "UM", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0432\u043e \u041f\u0430\u0446\u0438\u0444\u0438\u043a\u043e\u0442" },
            { "liv", "\u043b\u0438\u0432\u043e\u043d\u0441\u043a\u0438" },
            { "UN", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u043d\u0430\u0446\u0438\u0438" },
            { "US", "\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0414\u0440\u0436\u0430\u0432\u0438" },
            { "haw", "\u0445\u0430\u0432\u0430\u0458\u0441\u043a\u0438" },
            { "type.co.gb2312han", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u043e \u043a\u0438\u043d\u0435\u0441\u043a\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0458" },
            { "prg", "\u043f\u0440\u0443\u0441\u043a\u0438" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "tzm", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0442\u043b\u0430\u043d\u0441\u043a\u0438 \u0442\u0430\u043c\u0430\u0437\u0438\u0442\u0441\u043a\u0438" },
            { "type.co.stroke", "\u0420\u0438\u0442\u043c\u0438\u0447\u043a\u0438 \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "pro", "\u0441\u0442\u0430\u0440\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u0441\u043a\u0438" },
            { "VC", "\u0421\u0435\u043d\u0442 \u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0438" },
            { "VE", "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438 \u0414\u0435\u0432\u0441\u0442\u0432\u0435\u043d\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "VI", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0414\u0435\u0432\u0441\u0442\u0432\u0435\u043d\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "VN", "\u0412\u0438\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "nog", "\u043d\u043e\u0433\u0430\u0458\u0441\u043a\u0438" },
            { "rwk", "\u0440\u0443\u0430" },
            { "non", "\u0441\u0442\u0430\u0440\u043e\u043d\u043e\u0440\u0434\u0438\u0441\u043a\u0438" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u0458\u0430" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "WF", "\u0412\u0430\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "type.co.traditional", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0441\u043a\u0438 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0441\u043a\u0438" },
            { "nov", "\u043d\u043e\u0432\u0438\u0458\u0430\u043b" },
            { "avk", "\u043a\u043e\u0442\u0430\u0432\u0430" },
            { "type.co.compat", "\u041f\u0440\u0435\u0442\u0445\u043e\u0434\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "wae", "\u0432\u0430\u043b\u0441\u0435\u0440" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Bass", metaValue_bas },
            { "wal", "\u0432\u043e\u043b\u0430\u043c\u043e" },
            { "was", "\u0432\u0430\u0448\u043e" },
            { "war", "\u0432\u0430\u0440\u0430\u0458\u0441\u043a\u0438" },
            { "awa", "\u0430\u0432\u0430\u0434\u0438" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0431\u0435\u0437 \u043f\u0438\u0441\u043c\u043e" },
            { "Olck", "\u043e\u043b \u0447\u0438\u043a\u0438" },
            { "wbp", "\u0432\u0430\u0440\u043b\u043f\u0438\u0440\u0438" },
            { "Batk", "\u0431\u0430\u0442\u0430\u0447\u043a\u043e" },
            { "Blis", metaValue_zbl },
            { "YE", "\u0408\u0435\u043c\u0435\u043d" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "lmo", "\u043b\u043e\u043c\u0431\u0430\u0440\u0434\u0438\u0441\u043a\u0438" },
            { "fan", "\u0444\u0430\u043d\u0433" },
            { "fat", "\u0444\u0430\u043d\u0442\u0438" },
            { "Sgnw", "\u0437\u043d\u0430\u043a\u043e\u0432\u043d\u043e \u043f\u0438\u0448\u0443\u0432\u0430\u045a\u0435" },
            { "YT", "\u041c\u0430\u0458\u043e\u0442" },
            { "ZA", "\u0408\u0443\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "type.lb.loose", "\u0414\u043e\u043f\u0443\u0441\u0442\u043b\u0438\u0432 \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "type.nu.geor", "\u0413\u0440\u0443\u0437\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.co.zhuyin", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0436\u0443\u0458\u0438\u043d" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "%%PINYIN", "\u041f\u0438\u043d\u0458\u0438\u043d \u0440\u043e\u043c\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0458\u0430" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u0435\u043f\u043e\u0437\u043d\u0430\u0442 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "Runr", "\u0440\u0443\u043d\u0441\u043a\u043e" },
            { "type.ms.metric", "\u041c\u0435\u0442\u0440\u0438\u0447\u043a\u0438 \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ca.iso8601", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 ISO-8601" },
            { "lol", "\u043c\u043e\u043d\u0433\u043e" },
            { "nso", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0441\u043e\u0442\u0441\u043a\u0438" },
            { "type.nu.telu", "\u0422\u0435\u043b\u0443\u0433\u0443 \u0446\u0438\u0444\u0440\u0438" },
            { "lou", "\u043b\u0443\u0438\u0437\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u043a\u0440\u0435\u043e\u043b\u0441\u043a\u0438" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "Nkgb", "\u043d\u0430\u0441\u0438\u0441\u043a\u0430 \u0433\u0435\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "hif", "\u0444\u0438\u045f\u0438\u0441\u043a\u0438 \u0445\u0438\u043d\u0434\u0438" },
            { "type.nu.hansfin", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0458\u043d\u043e\u043d\u0441\u043a\u0438" },
            { "type.nu.arabext", "\u041f\u0440\u043e\u0448\u0438\u0440\u0435\u043d\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "type.nu.fullwide", "\u0426\u0438\u0444\u0440\u0438 \u0441\u043e \u0446\u0435\u043b\u043e\u0441\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430" },
            { "hit", "\u0445\u0435\u0442\u0438\u0442\u0441\u043a\u0438" },
            { "dar", "\u0434\u0430\u0440\u0433\u0432\u0430" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "Maya", "\u043c\u0430\u0458\u0430\u043d\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "lrc", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u043b\u0443\u0440\u0438\u0441\u043a\u0438" },
            { "type.co.emoji", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0435\u043c\u043e\u0442\u0438\u043a\u043e\u043d\u0438" },
            { "Copt", "\u043a\u043e\u043f\u0442\u0441\u043a\u043e" },
            { "nwc", "\u043a\u043b\u0430\u0441\u0438\u0447\u0435\u043d \u043d\u0435\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0441\u043a\u0438" },
            { "Khmr", "\u043a\u043c\u0435\u0440\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "type.ca.islamic-rgsa", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0421\u0430\u0443\u0434\u0438\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430)" },
            { "Limb", "\u043b\u0438\u043c\u0431\u0443" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "type.nu.roman", "\u0420\u0438\u043c\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "sah", "\u0458\u0430\u043a\u0443\u0442\u0441\u043a\u0438" },
            { "ltg", "\u043b\u0430\u0442\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "sam", "\u0441\u0430\u043c\u0430\u0440\u0458\u0430\u043d\u0441\u043a\u0438 \u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "Aghb", "\u043a\u0430\u0432\u043a\u0430\u0441\u043a\u043e\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sas", "\u0441\u0430\u0441\u0430\u0447\u043a\u0438" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "Tfng", "\u0442\u0438\u0444\u0438\u043d\u0430\u0433" },
            { "jpr", "\u0435\u0432\u0440\u0435\u0458\u0441\u043a\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "saz", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "sba", "\u043d\u0433\u0435\u043c\u0431\u0435\u0458" },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "lui", "\u043b\u0443\u0458\u0441\u0435\u045a\u0441\u043a\u0438" },
            { "nyn", "\u045a\u0430\u043d\u043a\u043e\u043b\u0435" },
            { "nym", "\u045a\u0430\u043c\u0432\u0435\u0437\u0438" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "nyo", "\u045a\u043e\u0440\u043e" },
            { "luo", "\u043b\u0443\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u0438\u043d\u0441\u043a\u0438" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "del", "\u0434\u0435\u043b\u0430\u0432\u0435\u0440" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "bal", "\u0431\u0435\u043b\u0443\u045f\u0438\u0441\u043a\u0438" },
            { "den", "\u0441\u043b\u0435\u0458\u0432\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438\u0441\u043a\u0438" },
            { "uga", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u0438" },
            { "fit", "\u0442\u0443\u0440\u043d\u0435\u0434\u0430\u043b\u0435\u043d\u0441\u043a\u0438 \u0444\u0438\u043d\u0441\u043a\u0438" },
            { "luy", "\u043b\u0443\u0458\u0430" },
            { "bar", "\u0431\u0430\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "bas", metaValue_bas },
            { "bax", "\u0431\u0430\u043c\u0443\u043d\u0441\u043a\u0438" },
            { "jrb", "\u0435\u0432\u0440\u0435\u0458\u0441\u043a\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "es_ES", "\u0448\u043f\u0430\u043d\u0441\u043a\u0438 (\u0432\u043e \u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "nzi", "\u043d\u0437\u0438\u043c\u0430" },
            { "sco", "\u0448\u043a\u043e\u0442\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "aa", "\u0430\u0444\u0430\u0440\u0441\u043a\u0438" },
            { "ab", "\u0430\u043f\u0445\u0430\u0441\u043a\u0438" },
            { "bbc", "\u0442\u043e\u0431\u0430" },
            { "ae", "\u0430\u0432\u0435\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "bbj", "\u0433\u043e\u043c\u0430\u043b\u0430" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u043a\u0438" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u043a\u0438" },
            { "Arab", "\u0430\u0440\u0430\u043f\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Jpan", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "ar", "\u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "Hrkt", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u043e \u0441\u043b\u043e\u0433\u043e\u0432\u043d\u043e" },
            { "as", "\u0430\u0441\u0430\u043c\u0441\u043a\u0438" },
            { "sdc", "\u0441\u0430\u0441\u0430\u0440\u0441\u043a\u0438 \u0441\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "Lina", "\u043b\u0438\u043d\u0435\u0430\u0440\u043d\u043e \u0410" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "Linb", "\u043b\u0438\u043d\u0435\u0430\u0440\u043d\u043e \u0411" },
            { "sdh", "\u0458\u0443\u0436\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "ay", "\u0430\u0458\u043c\u0430\u0440\u0441\u043a\u0438" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d\u0441\u043a\u0438" },
            { "Khoj", "\u0445\u043e\u045f\u043a\u0438" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0441\u043a\u0438" },
            { "type.co.unihan", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0443\u043d\u0438\u0445\u0430\u043d" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u043a\u0438" },
            { "bg", "\u0431\u0443\u0433\u0430\u0440\u0441\u043a\u0438" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0438" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u043f\u0441\u043a\u0438" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "bs", "\u0431\u043e\u0441\u0430\u043d\u0441\u043a\u0438" },
            { "see", "\u0441\u0435\u043d\u0435\u043a\u0430" },
            { "Mymr", "\u043c\u0458\u0430\u043d\u043c\u0430\u0440\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "sei", "\u0441\u0435\u0440\u0438" },
            { "type.nu.laoo", "\u041b\u0430\u043e\u0448\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0441\u0435\u043b\u043a\u0443\u043f\u0441\u043a\u0438" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0441\u043a\u0438" },
            { "ses", "\u043a\u043e\u0458\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0438" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u0441\u043a\u0438" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0441\u043a\u0438" },
            { "co", "\u043a\u043e\u0440\u0437\u0438\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "Orya", "\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "cr", "\u043a\u0440\u0438" },
            { "cs", "\u0447\u0435\u0448\u043a\u0438" },
            { "cu", "\u0446\u0440\u043a\u043e\u0432\u043d\u043e\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438" },
            { "yrl", "\u045a\u0435\u043d\u0433\u0430\u0442\u0443" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u043a\u0438" },
            { "cy", "\u0432\u0435\u043b\u0448\u043a\u0438" },
            { "type.nu.ethi", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "Yiii", "\u0458\u0438" },
            { "da", "\u0434\u0430\u043d\u0441\u043a\u0438" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438 (\u0432\u043e \u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "de", "\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "type.cf.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u0435\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "bej", "\u0431\u0435\u045f\u0430" },
            { "din", "\u0434\u0438\u043d\u043a\u0430" },
            { "jut", "\u0458\u0438\u0442\u0441\u043a\u0438" },
            { "Bugi", "\u0431\u0443\u0433\u0438\u0441\u043a\u043e" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "sga", "\u0441\u0442\u0430\u0440\u043e\u0438\u0440\u0441\u043a\u0438" },
            { "dv", "\u0434\u0438\u0432\u0435\u0445\u0438" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "bew", "\u0431\u0435\u0442\u0430\u0432\u0441\u043a\u0438" },
            { "dz", "\u0455\u043e\u043d\u0433\u043a\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "type.ca.chinese", "\u041a\u0438\u043d\u0435\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "lzh", "\u043a\u043d\u0438\u0436\u0435\u0432\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "Lisu", "\u0424\u0440\u0435\u0458\u0437\u0435\u0440\u043e\u0432\u043e" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "sgs", "\u0441\u0430\u043c\u043e\u0433\u0438\u0442\u0441\u043a\u0438" },
            { "type.nu.grek", "\u0413\u0440\u0447\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "ee", "\u0435\u0432\u0435" },
            { "bfd", "\u0431\u0430\u0444\u0443\u0442" },
            { "type.lb.normal", "\u041d\u043e\u0440\u043c\u0430\u043b\u0435\u043d \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438" },
            { "el", "\u0433\u0440\u0447\u043a\u0438" },
            { "en", "\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "eo", "\u0435\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "bfq", "\u0431\u0430\u0434\u0430\u0433\u0430" },
            { "lzz", "\u043b\u0430\u0441\u043a\u0438" },
            { "type.co.big5han", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e \u043a\u0438\u043d\u0435\u0441\u043a\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "es", "\u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "et", "\u0435\u0441\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "Hanb", "\u0445\u0430\u043d\u0431" },
            { "eu", "\u0431\u0430\u0441\u043a\u0438\u0441\u043a\u0438" },
            { "Buhd", "\u0431\u0443\u0445\u0438\u0434\u0441\u043a\u043e" },
            { "Hang", "\u0445\u0430\u043d\u0433\u0443\u043b" },
            { "Samr", "\u0441\u0430\u043c\u0430\u0440\u0458\u0430\u043d\u0441\u043a\u043e" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0445\u0438\u0442" },
            { "hsb", "\u0433\u043e\u0440\u043d\u043e\u043b\u0443\u0436\u0438\u0447\u043a\u0438" },
            { "Hani", "\u0445\u0430\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "shn", "\u0448\u0430\u043d" },
            { "Hano", "\u0445\u0430\u043d\u0443\u043d\u043e\u043e\u0432\u0441\u043a\u043e" },
            { "fa", "\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "Hans", "\u043f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u043e" },
            { "type.nu.latn", "\u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "shu", "\u0447\u0430\u0434\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "hsn", "\u0441\u0458\u0430\u043d\u0433" },
            { "fi", "\u0444\u0438\u043d\u0441\u043a\u0438" },
            { "fj", "\u0444\u0438\u045f\u0438\u0441\u043a\u0438" },
            { "fon", "\u0444\u043e\u043d" },
            { "bgn", "\u0437\u0430\u043f\u0430\u0434\u0435\u043d \u0431\u0430\u043b\u043e\u0447\u0438" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "fo", "\u0444\u0430\u0440\u0441\u043a\u0438" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "sid", "\u0441\u0438\u0434\u0430\u043c\u043e" },
            { "fy", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "ga", "\u0438\u0440\u0441\u043a\u0438" },
            { "gd", "\u0448\u043a\u043e\u0442\u0441\u043a\u0438 \u0433\u0435\u043b\u0441\u043a\u0438" },
            { "gl", "\u0433\u0430\u043b\u0438\u0446\u0438\u0441\u043a\u0438" },
            { "gn", "\u0433\u0432\u0430\u0440\u0430\u043d\u0441\u043a\u0438" },
            { "bho", "\u0431\u043e\u045f\u043f\u0443\u0440\u0438" },
            { "und", "\u043d\u0435\u043f\u043e\u0437\u043d\u0430\u0442 \u0458\u0430\u0437\u0438\u043a" },
            { "type.ca.ethiopic-amete-alem", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u0410\u043c\u0435\u0442 \u0410\u043b\u0435\u043c \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0430\u0441\u0442\u0440\u043e\u043d\u043e\u043c\u0441\u043a\u0430 \u0435\u043f\u043e\u0445\u0430)" },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u0445\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "bik", "\u0431\u0438\u043a\u043e\u043b\u0441\u043a\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "ho", "\u0445\u0438\u0440\u0438 \u043c\u043e\u0442\u0443" },
            { "hr", "\u0445\u0440\u0432\u0430\u0442\u0441\u043a\u0438" },
            { "ht", "\u0445\u0430\u0438\u0442\u0441\u043a\u0438" },
            { "hu", "\u0443\u043d\u0433\u0430\u0440\u0441\u043a\u0438" },
            { "hy", "\u0435\u0440\u043c\u0435\u043d\u0441\u043a\u0438" },
            { "hz", "\u0445\u0435\u0440\u0435\u0440\u043e" },
            { "frc", "\u043a\u0430\u045f\u0443\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "Jamo", "\u045f\u0430\u043c\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "type.nu.tibt", "\u0422\u0438\u0431\u0435\u0442\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "ie", "\u043e\u043a\u0446\u0438\u0434\u0435\u043d\u0442\u0430\u043b" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u0441\u0438\u0447\u0443\u0430\u043d \u0458\u0438" },
            { "frm", "\u0441\u0440\u0435\u0434\u043d\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "ik", "\u0438\u043d\u0443\u043f\u0438\u0458\u0430\u0447\u043a\u0438" },
            { "fro", "\u0441\u0442\u0430\u0440\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "frp", "\u0444\u0440\u0430\u043d\u043a\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u0441\u043a\u0438" },
            { "io", "\u0438\u0434\u043e" },
            { "frs", "\u0438\u0441\u0442\u043e\u0447\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "bjn", "\u0431\u0430\u043d\u045f\u0430\u0440\u0441\u043a\u0438" },
            { "frr", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "it", "\u0438\u0442\u0430\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "sli", "\u0434\u043e\u043b\u043d\u043e\u0448\u043b\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "ja", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u0438" },
            { "Mlym", "\u043c\u0430\u043b\u0430\u0458\u0430\u043b\u0430\u043c\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Sarb", "\u0441\u0442\u0430\u0440\u043e\u0458\u0443\u0436\u043d\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "Sara", "\u0441\u0430\u0440\u0430\u0442\u0438" },
            { "doi", "\u0434\u043e\u0433\u0440\u0438" },
            { "sly", "\u0441\u0435\u043b\u0430\u0458\u0430\u0440\u0441\u043a\u0438" },
            { "bkm", "\u043a\u043e\u043c" },
            { "sma", "\u0458\u0443\u0436\u0435\u043d \u0441\u0430\u043c\u0438" },
            { "jv", "\u0458\u0430\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "Shaw", "\u0428\u043e\u043e\u0432\u043e" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0438" },
            { "smj", "\u043b\u0443\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "maf", "\u043c\u0430\u0444\u0430" },
            { "mai", "\u043c\u0430\u0438\u0442\u0438\u043b\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u0438" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u0438" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440\u0441\u043a\u0438" },
            { "wuu", "\u0432\u0443" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "man", "\u043c\u0430\u043d\u0434\u0438\u043d\u0433\u043e" },
            { "kg", "\u043a\u043e\u043d\u0433\u043e" },
            { "Goth", "\u0433\u043e\u0442\u0441\u043a\u043e" },
            { "ki", "\u043a\u0438\u043a\u0443\u0458\u0443" },
            { "mas", "\u043c\u0430\u0441\u0430\u0458\u0441\u043a\u0438" },
            { "kj", "\u043a\u0432\u0430\u045a\u0430\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0448\u043a\u0438" },
            { "kl", "\u043a\u0430\u043b\u0430\u043b\u0438\u0441\u0443\u0442" },
            { "km", "\u043a\u043c\u0435\u0440\u0441\u043a\u0438" },
            { "kn", metaValue_kn },
            { "ko", "\u043a\u043e\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0441\u043a\u0438" },
            { "Cirt", "\u043a\u0438\u0440\u0442" },
            { "Lepc", "\u043b\u0435\u043f\u0447\u0430\u043d\u0441\u043a\u043e" },
            { "Avst", "\u0430\u0432\u0435\u0441\u0442\u0430\u043d\u0441\u043a\u043e" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u043a\u0438" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0441\u043a\u0438" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "la", "\u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438" },
            { "lb", "\u043b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0448\u043a\u0438" },
            { "type.nu.mlym", "\u041c\u0430\u043b\u0430\u0458\u0430\u043b\u0430\u043c\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "Roro", "\u0440\u043e\u043d\u0433\u043e\u0440\u043e\u043d\u0433\u043e" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0448\u043a\u0438" },
            { "Tibt", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "fur", "\u0444\u0443\u0440\u043b\u0430\u043d\u0441\u043a\u0438" },
            { "lo", "\u043b\u0430\u043e\u0448\u043a\u0438" },
            { "type.ms.uksystem", "\u0418\u043c\u043f\u0435\u0440\u0438\u0458\u0430\u043b\u0435\u043d \u043c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0432\u0438\u0441\u043a\u0438" },
            { "sog", "\u0437\u043e\u0433\u0434\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "mg", "\u043c\u0430\u043b\u0433\u0430\u0448\u043a\u0438" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0438" },
            { "type.co.ducet", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435 \u0432\u043e \u0443\u043d\u0438\u043a\u043e\u0434" },
            { "mi", "\u043c\u0430\u043e\u0440\u0441\u043a\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438" },
            { "ml", "\u043c\u0430\u043b\u0430\u0458\u0430\u043c\u0441\u043a\u0438" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u0438" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0458\u0441\u043a\u0438" },
            { "mt", "\u043c\u0430\u043b\u0442\u0435\u0448\u043a\u0438" },
            { "my", "\u0431\u0443\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "Saur", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430\u043d\u0441\u043a\u043e" },
            { "Armn", "\u0435\u0440\u043c\u0435\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430\u043d\u0441\u043a\u0438" },
            { "mde", "\u043c\u0430\u0431\u0430" },
            { "dsb", "\u0434\u043e\u043b\u043d\u043e\u043b\u0443\u0436\u0438\u0447\u043a\u0438" },
            { "Armi", "\u0446\u0430\u0440\u0441\u043a\u043e\u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "na", "\u043d\u0430\u0443\u0440\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "type.co.search", "\u041e\u043f\u0448\u0442\u043e \u043f\u0440\u0435\u0431\u0430\u0440\u0443\u0432\u0430\u045a\u0435" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438 \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u0441\u0435\u0432\u0435\u0440\u0435\u043d \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0441\u043a\u0438" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "mdr", "\u043c\u0430\u043d\u0434\u0430\u0440\u0441\u043a\u0438" },
            { "nl", "\u0445\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438 \u043d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438" },
            { "nr", "\u0458\u0443\u0436\u0435\u043d \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "kaa", "\u043a\u0430\u0440\u0430\u043a\u0430\u043b\u043f\u0430\u0447\u043a\u0438" },
            { "ny", "\u045a\u0430\u043d\u045f\u0430" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d\u0441\u043a\u0438" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0441\u043a\u0438" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "kaj", "\u043a\u0430\u045f\u0435" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "oj", "\u043e\u045f\u0438\u0431\u0432\u0430" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "type.nu.armn", "\u0415\u0440\u043c\u0435\u043d\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "kaw", "\u043a\u0430\u0432\u0438" },
            { "dtp", "\u0434\u0443\u0441\u0443\u043d\u0441\u043a\u0438" },
            { "or", "\u043e\u0434\u0438\u0458\u0430" },
            { "Modi", "\u043c\u043e\u0434\u0438" },
            { "os", "\u043e\u0441\u0435\u0442\u0441\u043a\u0438" },
            { "bpy", "\u0431\u0438\u0448\u043d\u0443\u043f\u0440\u0438\u0458\u0430" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0458\u0435\u043d" },
            { "srn", "\u0441\u0440\u0430\u043d\u0441\u043a\u0438 \u0442\u043e\u043d\u0433\u043e" },
            { "pa", "\u043f\u0435\u043d\u045f\u0430\u043f\u0441\u043a\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "srr", "\u0441\u0435\u0440\u0435\u0440" },
            { "kbl", "\u043a\u0430\u043d\u0435\u043c\u0431\u0443" },
            { "pi", "\u043f\u0430\u043b\u0438" },
            { "bqi", "\u0431\u0430\u0445\u0442\u0438\u0458\u0430\u0440\u0441\u043a\u0438" },
            { "pl", "\u043f\u043e\u043b\u0441\u043a\u0438" },
            { "dum", "\u0441\u0440\u0435\u0434\u043d\u043e\u0445\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "type.ca.dangi", "\u0414\u0430\u043d\u0433\u0438\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "ps", "\u043f\u0430\u0448\u0442\u0443\u043d\u0441\u043a\u0438" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "mga", "\u0441\u0440\u0435\u0434\u043d\u043e\u0438\u0440\u0441\u043a\u0438" },
            { "key.co", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u0438 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "kcg", "\u0442\u0458\u0430\u043f" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0438\u0442\u043e" },
            { "key.cf", "\u0424\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "bra", "\u0431\u0440\u0430\u0458" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "Laoo", "\u043b\u0430\u043e\u0448\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "type.hc.h23", "24-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0-23)" },
            { "type.hc.h24", "24-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1-24)" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "brh", "\u0431\u0440\u0430\u0445\u0443\u0458\u0441\u043a\u0438" },
            { "type.nu.mymr", "\u041c\u0458\u0430\u043d\u043c\u0430\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "zap", "\u0437\u0430\u043f\u043e\u0442\u0435\u0447\u043a\u0438" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "Lana", "\u043b\u0430\u043d\u0441\u043a\u043e" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "stq", "\u0437\u0430\u0442\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "Ethi", "\u0435\u0442\u0438\u043e\u043f\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "type.hc.h12", "12-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1-12)" },
            { "type.hc.h11", "12-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0-11)" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "key.cu", "\u0412\u0430\u043b\u0443\u0442\u0430" },
            { "ro", "\u0440\u043e\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "type.nu.orya", "\u041e\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.hanidec", "\u041a\u0438\u043d\u0435\u0441\u043a\u0438 \u0434\u0435\u0446\u0438\u043c\u0430\u043b\u043d\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "ru", "\u0440\u0443\u0441\u043a\u0438" },
            { "bss", "\u0430\u043a\u043e\u0441\u0435" },
            { "zbl", metaValue_zbl },
            { "rw", "\u0440\u0443\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "Dupl", "\u0414\u0438\u043f\u043b\u043e\u0458\u0435\u0435\u0432\u043e \u0441\u0442\u0435\u043d\u043e\u0433\u0440\u0430\u0444\u0441\u043a\u043e" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "sus", "\u0441\u0443\u0441\u0443" },
            { "sd", "\u0441\u0438\u043d\u0434\u0438" },
            { "se", "\u0441\u0435\u0432\u0435\u0440\u0435\u043d \u0441\u0430\u043c\u0438" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0441\u0440\u043f\u0441\u043a\u043e\u0445\u0440\u0432\u0430\u0442\u0441\u043a\u0438" },
            { "ken", "\u043a\u0435\u045a\u0430\u043d\u0433" },
            { "si", "\u0441\u0438\u043d\u0445\u0430\u043b\u0441\u043a\u0438" },
            { "sux", "\u0441\u0443\u043c\u0435\u0440\u0441\u043a\u0438" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u0447\u043a\u0438" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0435\u0447\u043a\u0438" },
            { "Gran", "\u0433\u0440\u0430\u043d\u0442\u0430" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u043a\u0438" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438\u0441\u043a\u0438" },
            { "type.nu.arab", "\u0410\u0440\u0430\u043f\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "sr", "\u0441\u0440\u043f\u0441\u043a\u0438" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "type.cf.account", "\u0421\u043c\u0435\u0442\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u0435\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "st", "\u0441\u0435\u0441\u043e\u0442\u043e" },
            { "Java", "\u0458\u0430\u0432\u0430\u043d\u0441\u043a\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0441\u043a\u0438" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u043a\u0438" },
            { "sw", "\u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "type.nu.hantfin", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "iba", "\u0438\u0431\u0430\u043d" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b\u0441\u043a\u0438" },
            { "142", "\u0410\u0437\u0438\u0458\u0430" },
            { "bua", "\u0431\u0443\u0440\u0458\u0430\u0442\u0441\u043a\u0438" },
            { "143", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "te", metaValue_te },
            { "145", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "tg", "\u0442\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "th", "\u0442\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u045a\u0430" },
            { "bug", "\u0431\u0443\u0433\u0438\u0441\u043a\u0438" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438" },
            { "tl", "\u0442\u0430\u0433\u0430\u043b\u043e\u0433" },
            { "tn", "\u0446\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u0458\u0441\u043a\u0438" },
            { "bum", "\u0431\u0443\u043b\u0443" },
            { "dyo", "\u0458\u043e\u043b\u0430-\u0444\u043e\u045a\u0438" },
            { "type.nu.jpan", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "tr", "\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "ts", "\u0446\u043e\u043d\u0433\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "Cakm", "\u0447\u0430\u043a\u043c\u0430\u043d\u0441\u043a\u043e" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0438" },
            { "dyu", "\u045f\u0443\u043b\u0430" },
            { "tw", "\u0442\u0432\u0438" },
            { "ty", "\u0442\u0430\u0445\u0438\u0442\u0441\u043a\u0438" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "155", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "ug", "\u0443\u0458\u0433\u0443\u0440\u0441\u043a\u0438" },
            { "Ital", "\u0441\u0442\u0430\u0440\u043e\u0438\u0442\u0430\u043b\u0441\u043a\u043e" },
            { "Kore", "\u043a\u043e\u0440\u0435\u0458\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "kgp", "\u043a\u0430\u0438\u043d\u0433\u0430\u043d\u0448\u043a\u0438" },
            { "Zyyy", "\u043e\u043f\u0448\u0442\u043e" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438" },
            { "zea", "\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "type.ca.coptic", "\u041a\u043e\u043f\u0442\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "xal", "\u043a\u0430\u043b\u043c\u0438\u0447\u043a\u0438" },
            { "zen", "\u0437\u0435\u043d\u0430\u0433\u0430" },
            { "uz", "\u0443\u0437\u0431\u0435\u0447\u043a\u0438" },
            { "kha", "\u043a\u0430\u0441\u0438" },
            { "nds_NL", "\u0434\u043e\u043b\u043d\u043e\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u043a\u0438" },
            { "Sylo", "\u0441\u0438\u043b\u0445\u0435\u0442\u0441\u043a\u043e \u043d\u0430\u0433\u0430\u0440\u0438" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "Wara", "\u0432\u0430\u0440\u0430\u043d\u0433 \u043a\u0448\u0438\u0442\u0438" },
            { "type.ca.roc", "\u041c\u0438\u043d\u0433\u0443\u043e-\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "vi", "\u0432\u0438\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438" },
            { "kho", "\u0445\u043e\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "khq", "\u043a\u043e\u0458\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "key.hc", "\u0427\u0430\u0441\u043e\u0432\u0435\u043d \u0446\u0438\u043a\u043b\u0443\u0441 (12 \u0438\u043b\u0438 24)" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u0438\u043a" },
            { "khw", "\u043a\u043e\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "syc", "\u043a\u043b\u0430\u0441\u0438\u0447\u0435\u043d \u0441\u0438\u0440\u0438\u0441\u043a\u0438" },
            { "Osma", "\u0441\u043e\u043c\u0430\u043b\u0438\u0441\u043a\u043e" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "qug", "\u043a\u0438\u0447\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "gaa", "\u0433\u0430" },
            { "wa", "\u0432\u0430\u043b\u043e\u043d\u0441\u043a\u0438" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0441\u043a\u0438" },
            { "syr", "\u0441\u0438\u0440\u0438\u0441\u043a\u0438" },
            { "Grek", "\u0433\u0440\u0447\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "gan", "\u0433\u0430\u043d" },
            { "kiu", "\u0437\u0430\u0437\u0430\u043a\u0438" },
            { "Lydi", "\u043b\u0438\u0434\u0438\u0441\u043a\u043e" },
            { "Xsux", "\u0441\u0443\u043c\u0435\u0440\u043e\u0430\u043a\u0430\u0434\u0441\u043a\u043e \u043a\u043b\u0438\u043d\u0435\u0441\u0442\u043e" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444\u0441\u043a\u0438" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u0435\u043d \u043c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0442\u0430\u043c\u0430\u0437\u0438\u0442\u0441\u043a\u0438" },
            { "ar_001", "\u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u0435\u043d \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "Cans", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u043e \u0441\u043b\u043e\u0433\u043e\u0432\u043d\u043e" },
            { "gay", "\u0433\u0430\u0458\u043e" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "mnc", "\u043c\u0430\u043d\u045f\u0443\u0440\u0441\u043a\u0438" },
            { "Latf", "\u0444\u0440\u0430\u043a\u0442\u0443\u0440\u043d\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430" },
            { "szl", "\u0448\u043b\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "Hluw", "\u0430\u043d\u0430\u0434\u043e\u043b\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "gba", "\u0433\u0431\u0430\u0458\u0430" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0441\u043a\u0438" },
            { "Latn", "\u043b\u0430\u0442\u0438\u043d\u0438\u0447\u043d\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Latg", "\u0433\u0435\u043b\u0441\u043a\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430" },
            { "type.nu.hans", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hant", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "type.nu.romanlow", "\u0420\u0438\u043c\u0441\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "byn", "\u0431\u0438\u043b\u0435\u043d\u0441\u043a\u0438" },
            { "Lyci", "\u043b\u0438\u043a\u0438\u0441\u043a\u043e" },
            { "osa", "\u043e\u0441\u0430\u0448\u043a\u0438" },
            { "byv", "\u043c\u0435\u0434\u0443\u043c\u0431\u0430" },
            { "gbz", "\u0437\u043e\u0440\u043e\u0430\u0441\u0442\u0440\u0438\u0441\u043a\u0438 \u0434\u0430\u0440\u0438" },
            { "Moon", "\u041c\u0443\u043d\u043e\u0432\u043e" },
            { "moh", "\u043c\u043e\u0445\u0430\u0432\u0441\u043a\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "yi", "\u0458\u0438\u0434\u0438\u0448" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "Syrc", "\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Dsrt", "\u0434\u0435\u0437\u0435\u0440\u0435\u0442\u0441\u043a\u043e" },
            { "yo", "\u0458\u043e\u0440\u0443\u043f\u0441\u043a\u0438" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "Syrj", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "ota", "\u043e\u0442\u043e\u043c\u0430\u043d\u0441\u043a\u0438 \u0442\u0443\u0440\u0441\u043a\u0438" },
            { "Syre", "\u0435\u0441\u0442\u0440\u0430\u043d\u0433\u0435\u043b\u0441\u043a\u043e \u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "vai", metaValue_vai },
            { "za", "\u045f\u0443\u0430\u043d\u0448\u043a\u0438" },
            { "Cari", "\u043a\u0430\u0440\u0438\u0441\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u045f\u0438\u043d" },
            { "zh", "\u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "Afak", "\u0430\u0444\u0430\u043a\u0430" },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Perm", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u043c\u0441\u043a\u043e" },
            { "key.lb", "\u0421\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "type.co.phonebook", "\u0410\u0437\u0431\u0443\u0447\u0435\u043d \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "Geor", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Shrd", "\u0448\u0430\u0440\u0430\u0434\u0430" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "type.nu.jpanfin", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "Cham", "\u0447\u0430\u043c\u0441\u043a\u043e" },
            { "gez", "\u0433\u0438\u0437" },
            { "mrj", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u043c\u0430\u0440\u0438\u0441\u043a\u0438" },
            { "Syrn", "\u0438\u0441\u0442\u043e\u0447\u043d\u043e\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Elba", "\u0435\u043b\u0431\u0430\u0441\u0430\u043d\u0441\u043a\u043e" },
            { "Narb", "\u0441\u0442\u0430\u0440\u043e\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "type.co.reformed", "\u0420\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u0430\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "Tglg", "\u0442\u0430\u0433\u0430\u043b\u043e\u0448\u043a\u043e" },
            { "Egyd", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u043e \u0434\u0435\u043c\u043e\u0442\u0441\u043a\u043e" },
            { "Egyh", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u043e \u0445\u0438\u0435\u0440\u0430\u0442\u0441\u043a\u043e" },
            { "Palm", "\u043f\u0430\u043b\u043c\u0438\u0440\u0441\u043a\u043e" },
            { "ebu", "\u0435\u043c\u0431\u0443" },
            { "Egyp", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "Geok", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u0438 \u0445\u0443\u0446\u0443\u0440\u0438" },
            { "zh_Hans", "\u043f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u0458\u0430\u0447\u043a\u0438" },
            { "Hung", "\u0441\u0442\u0430\u0440\u043e\u0443\u043d\u0433\u0430\u0440\u0441\u043a\u043e" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kos", "\u043a\u043e\u0437\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "vec", "\u0432\u0435\u043d\u0435\u0442\u0441\u043a\u0438" },
            { "zh_Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "Sund", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u043a\u043e" },
            { "vep", "\u0432\u0435\u043f\u0448\u043a\u0438" },
            { "kpe", "\u043a\u043f\u0435\u043b\u0435" },
            { "type.nu.khmr", "\u041a\u043c\u0435\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "Tirh", "\u0442\u0438\u0440\u0445\u0443\u0442\u0430" },
            { "ilo", "\u0438\u043b\u043e\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "Cprt", "\u043a\u0438\u043f\u0430\u0440\u0441\u043a\u043e" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "type.nu.guru", "\u0413\u0443\u0440\u043c\u0443\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "mul", "\u043f\u043e\u0432\u0435\u045c\u0435 \u0458\u0430\u0437\u0438\u0446\u0438" },
            { "cad", "\u043a\u0430\u0434\u043e" },
            { "key.ms", "\u041c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "Glag", "\u0433\u043b\u0430\u0433\u043e\u043b\u0438\u0446\u0430" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "Cher", "\u0447\u0435\u0440\u043e\u043a\u0438\u0441\u043a\u043e" },
            { "car", "\u043a\u0430\u0440\u0438\u043f\u0441\u043a\u0438" },
            { "cay", "\u043a\u0430\u0458\u0443\u0433\u0430" },
            { "type.nu.tamldec", "\u0422\u0430\u043c\u0438\u043b\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0435\u0432\u0441\u043a\u043e-\u0431\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0438" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448\u043a\u0438" },
            { "krj", "\u043a\u0438\u043d\u0430\u0440\u0430\u0458\u0441\u043a\u0438" },
            { "kri", "\u043a\u0440\u0438\u043e" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u0441\u043a\u0438" },
            { "efi", "\u0435\u0444\u0438\u043a" },
            { "tcy", "\u0442\u0443\u043b\u0443" },
            { "key.nu", "\u0411\u0440\u043e\u0435\u0432\u0438" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0438\u0458\u0430" },
        };
        return data;
    }
}
