/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public class AutoFollowCoordinator
implements ClusterStateApplier {
    private static final Logger LOGGER = LogManager.getLogger(AutoFollowCoordinator.class);
    private static final int MAX_AUTO_FOLLOW_ERRORS = 256;
    private final Client client;
    private final TimeValue pollInterval;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final CcrLicenseChecker ccrLicenseChecker;
    private volatile boolean localNodeMaster = false;
    private long numberOfSuccessfulIndicesAutoFollowed = 0L;
    private long numberOfFailedIndicesAutoFollowed = 0L;
    private long numberOfFailedRemoteClusterStateRequests = 0L;
    private final LinkedHashMap<String, ElasticsearchException> recentAutoFollowErrors;

    public AutoFollowCoordinator(Settings settings, Client client, ThreadPool threadPool, ClusterService clusterService, CcrLicenseChecker ccrLicenseChecker) {
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
        this.pollInterval = (TimeValue)CcrSettings.CCR_AUTO_FOLLOW_POLL_INTERVAL.get(settings);
        clusterService.addStateApplier((ClusterStateApplier)this);
        this.recentAutoFollowErrors = new LinkedHashMap<String, ElasticsearchException>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ElasticsearchException> eldest) {
                return this.size() > 256;
            }
        };
    }

    public synchronized AutoFollowStats getStats() {
        return new AutoFollowStats(this.numberOfFailedIndicesAutoFollowed, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulIndicesAutoFollowed, new TreeMap<String, ElasticsearchException>(this.recentAutoFollowErrors));
    }

    synchronized void updateStats(List<AutoFollowResult> results) {
        for (AutoFollowResult result : results) {
            if (result.clusterStateFetchException != null) {
                this.recentAutoFollowErrors.put(result.autoFollowPatternName, new ElasticsearchException((Throwable)result.clusterStateFetchException));
                ++this.numberOfFailedRemoteClusterStateRequests;
                LOGGER.warn((Message)new ParameterizedMessage("failure occurred while fetching cluster state for auto follow pattern [{}]", (Object)result.autoFollowPatternName), (Throwable)result.clusterStateFetchException);
                continue;
            }
            for (Map.Entry<Index, Exception> entry : result.autoFollowExecutionResults.entrySet()) {
                if (entry.getValue() != null) {
                    ++this.numberOfFailedIndicesAutoFollowed;
                    this.recentAutoFollowErrors.put(result.autoFollowPatternName + ":" + entry.getKey().getName(), ExceptionsHelper.convertToElastic((Exception)entry.getValue()));
                    LOGGER.warn((Message)new ParameterizedMessage("failure occurred while auto following index [{}] for auto follow pattern [{}]", (Object)entry.getKey(), (Object)result.autoFollowPatternName), (Throwable)entry.getValue());
                    continue;
                }
                ++this.numberOfSuccessfulIndicesAutoFollowed;
            }
        }
    }

    private void doAutoFollow() {
        if (!this.localNodeMaster) {
            return;
        }
        ClusterState followerClusterState = this.clusterService.state();
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)followerClusterState.getMetaData().custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            this.threadPool.schedule(this.pollInterval, "same", this::doAutoFollow);
            return;
        }
        if (autoFollowMetadata.getPatterns().isEmpty()) {
            this.threadPool.schedule(this.pollInterval, "same", this::doAutoFollow);
            return;
        }
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            LOGGER.warn("skipping auto-follower coordination", (Throwable)LicenseUtils.newComplianceException((String)"ccr"));
            this.threadPool.schedule(this.pollInterval, "same", this::doAutoFollow);
            return;
        }
        Consumer<List> handler = results -> {
            this.updateStats((List<AutoFollowResult>)results);
            this.threadPool.schedule(this.pollInterval, "same", this::doAutoFollow);
        };
        AutoFollower operation = new AutoFollower(handler, followerClusterState){

            @Override
            void getLeaderClusterState(String remoteCluster, BiConsumer<ClusterState, Exception> handler) {
                ClusterStateRequest request = new ClusterStateRequest();
                request.clear();
                request.metaData(true);
                AutoFollowCoordinator.this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(AutoFollowCoordinator.this.client, remoteCluster, request, e -> handler.accept((ClusterState)null, (Exception)e), leaderClusterState -> handler.accept((ClusterState)leaderClusterState, (Exception)null));
            }

            @Override
            void createAndFollow(Map<String, String> headers, PutFollowAction.Request request, Runnable successHandler, Consumer<Exception> failureHandler) {
                Client followerClient = CcrLicenseChecker.wrapClient(AutoFollowCoordinator.this.client, headers);
                followerClient.execute((Action)PutFollowAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> successHandler.run(), failureHandler));
            }

            @Override
            void updateAutoFollowMetadata(final Function<ClusterState, ClusterState> updateFunction, final Consumer<Exception> handler) {
                AutoFollowCoordinator.this.clusterService.submitStateUpdateTask("update_auto_follow_metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                    public ClusterState execute(ClusterState currentState) throws Exception {
                        return (ClusterState)updateFunction.apply(currentState);
                    }

                    public void onFailure(String source, Exception e) {
                        handler.accept(e);
                    }

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        handler.accept(null);
                    }
                });
            }
        };
        operation.autoFollowIndices();
    }

    public void applyClusterState(ClusterChangedEvent event) {
        boolean beforeLocalMasterNode = this.localNodeMaster;
        this.localNodeMaster = event.localNodeMaster();
        if (!beforeLocalMasterNode && this.localNodeMaster) {
            this.threadPool.schedule(this.pollInterval, "same", this::doAutoFollow);
        }
    }

    static class AutoFollowResult {
        final String autoFollowPatternName;
        final Exception clusterStateFetchException;
        final Map<Index, Exception> autoFollowExecutionResults;

        AutoFollowResult(String autoFollowPatternName, List<Tuple<Index, Exception>> results) {
            this.autoFollowPatternName = autoFollowPatternName;
            HashMap<Index, Exception> autoFollowExecutionResults = new HashMap<Index, Exception>();
            for (Tuple<Index, Exception> result : results) {
                autoFollowExecutionResults.put((Index)result.v1(), (Exception)result.v2());
            }
            this.clusterStateFetchException = null;
            this.autoFollowExecutionResults = Collections.unmodifiableMap(autoFollowExecutionResults);
        }

        AutoFollowResult(String autoFollowPatternName, Exception e) {
            this.autoFollowPatternName = autoFollowPatternName;
            this.clusterStateFetchException = e;
            this.autoFollowExecutionResults = Collections.emptyMap();
        }

        AutoFollowResult(String autoFollowPatternName) {
            this(autoFollowPatternName, (Exception)null);
        }
    }

    static abstract class AutoFollower {
        private final Consumer<List<AutoFollowResult>> handler;
        private final ClusterState followerClusterState;
        private final AutoFollowMetadata autoFollowMetadata;
        private final CountDown autoFollowPatternsCountDown;
        private final AtomicArray<AutoFollowResult> autoFollowResults;

        AutoFollower(Consumer<List<AutoFollowResult>> handler, ClusterState followerClusterState) {
            this.handler = handler;
            this.followerClusterState = followerClusterState;
            this.autoFollowMetadata = (AutoFollowMetadata)followerClusterState.getMetaData().custom("ccr_auto_follow");
            this.autoFollowPatternsCountDown = new CountDown(this.autoFollowMetadata.getPatterns().size());
            this.autoFollowResults = new AtomicArray(this.autoFollowMetadata.getPatterns().size());
        }

        void autoFollowIndices() {
            int i = 0;
            for (Map.Entry entry : this.autoFollowMetadata.getPatterns().entrySet()) {
                int slot = i++;
                String autoFollowPattenName = (String)entry.getKey();
                AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)entry.getValue();
                String remoteCluster = autoFollowPattern.getRemoteCluster();
                Map headers = (Map)this.autoFollowMetadata.getHeaders().get(autoFollowPattenName);
                this.getLeaderClusterState(remoteCluster, (leaderClusterState, e) -> {
                    if (leaderClusterState != null) {
                        assert (e == null);
                        List followedIndices = (List)this.autoFollowMetadata.getFollowedLeaderIndexUUIDs().get(autoFollowPattenName);
                        List<Index> leaderIndicesToFollow = AutoFollower.getLeaderIndicesToFollow(remoteCluster, autoFollowPattern, leaderClusterState, this.followerClusterState, followedIndices);
                        if (leaderIndicesToFollow.isEmpty()) {
                            this.finalise(slot, new AutoFollowResult(autoFollowPattenName));
                        } else {
                            List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameLeaderCluster = this.autoFollowMetadata.getPatterns().entrySet().stream().filter(item -> !autoFollowPattenName.equals(item.getKey())).filter(item -> remoteCluster.equals(((AutoFollowMetadata.AutoFollowPattern)item.getValue()).getRemoteCluster())).map(item -> new Tuple((Object)((String)item.getKey()), (Object)((AutoFollowMetadata.AutoFollowPattern)item.getValue()))).collect(Collectors.toList());
                            Consumer<AutoFollowResult> resultHandler = result -> this.finalise(slot, (AutoFollowResult)result);
                            this.checkAutoFollowPattern(autoFollowPattenName, remoteCluster, autoFollowPattern, leaderIndicesToFollow, headers, patternsForTheSameLeaderCluster, resultHandler);
                        }
                    } else {
                        this.finalise(slot, new AutoFollowResult(autoFollowPattenName, (Exception)e));
                    }
                });
            }
        }

        private void checkAutoFollowPattern(String autoFollowPattenName, String leaderCluster, AutoFollowMetadata.AutoFollowPattern autoFollowPattern, List<Index> leaderIndicesToFollow, Map<String, String> headers, List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameLeaderCluster, Consumer<AutoFollowResult> resultHandler) {
            CountDown leaderIndicesCountDown = new CountDown(leaderIndicesToFollow.size());
            AtomicArray results = new AtomicArray(leaderIndicesToFollow.size());
            for (int i = 0; i < leaderIndicesToFollow.size(); ++i) {
                Index indexToFollow = leaderIndicesToFollow.get(i);
                int slot = i;
                List otherMatchingPatterns = patternsForTheSameLeaderCluster.stream().filter(otherPattern -> ((AutoFollowMetadata.AutoFollowPattern)otherPattern.v2()).match(indexToFollow.getName())).map(Tuple::v1).collect(Collectors.toList());
                if (otherMatchingPatterns.size() != 0) {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, (Object)new ElasticsearchException("index to follow [" + indexToFollow.getName() + "] for pattern [" + autoFollowPattenName + "] matches with other patterns " + otherMatchingPatterns + "", new Object[0])));
                    if (!leaderIndicesCountDown.countDown()) continue;
                    resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    continue;
                }
                this.followLeaderIndex(autoFollowPattenName, leaderCluster, indexToFollow, autoFollowPattern, headers, error -> {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, error));
                    if (leaderIndicesCountDown.countDown()) {
                        resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    }
                });
            }
        }

        private void followLeaderIndex(String autoFollowPattenName, String remoteCluster, Index indexToFollow, AutoFollowMetadata.AutoFollowPattern pattern, Map<String, String> headers, Consumer<Exception> onResult) {
            String leaderIndexName = indexToFollow.getName();
            String followIndexName = AutoFollower.getFollowerIndexName(pattern, leaderIndexName);
            ResumeFollowAction.Request followRequest = new ResumeFollowAction.Request();
            followRequest.setFollowerIndex(followIndexName);
            followRequest.setMaxReadRequestOperationCount(pattern.getMaxReadRequestOperationCount());
            followRequest.setMaxReadRequestSize(pattern.getMaxReadRequestSize());
            followRequest.setMaxOutstandingReadRequests(pattern.getMaxOutstandingReadRequests());
            followRequest.setMaxWriteRequestOperationCount(pattern.getMaxWriteRequestOperationCount());
            followRequest.setMaxWriteRequestSize(pattern.getMaxWriteRequestSize());
            followRequest.setMaxOutstandingWriteRequests(pattern.getMaxOutstandingWriteRequests());
            followRequest.setMaxWriteBufferCount(pattern.getMaxWriteBufferCount());
            followRequest.setMaxWriteBufferSize(pattern.getMaxWriteBufferSize());
            followRequest.setMaxRetryDelay(pattern.getMaxRetryDelay());
            followRequest.setReadPollTimeout(pattern.getPollTimeout());
            PutFollowAction.Request request = new PutFollowAction.Request();
            request.setRemoteCluster(remoteCluster);
            request.setLeaderIndex(indexToFollow.getName());
            request.setFollowRequest(followRequest);
            Runnable successHandler = () -> {
                LOGGER.info("Auto followed leader index [{}] as follow index [{}]", (Object)leaderIndexName, (Object)followIndexName);
                Function<ClusterState, ClusterState> function = AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow);
                this.updateAutoFollowMetadata(function, onResult);
            };
            this.createAndFollow(headers, request, successHandler, onResult);
        }

        private void finalise(int slot, AutoFollowResult result) {
            assert (this.autoFollowResults.get(slot) == null);
            this.autoFollowResults.set(slot, (Object)result);
            if (this.autoFollowPatternsCountDown.countDown()) {
                this.handler.accept(this.autoFollowResults.asList());
            }
        }

        static List<Index> getLeaderIndicesToFollow(String remoteCluster, AutoFollowMetadata.AutoFollowPattern autoFollowPattern, ClusterState leaderClusterState, ClusterState followerClusterState, List<String> followedIndexUUIDs) {
            ArrayList<Index> leaderIndicesToFollow = new ArrayList<Index>();
            for (IndexMetaData leaderIndexMetaData : leaderClusterState.getMetaData()) {
                if (!autoFollowPattern.match(leaderIndexMetaData.getIndex().getName()) || followedIndexUUIDs.contains(leaderIndexMetaData.getIndex().getUUID()) || !leaderIndexMetaData.getSettings().getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(false)).booleanValue()) continue;
                leaderIndicesToFollow.add(leaderIndexMetaData.getIndex());
            }
            return leaderIndicesToFollow;
        }

        static String getFollowerIndexName(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, String leaderIndexName) {
            if (autoFollowPattern.getFollowIndexPattern() != null) {
                return autoFollowPattern.getFollowIndexPattern().replace("{{leader_index}}", leaderIndexName);
            }
            return leaderIndexName;
        }

        static Function<ClusterState, ClusterState> recordLeaderIndexAsFollowFunction(String name, Index indexToFollow) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
                HashMap<String, List> newFollowedIndexUUIDS = new HashMap<String, List>(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                newFollowedIndexUUIDS.compute(name, (key, existingUUIDs) -> {
                    assert (existingUUIDs != null);
                    ArrayList<String> newUUIDs = new ArrayList<String>((Collection<String>)existingUUIDs);
                    newUUIDs.add(indexToFollow.getUUID());
                    return Collections.unmodifiableList(newUUIDs);
                });
                AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), newFollowedIndexUUIDS, currentAutoFollowMetadata.getHeaders());
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build()).build();
            };
        }

        abstract void getLeaderClusterState(String var1, BiConsumer<ClusterState, Exception> var2);

        abstract void createAndFollow(Map<String, String> var1, PutFollowAction.Request var2, Runnable var3, Consumer<Exception> var4);

        abstract void updateAutoFollowMetadata(Function<ClusterState, ClusterState> var1, Consumer<Exception> var2);
    }
}

