/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xpack.core.XPackPlugin;

public class ShardFollowTask
implements XPackPlugin.XPackPersistentTaskParams {
    public static final String NAME = "xpack/ccr/shard_follow_task";
    public static final Set<String> HEADER_FILTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("es-security-runas-user", "_xpack_security_authentication")));
    static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
    static final ParseField FOLLOW_SHARD_INDEX_FIELD = new ParseField("follow_shard_index", new String[0]);
    static final ParseField FOLLOW_SHARD_INDEX_UUID_FIELD = new ParseField("follow_shard_index_uuid", new String[0]);
    static final ParseField FOLLOW_SHARD_SHARDID_FIELD = new ParseField("follow_shard_shard", new String[0]);
    static final ParseField LEADER_SHARD_INDEX_FIELD = new ParseField("leader_shard_index", new String[0]);
    static final ParseField LEADER_SHARD_INDEX_UUID_FIELD = new ParseField("leader_shard_index_uuid", new String[0]);
    static final ParseField LEADER_SHARD_SHARDID_FIELD = new ParseField("leader_shard_shard", new String[0]);
    static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ParseField MAX_READ_REQUEST_OPERATION_COUNT = new ParseField("max_read_request_operation_count", new String[0]);
    public static final ParseField MAX_READ_REQUEST_SIZE = new ParseField("max_read_request_size", new String[0]);
    public static final ParseField MAX_OUTSTANDING_READ_REQUESTS = new ParseField("max_outstanding_read_requests", new String[0]);
    public static final ParseField MAX_WRITE_REQUEST_OPERATION_COUNT = new ParseField("max_write_request_operation_count", new String[0]);
    public static final ParseField MAX_WRITE_REQUEST_SIZE = new ParseField("max_write_request_size", new String[0]);
    public static final ParseField MAX_OUTSTANDING_WRITE_REQUESTS = new ParseField("max_outstanding_write_requests", new String[0]);
    public static final ParseField MAX_WRITE_BUFFER_COUNT = new ParseField("max_write_buffer_count", new String[0]);
    public static final ParseField MAX_WRITE_BUFFER_SIZE = new ParseField("max_write_buffer_size", new String[0]);
    public static final ParseField MAX_RETRY_DELAY = new ParseField("max_retry_delay", new String[0]);
    public static final ParseField READ_POLL_TIMEOUT = new ParseField("read_poll_timeout", new String[0]);
    private static ConstructingObjectParser<ShardFollowTask, Void> PARSER = new ConstructingObjectParser("xpack/ccr/shard_follow_task", a -> new ShardFollowTask((String)a[0], new ShardId((String)a[1], (String)a[2], ((Integer)a[3]).intValue()), new ShardId((String)a[4], (String)a[5], ((Integer)a[6]).intValue()), (Integer)a[7], (ByteSizeValue)a[8], (Integer)a[9], (Integer)a[10], (ByteSizeValue)a[11], (Integer)a[12], (Integer)a[13], (ByteSizeValue)a[14], (TimeValue)a[15], (TimeValue)a[16], (Map)a[17]));
    private final String remoteCluster;
    private final ShardId followShardId;
    private final ShardId leaderShardId;
    private final int maxReadRequestOperationCount;
    private final ByteSizeValue maxReadRequestSize;
    private final int maxOutstandingReadRequests;
    private final int maxWriteRequestOperationCount;
    private final ByteSizeValue maxWriteRequestSize;
    private final int maxOutstandingWriteRequests;
    private final int maxWriteBufferCount;
    private final ByteSizeValue maxWriteBufferSize;
    private final TimeValue maxRetryDelay;
    private final TimeValue readPollTimeout;
    private final Map<String, String> headers;

    ShardFollowTask(String remoteCluster, ShardId followShardId, ShardId leaderShardId, int maxReadRequestOperationCount, ByteSizeValue maxReadRequestSize, int maxOutstandingReadRequests, int maxWriteRequestOperationCount, ByteSizeValue maxWriteRequestSize, int maxOutstandingWriteRequests, int maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue readPollTimeout, Map<String, String> headers) {
        this.remoteCluster = remoteCluster;
        this.followShardId = followShardId;
        this.leaderShardId = leaderShardId;
        this.maxReadRequestOperationCount = maxReadRequestOperationCount;
        this.maxReadRequestSize = maxReadRequestSize;
        this.maxOutstandingReadRequests = maxOutstandingReadRequests;
        this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
        this.maxWriteRequestSize = maxWriteRequestSize;
        this.maxOutstandingWriteRequests = maxOutstandingWriteRequests;
        this.maxWriteBufferCount = maxWriteBufferCount;
        this.maxWriteBufferSize = maxWriteBufferSize;
        this.maxRetryDelay = maxRetryDelay;
        this.readPollTimeout = readPollTimeout;
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : Collections.emptyMap();
    }

    public ShardFollowTask(StreamInput in) throws IOException {
        this.remoteCluster = in.readString();
        this.followShardId = ShardId.readShardId((StreamInput)in);
        this.leaderShardId = ShardId.readShardId((StreamInput)in);
        this.maxReadRequestOperationCount = in.readVInt();
        this.maxReadRequestSize = new ByteSizeValue(in);
        this.maxOutstandingReadRequests = in.readVInt();
        this.maxWriteRequestOperationCount = in.readVInt();
        this.maxWriteRequestSize = new ByteSizeValue(in);
        this.maxOutstandingWriteRequests = in.readVInt();
        this.maxWriteBufferCount = in.readVInt();
        this.maxWriteBufferSize = new ByteSizeValue(in);
        this.maxRetryDelay = in.readTimeValue();
        this.readPollTimeout = in.readTimeValue();
        this.headers = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readString));
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public ShardId getFollowShardId() {
        return this.followShardId;
    }

    public ShardId getLeaderShardId() {
        return this.leaderShardId;
    }

    public int getMaxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    public int getMaxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    public int getMaxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    public ByteSizeValue getMaxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    public int getMaxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    public int getMaxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    public ByteSizeValue getMaxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    public ByteSizeValue getMaxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    public TimeValue getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public TimeValue getReadPollTimeout() {
        return this.readPollTimeout;
    }

    public String getTaskId() {
        return this.followShardId.getIndex().getUUID() + "-" + this.followShardId.getId();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.remoteCluster);
        this.followShardId.writeTo(out);
        this.leaderShardId.writeTo(out);
        out.writeVLong((long)this.maxReadRequestOperationCount);
        this.maxReadRequestSize.writeTo(out);
        out.writeVInt(this.maxOutstandingReadRequests);
        out.writeVLong((long)this.maxWriteRequestOperationCount);
        this.maxWriteRequestSize.writeTo(out);
        out.writeVInt(this.maxOutstandingWriteRequests);
        out.writeVInt(this.maxWriteBufferCount);
        this.maxWriteBufferSize.writeTo(out);
        out.writeTimeValue(this.maxRetryDelay);
        out.writeTimeValue(this.readPollTimeout);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
    }

    public static ShardFollowTask fromXContent(XContentParser parser) {
        return (ShardFollowTask)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
        builder.field(FOLLOW_SHARD_INDEX_FIELD.getPreferredName(), this.followShardId.getIndex().getName());
        builder.field(FOLLOW_SHARD_INDEX_UUID_FIELD.getPreferredName(), this.followShardId.getIndex().getUUID());
        builder.field(FOLLOW_SHARD_SHARDID_FIELD.getPreferredName(), this.followShardId.id());
        builder.field(LEADER_SHARD_INDEX_FIELD.getPreferredName(), this.leaderShardId.getIndex().getName());
        builder.field(LEADER_SHARD_INDEX_UUID_FIELD.getPreferredName(), this.leaderShardId.getIndex().getUUID());
        builder.field(LEADER_SHARD_SHARDID_FIELD.getPreferredName(), this.leaderShardId.id());
        builder.field(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
        builder.field(MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
        builder.field(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxOutstandingReadRequests);
        builder.field(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
        builder.field(MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
        builder.field(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxOutstandingWriteRequests);
        builder.field(MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
        builder.field(MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
        builder.field(MAX_RETRY_DELAY.getPreferredName(), this.maxRetryDelay.getStringRep());
        builder.field(READ_POLL_TIMEOUT.getPreferredName(), this.readPollTimeout.getStringRep());
        builder.field(HEADERS.getPreferredName(), this.headers);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardFollowTask that = (ShardFollowTask)o;
        return Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.followShardId, that.followShardId) && Objects.equals(this.leaderShardId, that.leaderShardId) && this.maxReadRequestOperationCount == that.maxReadRequestOperationCount && this.maxReadRequestSize.equals((Object)that.maxReadRequestSize) && this.maxOutstandingReadRequests == that.maxOutstandingReadRequests && this.maxWriteRequestOperationCount == that.maxWriteRequestOperationCount && this.maxWriteRequestSize.equals((Object)that.maxWriteRequestSize) && this.maxOutstandingWriteRequests == that.maxOutstandingWriteRequests && this.maxWriteBufferCount == that.maxWriteBufferCount && this.maxWriteBufferSize.equals((Object)that.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, that.maxRetryDelay) && Objects.equals(this.readPollTimeout, that.readPollTimeout) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.remoteCluster, this.followShardId, this.leaderShardId, this.maxReadRequestOperationCount, this.maxReadRequestSize, this.maxOutstandingReadRequests, this.maxWriteRequestOperationCount, this.maxWriteRequestSize, this.maxOutstandingWriteRequests, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.readPollTimeout, this.headers);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_5_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REMOTE_CLUSTER_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_INDEX_UUID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FOLLOW_SHARD_SHARDID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_SHARD_INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_SHARD_INDEX_UUID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), LEADER_SHARD_SHARDID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_READ_REQUEST_OPERATION_COUNT);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_READ_REQUEST_SIZE.getPreferredName()), MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_OUTSTANDING_READ_REQUESTS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_WRITE_REQUEST_OPERATION_COUNT);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_REQUEST_SIZE.getPreferredName()), MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_OUTSTANDING_WRITE_REQUESTS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_WRITE_BUFFER_COUNT);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_BUFFER_SIZE.getPreferredName()), MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_RETRY_DELAY.getPreferredName()), MAX_RETRY_DELAY, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)READ_POLL_TIMEOUT.getPreferredName()), READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), HEADERS);
    }
}

