/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.SetEnabledProtocolsSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
final class SetEnabledProtocolsSSLSocketFactory
extends SSLSocketFactory {
    private final Set<String> protocols;
    private final SSLSocketFactory delegateFactory;

    SetEnabledProtocolsSSLSocketFactory(SSLSocketFactory delegateFactory, String defaultProtocol) {
        this.delegateFactory = delegateFactory;
        this.protocols = defaultProtocol.equalsIgnoreCase("TLSv1.2") ? new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1.1") ? new HashSet<String>(Arrays.asList("TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1") ? new HashSet<String>(Collections.singletonList("TLSv1")) : Collections.emptySet()));
    }

    SetEnabledProtocolsSSLSocketFactory(SSLSocketFactory delegateFactory, Set<String> protocols) {
        this.delegateFactory = delegateFactory;
        this.protocols = protocols;
    }

    @Override
    public Socket createSocket() throws IOException {
        return new SetEnabledProtocolsSocket(this.delegateFactory.createSocket(), this.protocols);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket createdSocket = this.delegateFactory.createSocket(host, port);
        SSLUtil.applyEnabledSSLProtocols(createdSocket, this.protocols);
        return createdSocket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket createdSocket = this.delegateFactory.createSocket(host, port, localHost, localPort);
        SSLUtil.applyEnabledSSLProtocols(createdSocket, this.protocols);
        return createdSocket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket createdSocket = this.delegateFactory.createSocket(host, port);
        SSLUtil.applyEnabledSSLProtocols(createdSocket, this.protocols);
        return createdSocket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket createdSocket = this.delegateFactory.createSocket(host, port, localHost, localPort);
        SSLUtil.applyEnabledSSLProtocols(createdSocket, this.protocols);
        return createdSocket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket createdSocket = this.delegateFactory.createSocket(s, host, port, autoClose);
        SSLUtil.applyEnabledSSLProtocols(createdSocket, this.protocols);
        return createdSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegateFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateFactory.getSupportedCipherSuites();
    }
}

