/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.XPackSettings;

public class FIPS140JKSKeystoreBootstrapCheck
implements BootstrapCheck {
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(context.settings)).booleanValue()) {
            Settings settings = context.settings;
            Settings keystoreTypeSettings = settings.filter(k -> k.endsWith("keystore.type")).filter(k -> settings.get(k).equalsIgnoreCase("jks"));
            if (!keystoreTypeSettings.isEmpty()) {
                return BootstrapCheck.BootstrapCheckResult.failure((String)("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystoreTypeSettings.toDelimitedString(',') + "] settings"));
            }
            Settings keystorePathSettings = settings.filter(k -> k.endsWith("keystore.path")).filter(k -> !settings.hasValue(k.replace(".path", ".type")));
            if (!keystorePathSettings.isEmpty()) {
                return BootstrapCheck.BootstrapCheckResult.failure((String)("JKS Keystores cannot be used in a FIPS 140 compliant JVM. Please revisit [" + keystorePathSettings.toDelimitedString(',') + "] settings"));
            }
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

