/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public final class AuthorizationUtils {
    private static final Predicate<String> INTERNAL_PREDICATE = Automatons.predicate((String[])new String[]{"internal:*"});

    private AuthorizationUtils() {
    }

    public static boolean shouldReplaceUserWithSystem(ThreadContext threadContext, String action) {
        if (!threadContext.isSystemContext() && !AuthorizationUtils.isInternalAction(action)) {
            return false;
        }
        Authentication authentication = (Authentication)threadContext.getTransient("_xpack_security_authentication");
        if (authentication == null && threadContext.getTransient("action.origin") == null) {
            return true;
        }
        String originatingAction = (String)threadContext.getTransient("_originating_action_name");
        return originatingAction != null && !AuthorizationUtils.isInternalAction(originatingAction);
    }

    public static boolean shouldSetUserBasedOnActionOrigin(ThreadContext context) {
        String actionOrigin = (String)context.getTransient("action.origin");
        Authentication authentication = (Authentication)context.getTransient("_xpack_security_authentication");
        return actionOrigin != null && authentication == null;
    }

    public static void switchUserBasedOnActionOriginAndExecute(ThreadContext threadContext, SecurityContext securityContext, Consumer<ThreadContext.StoredContext> consumer) {
        String actionOrigin = (String)threadContext.getTransient("action.origin");
        if (actionOrigin == null) {
            assert (false) : "cannot switch user if there is no action origin";
            throw new IllegalStateException("cannot switch user if there is no action origin");
        }
        switch (actionOrigin) {
            case "security": {
                securityContext.executeAsUser((User)XPackSecurityUser.INSTANCE, consumer, Version.CURRENT);
                break;
            }
            case "watcher": 
            case "ml": 
            case "monitoring": 
            case "deprecation": 
            case "persistent_tasks": 
            case "rollup": {
                securityContext.executeAsUser((User)XPackUser.INSTANCE, consumer, Version.CURRENT);
                break;
            }
            default: {
                assert (false) : "action.origin [" + actionOrigin + "] is unknown!";
                throw new IllegalStateException("action.origin [" + actionOrigin + "] should always be a known value");
            }
        }
    }

    private static boolean isInternalAction(String action) {
        return INTERNAL_PREDICATE.test(action);
    }

    public static class AsyncAuthorizer {
        private final ActionListener listener;
        private final BiConsumer<Role, Role> consumer;
        private final Authentication authentication;
        private volatile Role userRoles;
        private volatile Role runAsRoles;
        private CountDown countDown = new CountDown(2);

        public AsyncAuthorizer(Authentication authentication, ActionListener listener, BiConsumer<Role, Role> consumer) {
            this.consumer = consumer;
            this.listener = listener;
            this.authentication = authentication;
        }

        public void authorize(AuthorizationService service) {
            if (SystemUser.is((User)this.authentication.getUser().authenticatedUser())) {
                assert (!this.authentication.getUser().isRunAs());
                this.setUserRoles(null);
                this.setRunAsRoles(null);
            } else {
                service.roles(this.authentication.getUser().authenticatedUser(), (ActionListener<Role>)ActionListener.wrap(this::setUserRoles, arg_0 -> ((ActionListener)this.listener).onFailure(arg_0)));
                if (this.authentication.getUser().isRunAs()) {
                    service.roles(this.authentication.getUser(), (ActionListener<Role>)ActionListener.wrap(this::setRunAsRoles, arg_0 -> ((ActionListener)this.listener).onFailure(arg_0)));
                } else {
                    this.setRunAsRoles(null);
                }
            }
        }

        private void setUserRoles(Role roles) {
            this.userRoles = roles;
            this.maybeRun();
        }

        private void setRunAsRoles(Role roles) {
            this.runAsRoles = roles;
            this.maybeRun();
        }

        private void maybeRun() {
            if (this.countDown.countDown()) {
                try {
                    this.consumer.accept(this.userRoles, this.runAsRoles);
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
            }
        }
    }
}

