/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.function.FunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class ScalarFunctionAttribute
extends FunctionAttribute {
    private final ScriptTemplate script;
    private final Expression orderBy;
    private final Pipe pipe;

    ScalarFunctionAttribute(Location location, String name, DataType dataType, ExpressionId id, String functionId, ScriptTemplate script, Expression orderBy, Pipe processorDef) {
        this(location, name, dataType, null, true, id, false, functionId, script, orderBy, processorDef);
    }

    public ScalarFunctionAttribute(Location location, String name, DataType dataType, String qualifier, boolean nullable, ExpressionId id, boolean synthetic, String functionId, ScriptTemplate script, Expression orderBy, Pipe pipe) {
        super(location, name, dataType, qualifier, nullable, id, synthetic, functionId);
        this.script = script;
        this.orderBy = orderBy;
        this.pipe = pipe;
    }

    @Override
    protected NodeInfo<ScalarFunctionAttribute> info() {
        return NodeInfo.create(this, ScalarFunctionAttribute::new, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.functionId(), this.script, this.orderBy, this.pipe);
    }

    public ScriptTemplate script() {
        return this.script;
    }

    public Expression orderBy() {
        return this.orderBy;
    }

    @Override
    public Pipe asPipe() {
        return this.pipe;
    }

    @Override
    protected Expression canonicalize() {
        return new ScalarFunctionAttribute(this.location(), "<none>", this.dataType(), null, true, this.id(), false, this.functionId(), this.script, this.orderBy, this.pipe);
    }

    @Override
    protected Attribute clone(Location location, String name, String qualifier, boolean nullable, ExpressionId id, boolean synthetic) {
        return new ScalarFunctionAttribute(location, name, this.dataType(), qualifier, nullable, id, synthetic, this.functionId(), this.script, this.orderBy, this.pipe);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script(), this.pipe, this.orderBy);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ScalarFunctionAttribute other = (ScalarFunctionAttribute)obj;
            return Objects.equals(this.script, other.script()) && Objects.equals(this.pipe, other.asPipe()) && Objects.equals(this.orderBy, other.orderBy());
        }
        return false;
    }

    @Override
    protected String label() {
        return "s->" + this.functionId();
    }
}

