/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.joda.time.DateTime;

abstract class BaseDateTimeFunction
extends UnaryScalarFunction {
    private final TimeZone timeZone;
    private final String name;

    BaseDateTimeFunction(Location location, Expression field, TimeZone timeZone) {
        super(location, field);
        this.timeZone = timeZone;
        StringBuilder sb = new StringBuilder(super.name());
        sb.insert(sb.length() - 1, " [" + timeZone.getID() + "]");
        this.name = sb.toString();
    }

    @Override
    protected final NodeInfo<BaseDateTimeFunction> info() {
        return NodeInfo.create(this, this.ctorForInfo(), this.field(), this.timeZone());
    }

    protected abstract NodeInfo.NodeCtor2<Expression, TimeZone, BaseDateTimeFunction> ctorForInfo();

    @Override
    protected Expression.TypeResolution resolveType() {
        return Expressions.typeMustBeDate(this.field(), this.functionName(), Expressions.ParamOrdinal.DEFAULT);
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        DateTime folded = (DateTime)this.field().fold();
        if (folded == null) {
            return null;
        }
        return this.doFold(folded.getMillis(), this.timeZone().getID());
    }

    protected abstract Object doFold(long var1, String var3);

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BaseDateTimeFunction other = (BaseDateTimeFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.timeZone(), this.timeZone());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.timeZone());
    }
}

