/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.StringUtils;

public abstract class UnaryStringFunction
extends UnaryScalarFunction {
    protected UnaryStringFunction(Location location, Expression field) {
        super(location, field);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return Expressions.typeMustBeString(this.field(), this.operation().toString(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected Processor makeProcessor() {
        return new StringProcessor(this.operation());
    }

    protected abstract StringProcessor.StringOperation operation();

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.isInexact() ? field.exactAttribute().name() : field.name()).build(), this.dataType());
    }

    @Override
    public String processScript(String template) {
        return this.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(%s)", StringUtils.underscoreToLowerCamelCase(this.operation().name()), template));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnaryStringFunction other = (UnaryStringFunction)obj;
        return Objects.equals(other.field(), this.field());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field());
    }
}

