/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.expression.gen.processor.FunctionalBinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Comparisons;

public class BinaryComparisonProcessor
extends FunctionalBinaryProcessor<Object, Object, Boolean, BinaryComparisonOperation> {
    public static final String NAME = "cb";

    public BinaryComparisonProcessor(Processor left, Processor right, BinaryComparisonOperation operation) {
        super(left, right, operation);
    }

    public BinaryComparisonProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryComparisonOperation)i.readEnum(BinaryComparisonOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    public static enum BinaryComparisonOperation implements PredicateBiFunction<Object, Object, Boolean>
    {
        EQ(Comparisons::eq, "=="),
        NEQ(Comparisons::neq, "!="),
        GT(Comparisons::gt, ">"),
        GTE(Comparisons::gte, ">="),
        LT(Comparisons::lt, "<"),
        LTE(Comparisons::lte, "<=");

        private final BiFunction<Object, Object, Boolean> process;
        private final String symbol;

        private BinaryComparisonOperation(BiFunction<Object, Object, Boolean> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        @Override
        public String symbol() {
            return this.symbol;
        }

        @Override
        public final Boolean doApply(Object left, Object right) {
            return this.process.apply(left, right);
        }

        public String toString() {
            return this.symbol;
        }
    }
}

