/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.type.EsField;

public class SysColumns
extends Command {
    private final String catalog;
    private final String index;
    private final LikePattern pattern;
    private final LikePattern columnPattern;

    public SysColumns(Location location, String catalog, String index, LikePattern pattern, LikePattern columnPattern) {
        super(location);
        this.catalog = catalog;
        this.index = index;
        this.pattern = pattern;
        this.columnPattern = columnPattern;
    }

    @Override
    protected NodeInfo<SysColumns> info() {
        return NodeInfo.create(this, SysColumns::new, this.catalog, this.index, this.pattern, this.columnPattern);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TABLE_CAT"), this.keyword("TABLE_SCHEM"), this.keyword("TABLE_NAME"), this.keyword("COLUMN_NAME"), this.field("DATA_TYPE", DataType.INTEGER), this.keyword("TYPE_NAME"), this.field("COLUMN_SIZE", DataType.INTEGER), this.field("BUFFER_LENGTH", DataType.INTEGER), this.field("DECIMAL_DIGITS", DataType.INTEGER), this.field("NUM_PREC_RADIX", DataType.INTEGER), this.field("NULLABLE", DataType.INTEGER), this.keyword("REMARKS"), this.keyword("COLUMN_DEF"), this.field("SQL_DATA_TYPE", DataType.INTEGER), this.field("SQL_DATETIME_SUB", DataType.INTEGER), this.field("CHAR_OCTET_LENGTH", DataType.INTEGER), this.field("ORDINAL_POSITION", DataType.INTEGER), this.keyword("IS_NULLABLE"), this.keyword("SCOPE_CATALOG"), this.keyword("SCOPE_SCHEMA"), this.keyword("SCOPE_TABLE"), this.field("SOURCE_DATA_TYPE", DataType.SHORT), this.keyword("IS_AUTOINCREMENT"), this.keyword("IS_GENERATEDCOLUMN"));
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        String cluster = session.indexResolver().clusterName();
        if (Strings.hasText((String)this.catalog) && !cluster.equals(this.catalog)) {
            listener.onResponse((Object)Rows.empty(this.output()));
            return;
        }
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        Pattern columnMatcher = this.columnPattern != null ? Pattern.compile(this.columnPattern.asJavaRegex()) : null;
        session.indexResolver().resolveAsSeparateMappings(idx, regex, (ActionListener<List<EsIndex>>)ActionListener.wrap(esIndices -> {
            ArrayList rows = new ArrayList();
            for (EsIndex esIndex : esIndices) {
                SysColumns.fillInRows(cluster, esIndex.name(), esIndex.mapping(), null, rows, columnMatcher);
            }
            listener.onResponse((Object)Rows.of(this.output(), rows));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static void fillInRows(String clusterName, String indexName, Map<String, EsField> mapping, String prefix, List<List<?>> rows, Pattern columnMatcher) {
        int pos = 0;
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            ++pos;
            String name = entry.getKey();
            name = prefix != null ? prefix + "." + name : name;
            EsField field = entry.getValue();
            DataType type = field.getDataType();
            if (columnMatcher == null || columnMatcher.matcher(name).matches()) {
                rows.add(Arrays.asList(clusterName, null, indexName, name, type.jdbcType.getVendorTypeNumber(), type.esType.toUpperCase(Locale.ROOT), type.displaySize, type.size, null, DataTypes.metaSqlRadix(type), 1, null, null, DataTypes.metaSqlDataType(type), DataTypes.metaSqlDateTimeSub(type), type.isString() || type == DataType.BINARY ? Integer.valueOf(type.size) : null, pos, "YES", null, null, null, null, "NO", "NO"));
            }
            if (field.getProperties() == null) continue;
            SysColumns.fillInRows(clusterName, indexName, field.getProperties(), name, rows, columnMatcher);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.index, this.pattern, this.columnPattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SysColumns other = (SysColumns)obj;
        return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.columnPattern, other.columnPattern);
    }
}

