/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.action.admin.indices.RestAnalyzeAction;

public class CategorizationAnalyzerConfig
implements ToXContentFragment,
Writeable {
    public static final ParseField CATEGORIZATION_ANALYZER = new ParseField("categorization_analyzer", new String[0]);
    private static final ParseField TOKENIZER = RestAnalyzeAction.Fields.TOKENIZER;
    private static final ParseField TOKEN_FILTERS = RestAnalyzeAction.Fields.TOKEN_FILTERS;
    private static final ParseField CHAR_FILTERS = RestAnalyzeAction.Fields.CHAR_FILTERS;
    private final String analyzer;
    private final List<NameOrDefinition> charFilters;
    private final NameOrDefinition tokenizer;
    private final List<NameOrDefinition> tokenFilters;

    public static CategorizationAnalyzerConfig buildFromXContentObject(XContentParser parser, boolean ignoreUnknownFields) throws IOException {
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected start object but got [" + parser.currentToken() + "]");
        }
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME || !CATEGORIZATION_ANALYZER.match(parser.currentName(), parser.getDeprecationHandler())) {
            throw new IllegalArgumentException("Expected [" + CATEGORIZATION_ANALYZER + "] field but got [" + parser.currentToken() + "]");
        }
        parser.nextToken();
        CategorizationAnalyzerConfig categorizationAnalyzerConfig = CategorizationAnalyzerConfig.buildFromXContentFragment(parser, ignoreUnknownFields);
        parser.nextToken();
        return categorizationAnalyzerConfig;
    }

    static CategorizationAnalyzerConfig buildFromXContentFragment(XContentParser parser, boolean ignoreUnknownFields) throws IOException {
        Builder builder = new Builder();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            builder.setAnalyzer(parser.text());
        } else {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("[" + CATEGORIZATION_ANALYZER + "] should be analyzer's name or settings [" + token + "]");
            }
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (CHAR_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            builder.addCharFilter(parser.text());
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            builder.addCharFilter(parser.map());
                            continue;
                        }
                        throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] array element should contain char_filter's name or settings [" + token + "]");
                    }
                    continue;
                }
                if (TOKENIZER.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        builder.setTokenizer(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        builder.setTokenizer(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] should be tokenizer's name or settings [" + token + "]");
                }
                if (TOKEN_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            builder.addTokenFilter(parser.text());
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            builder.addTokenFilter(parser.map());
                            continue;
                        }
                        throw new IllegalArgumentException("[" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] array element should contain token_filter's name or settings [" + token + "]");
                    }
                    continue;
                }
                if (ignoreUnknownFields) continue;
                throw new IllegalArgumentException("Parameter [" + currentFieldName + "] in [" + CATEGORIZATION_ANALYZER + "] is unknown or of the wrong type [" + token + "]");
            }
        }
        return builder.build();
    }

    public static CategorizationAnalyzerConfig buildDefaultCategorizationAnalyzer(List<String> categorizationFilters) {
        Builder builder = new Builder();
        if (categorizationFilters != null) {
            for (String categorizationFilter : categorizationFilters) {
                HashMap<String, Object> charFilter = new HashMap<String, Object>();
                charFilter.put("type", "pattern_replace");
                charFilter.put("pattern", categorizationFilter);
                builder.addCharFilter(charFilter);
            }
        }
        builder.setTokenizer("ml_classic");
        HashMap<String, Object> tokenFilter = new HashMap<String, Object>();
        tokenFilter.put("type", "stop");
        tokenFilter.put("stopwords", Arrays.asList("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "GMT", "UTC"));
        builder.addTokenFilter(tokenFilter);
        return builder.build();
    }

    private CategorizationAnalyzerConfig(String analyzer, List<NameOrDefinition> charFilters, NameOrDefinition tokenizer, List<NameOrDefinition> tokenFilters) {
        this.analyzer = analyzer;
        this.charFilters = Objects.requireNonNull(charFilters);
        this.tokenizer = tokenizer;
        this.tokenFilters = Objects.requireNonNull(tokenFilters);
    }

    public CategorizationAnalyzerConfig(StreamInput in) throws IOException {
        this.analyzer = in.readOptionalString();
        this.charFilters = in.readList(NameOrDefinition::new);
        this.tokenizer = (NameOrDefinition)in.readOptionalWriteable(NameOrDefinition::new);
        this.tokenFilters = in.readList(NameOrDefinition::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.analyzer);
        out.writeList(this.charFilters);
        out.writeOptionalWriteable((Writeable)this.tokenizer);
        out.writeList(this.tokenFilters);
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public List<NameOrDefinition> getCharFilters() {
        return this.charFilters;
    }

    public NameOrDefinition getTokenizer() {
        return this.tokenizer;
    }

    public List<NameOrDefinition> getTokenFilters() {
        return this.tokenFilters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.analyzer != null) {
            builder.field(CATEGORIZATION_ANALYZER.getPreferredName(), this.analyzer);
        } else {
            builder.startObject(CATEGORIZATION_ANALYZER.getPreferredName());
            if (!this.charFilters.isEmpty()) {
                builder.startArray(CHAR_FILTERS.getPreferredName());
                for (NameOrDefinition charFilter : this.charFilters) {
                    charFilter.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.tokenizer != null) {
                builder.field(TOKENIZER.getPreferredName(), (ToXContent)this.tokenizer);
            }
            if (!this.tokenFilters.isEmpty()) {
                builder.startArray(TOKEN_FILTERS.getPreferredName());
                for (NameOrDefinition tokenFilter : this.tokenFilters) {
                    tokenFilter.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategorizationAnalyzerConfig that = (CategorizationAnalyzerConfig)o;
        return Objects.equals(this.analyzer, that.analyzer) && Objects.equals(this.charFilters, that.charFilters) && Objects.equals(this.tokenizer, that.tokenizer) && Objects.equals(this.tokenFilters, that.tokenFilters);
    }

    public int hashCode() {
        return Objects.hash(this.analyzer, this.charFilters, this.tokenizer, this.tokenFilters);
    }

    public static class Builder {
        private String analyzer;
        private List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
        private NameOrDefinition tokenizer;
        private List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();

        public Builder() {
        }

        public Builder(CategorizationAnalyzerConfig categorizationAnalyzerConfig) {
            this.analyzer = categorizationAnalyzerConfig.analyzer;
            this.charFilters = new ArrayList<NameOrDefinition>(categorizationAnalyzerConfig.charFilters);
            this.tokenizer = categorizationAnalyzerConfig.tokenizer;
            this.tokenFilters = new ArrayList<NameOrDefinition>(categorizationAnalyzerConfig.tokenFilters);
        }

        public Builder setAnalyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder addCharFilter(String charFilter) {
            this.charFilters.add(new NameOrDefinition(charFilter));
            return this;
        }

        public Builder addCharFilter(Map<String, Object> charFilter) {
            this.charFilters.add(new NameOrDefinition(CHAR_FILTERS, charFilter));
            return this;
        }

        public Builder setTokenizer(String tokenizer) {
            this.tokenizer = new NameOrDefinition(tokenizer);
            return this;
        }

        public Builder setTokenizer(Map<String, Object> tokenizer) {
            this.tokenizer = new NameOrDefinition(TOKENIZER, tokenizer);
            return this;
        }

        public Builder addTokenFilter(String tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(tokenFilter));
            return this;
        }

        public Builder addTokenFilter(Map<String, Object> tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(TOKEN_FILTERS, tokenFilter));
            return this;
        }

        public CategorizationAnalyzerConfig build() {
            if (this.analyzer == null && this.tokenizer == null) {
                throw new IllegalArgumentException(CATEGORIZATION_ANALYZER + " that is not a global analyzer must specify a [" + TOKENIZER + "] field");
            }
            if (this.analyzer != null && !this.charFilters.isEmpty()) {
                throw new IllegalArgumentException(CATEGORIZATION_ANALYZER + " that is a global analyzer cannot also specify a [" + CHAR_FILTERS + "] field");
            }
            if (this.analyzer != null && this.tokenizer != null) {
                throw new IllegalArgumentException(CATEGORIZATION_ANALYZER + " that is a global analyzer cannot also specify a [" + TOKENIZER + "] field");
            }
            if (this.analyzer != null && !this.tokenFilters.isEmpty()) {
                throw new IllegalArgumentException(CATEGORIZATION_ANALYZER + " that is a global analyzer cannot also specify a [" + TOKEN_FILTERS + "] field");
            }
            return new CategorizationAnalyzerConfig(this.analyzer, this.charFilters, this.tokenizer, this.tokenFilters);
        }
    }

    public static class NameOrDefinition
    implements ToXContentFragment,
    Writeable {
        public final String name;
        public final Settings definition;

        NameOrDefinition(String name) {
            this.name = Objects.requireNonNull(name);
            this.definition = null;
        }

        NameOrDefinition(ParseField field, Map<String, Object> definition) {
            this.name = null;
            Objects.requireNonNull(definition);
            try {
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                builder.map(definition);
                this.definition = Settings.builder().loadFromSource(Strings.toString((XContentBuilder)builder), builder.contentType()).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse [" + definition + "] in [" + field.getPreferredName() + "]", e);
            }
        }

        NameOrDefinition(StreamInput in) throws IOException {
            this.name = in.readOptionalString();
            this.definition = in.readBoolean() ? Settings.readSettingsFromStream((StreamInput)in) : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.name);
            boolean isNotNullDefinition = this.definition != null;
            out.writeBoolean(isNotNullDefinition);
            if (isNotNullDefinition) {
                Settings.writeSettingsToStream((Settings)this.definition, (StreamOutput)out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.definition == null) {
                builder.value(this.name);
            } else {
                builder.startObject();
                this.definition.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameOrDefinition that = (NameOrDefinition)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.definition);
        }

        public String toString() {
            if (this.definition == null) {
                return this.name;
            }
            return this.definition.toDelimitedString(';');
        }
    }
}

