/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.ObjectPath;

public class XContentSource
implements ToXContent {
    private final BytesReference bytes;
    private final XContentType contentType;
    private Object data;

    public XContentSource(BytesReference bytes, XContentType xContentType) throws ElasticsearchParseException {
        if (xContentType == null) {
            throw new IllegalArgumentException("xContentType must not be null");
        }
        this.bytes = bytes;
        this.contentType = xContentType;
    }

    public XContentSource(XContentBuilder builder) {
        this(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
    }

    public BytesReference getBytes() {
        return this.bytes;
    }

    public boolean isMap() {
        return this.data() instanceof Map;
    }

    public Map<String, Object> getAsMap() {
        return (Map)this.data();
    }

    public boolean isList() {
        return this.data() instanceof List;
    }

    public List<Object> getAsList() {
        return (List)this.data();
    }

    public <T> T getValue(String path) {
        return ObjectPath.eval(path, this.data());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (StreamInput stream = this.bytes.streamInput();){
            XContentBuilder xContentBuilder;
            block12: {
                XContentParser parser = this.parser(NamedXContentRegistry.EMPTY, (InputStream)stream);
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                    xContentBuilder = builder;
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return xContentBuilder;
        }
    }

    public XContentParser parser(NamedXContentRegistry xContentRegistry, InputStream stream) throws IOException {
        return this.contentType.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);
    }

    public static XContentSource readFrom(StreamInput in) throws IOException {
        return new XContentSource(in.readBytesReference(), (XContentType)in.readEnum(XContentType.class));
    }

    public static void writeTo(XContentSource source, StreamOutput out) throws IOException {
        out.writeBytesReference(source.bytes);
        out.writeEnum((Enum)source.contentType);
    }

    private Object data() {
        if (this.data == null) {
            try (StreamInput stream = this.bytes.streamInput();
                 XContentParser parser = this.parser(NamedXContentRegistry.EMPTY, (InputStream)stream);){
                this.data = XContentUtils.readValue(parser, parser.nextToken());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }
}

