/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class MultiSearchRequest
extends ActionRequest
implements CompositeIndicesRequest {
    public static final int MAX_CONCURRENT_SEARCH_REQUESTS_DEFAULT = 0;
    private int maxConcurrentSearchRequests = 0;
    private List<SearchRequest> requests = new ArrayList<SearchRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add((SearchRequest)request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.maxConcurrentSearchRequests = in.readVInt();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.maxConcurrentSearchRequests);
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSearchRequest that = (MultiSearchRequest)o;
        return this.maxConcurrentSearchRequests == that.maxConcurrentSearchRequests && Objects.equals(this.requests, that.requests) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxConcurrentSearchRequests, this.requests, this.indicesOptions);
    }

    public static void readMultiLineFormat(BytesReference data, XContent xContent, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer, String[] indices, IndicesOptions indicesOptions, String[] types, String routing, String searchType, NamedXContentRegistry registry, boolean allowExplicitIndex) throws IOException {
        int nextMarker;
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = MultiSearchRequest.findNextMarker(marker, from, data, length)) != -1) {
            if (nextMarker == 0) {
                from = nextMarker + 1;
                continue;
            }
            SearchRequest searchRequest = new SearchRequest();
            if (indices != null) {
                searchRequest.indices(indices);
            }
            if (indicesOptions != null) {
                searchRequest.indicesOptions(indicesOptions);
            }
            if (types != null && types.length > 0) {
                searchRequest.types(types);
            }
            if (routing != null) {
                searchRequest.routing(routing);
            }
            if (searchType != null) {
                searchRequest.searchType(searchType);
            }
            IndicesOptions defaultOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
            if (nextMarker - from > 0) {
                try (StreamInput stream = data.slice(from, nextMarker - from).streamInput();
                     XContentParser parser = xContent.createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
                    Map<String, Object> source = parser.map();
                    for (Map.Entry<String, Object> entry : source.entrySet()) {
                        Object value = entry.getValue();
                        if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                            if (!allowExplicitIndex) {
                                throw new IllegalArgumentException("explicit index in multi search is not allowed");
                            }
                            searchRequest.indices(XContentMapValues.nodeStringArrayValue(value));
                            continue;
                        }
                        if ("type".equals(entry.getKey()) || "types".equals(entry.getKey())) {
                            searchRequest.types(XContentMapValues.nodeStringArrayValue(value));
                            continue;
                        }
                        if ("search_type".equals(entry.getKey()) || "searchType".equals(entry.getKey())) {
                            searchRequest.searchType(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("request_cache".equals(entry.getKey()) || "requestCache".equals(entry.getKey())) {
                            searchRequest.requestCache(XContentMapValues.nodeBooleanValue(value, entry.getKey()));
                            continue;
                        }
                        if ("preference".equals(entry.getKey())) {
                            searchRequest.preference(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("routing".equals(entry.getKey())) {
                            searchRequest.routing(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if (!"allow_partial_search_results".equals(entry.getKey())) continue;
                        searchRequest.allowPartialSearchResults(XContentMapValues.nodeBooleanValue(value, null));
                    }
                    defaultOptions = IndicesOptions.fromMap(source, defaultOptions);
                }
            }
            searchRequest.indicesOptions(defaultOptions);
            from = nextMarker + 1;
            nextMarker = MultiSearchRequest.findNextMarker(marker, from, data, length);
            if (nextMarker == -1) break;
            BytesReference bytes = data.slice(from, nextMarker - from);
            try (StreamInput stream = bytes.streamInput();
                 XContentParser parser = xContent.createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
                consumer.accept(searchRequest, parser);
            }
            from = nextMarker + 1;
        }
    }

    private static int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        if (from != length) {
            throw new IllegalArgumentException("The msearch request must be terminated by a newline [\n]");
        }
        return -1;
    }

    public static byte[] writeMultiLineFormat(MultiSearchRequest multiSearchRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchRequest request : multiSearchRequest.requests()) {
            try (XContentBuilder xContentBuilder = XContentBuilder.builder(xContent);){
                MultiSearchRequest.writeSearchRequestParams(request, xContentBuilder);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            output.write(xContent.streamSeparator());
            xContentBuilder = XContentBuilder.builder(xContent);
            try {
                if (request.source() != null) {
                    request.source().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                } else {
                    xContentBuilder.startObject();
                    xContentBuilder.endObject();
                }
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.streamSeparator());
        }
        return output.toByteArray();
    }

    public static void writeSearchRequestParams(SearchRequest request, XContentBuilder xContentBuilder) throws IOException {
        xContentBuilder.startObject();
        if (request.indices() != null) {
            xContentBuilder.field("index", request.indices());
        }
        if (request.indicesOptions() != null && request.indicesOptions() != SearchRequest.DEFAULT_INDICES_OPTIONS) {
            if (request.indicesOptions().expandWildcardsOpen() && request.indicesOptions().expandWildcardsClosed()) {
                xContentBuilder.field("expand_wildcards", "all");
            } else if (request.indicesOptions().expandWildcardsOpen()) {
                xContentBuilder.field("expand_wildcards", "open");
            } else if (request.indicesOptions().expandWildcardsClosed()) {
                xContentBuilder.field("expand_wildcards", "closed");
            } else {
                xContentBuilder.field("expand_wildcards", "none");
            }
            xContentBuilder.field("ignore_unavailable", request.indicesOptions().ignoreUnavailable());
            xContentBuilder.field("allow_no_indices", request.indicesOptions().allowNoIndices());
        }
        if (request.types() != null) {
            xContentBuilder.field("types", request.types());
        }
        if (request.searchType() != null) {
            xContentBuilder.field("search_type", request.searchType().name().toLowerCase(Locale.ROOT));
        }
        if (request.requestCache() != null) {
            xContentBuilder.field("request_cache", request.requestCache());
        }
        if (request.preference() != null) {
            xContentBuilder.field("preference", request.preference());
        }
        if (request.routing() != null) {
            xContentBuilder.field("routing", request.routing());
        }
        if (request.allowPartialSearchResults() != null) {
            xContentBuilder.field("allow_partial_search_results", request.allowPartialSearchResults());
        }
        xContentBuilder.endObject();
    }
}

