/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetBucketsAction
extends HandledTransportAction<GetBucketsAction.Request, GetBucketsAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;
    private final Client client;

    @Inject
    public TransportGetBucketsAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobResultsProvider jobResultsProvider, JobManager jobManager, Client client) {
        super(settings, "cluster:monitor/xpack/ml/job/results/buckets/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetBucketsAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
        this.client = client;
    }

    protected void doExecute(GetBucketsAction.Request request, ActionListener<GetBucketsAction.Response> listener) {
        this.jobManager.getJobOrThrowIfUnknown(request.getJobId());
        BucketsQueryBuilder query = new BucketsQueryBuilder().expand(request.isExpand()).includeInterim(!request.isExcludeInterim()).start(request.getStart()).end(request.getEnd()).anomalyScoreThreshold(request.getAnomalyScore()).sortField(request.getSort()).sortDescending(request.isDescending());
        if (request.getPageParams() != null) {
            query.from(request.getPageParams().getFrom()).size(request.getPageParams().getSize());
        }
        if (request.getTimestamp() != null) {
            query.timestamp(request.getTimestamp());
        } else {
            query.start(request.getStart());
            query.end(request.getEnd());
        }
        this.jobResultsProvider.buckets(request.getJobId(), query, q -> listener.onResponse((Object)new GetBucketsAction.Response(q)), arg_0 -> listener.onFailure(arg_0), this.client);
    }
}

