/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureUtils;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlFileStructureFinder
implements FileStructureFinder {
    private final List<String> sampleMessages;
    private final FileStructure structure;

    static XmlFileStructureFinder makeXmlFileStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException, ParserConfigurationException, SAXException {
        Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> mappingsAndFieldStats;
        String messagePrefix;
        try (Scanner scanner = new Scanner(sample);){
            messagePrefix = scanner.next();
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(false);
        docBuilderFactory.setValidating(false);
        ArrayList<String> sampleMessages = new ArrayList<String>();
        ArrayList sampleRecords = new ArrayList();
        String[] sampleDocEnds = sample.split(Pattern.quote(messagePrefix));
        StringBuilder preamble = new StringBuilder(sampleDocEnds[0]);
        int linesConsumed = XmlFileStructureFinder.numNewlinesIn(sampleDocEnds[0]);
        for (int i = 1; i < sampleDocEnds.length; ++i) {
            String sampleDoc = messagePrefix + sampleDocEnds[i];
            if (i < 3) {
                preamble.append(sampleDoc);
            }
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            try (ByteArrayInputStream is = new ByteArrayInputStream(sampleDoc.getBytes(StandardCharsets.UTF_8));){
                sampleRecords.add(XmlFileStructureFinder.docToMap(docBuilder.parse(is)));
                sampleMessages.add(sampleDoc);
                linesConsumed += XmlFileStructureFinder.numNewlinesIn(sampleDoc);
                timeoutChecker.check("XML parsing");
                continue;
            }
            catch (SAXException e) {
                if (!sampleRecords.isEmpty() && i >= sampleDocEnds.length - 1) continue;
                throw e;
            }
        }
        if (!sample.endsWith("\n")) {
            ++linesConsumed;
        }
        assert (messagePrefix.charAt(0) == '<');
        String topLevelTag = messagePrefix.substring(1);
        FileStructure.Builder structureBuilder = new FileStructure.Builder(FileStructure.Format.XML).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(preamble.toString()).setNumLinesAnalyzed(linesConsumed).setNumMessagesAnalyzed(sampleRecords.size()).setMultilineStartPattern("^\\s*<" + topLevelTag);
        Tuple<String, TimestampFormatFinder.TimestampMatch> timeField = FileStructureUtils.guessTimestampField(explanation, sampleRecords, overrides, timeoutChecker);
        if (timeField != null) {
            boolean needClientTimeZone = ((TimestampFormatFinder.TimestampMatch)timeField.v2()).hasTimezoneDependentParsing();
            structureBuilder.setTimestampField((String)timeField.v1()).setJodaTimestampFormats(((TimestampFormatFinder.TimestampMatch)timeField.v2()).jodaTimestampFormats).setJavaTimestampFormats(((TimestampFormatFinder.TimestampMatch)timeField.v2()).javaTimestampFormats).setNeedClientTimezone(needClientTimeZone).setIngestPipeline(FileStructureUtils.makeIngestPipelineDefinition(null, topLevelTag + "." + (String)timeField.v1(), ((TimestampFormatFinder.TimestampMatch)timeField.v2()).jodaTimestampFormats, needClientTimeZone));
        }
        if ((mappingsAndFieldStats = FileStructureUtils.guessMappingsAndCalculateFieldStats(explanation, sampleRecords, timeoutChecker)).v2() != null) {
            structureBuilder.setFieldStats((Map)mappingsAndFieldStats.v2());
        }
        SortedMap innerMappings = (SortedMap)mappingsAndFieldStats.v1();
        LinkedHashMap<String, Object> secondLevelProperties = new LinkedHashMap<String, Object>();
        secondLevelProperties.put("type", "object");
        secondLevelProperties.put("properties", innerMappings);
        TreeMap<String, Map<String, Object>> outerMappings = new TreeMap<String, Map<String, Object>>();
        outerMappings.put(topLevelTag, secondLevelProperties);
        if (timeField != null) {
            outerMappings.put("@timestamp", Collections.singletonMap("type", "date"));
        }
        FileStructure structure = structureBuilder.setMappings(outerMappings).setExplanation(explanation).build();
        return new XmlFileStructureFinder(sampleMessages, structure);
    }

    private XmlFileStructureFinder(List<String> sampleMessages, FileStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public FileStructure getStructure() {
        return this.structure;
    }

    private static int numNewlinesIn(String str) {
        return (int)str.chars().filter(c -> c == 10).count();
    }

    private static Map<String, Object> docToMap(Document doc) {
        LinkedHashMap<String, Object> docAsMap = new LinkedHashMap<String, Object>();
        doc.getDocumentElement().normalize();
        XmlFileStructureFinder.addNodeToMap(doc.getDocumentElement(), docAsMap);
        return docAsMap;
    }

    private static void addNodeToMap(Node node, Map<String, Object> nodeAsMap) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            nodeAsMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getChildNodes().getLength() == 1) {
                Node grandChild = child.getChildNodes().item(0);
                String value = grandChild.getNodeValue().trim();
                if (value.isEmpty()) continue;
                nodeAsMap.put(child.getNodeName(), value);
                continue;
            }
            LinkedHashMap<String, Object> childNodeAsMap = new LinkedHashMap<String, Object>();
            XmlFileStructureFinder.addNodeToMap(child, childNodeAsMap);
            if (childNodeAsMap.isEmpty()) continue;
            nodeAsMap.put(child.getNodeName(), childNodeAsMap);
        }
    }
}

