/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.time.Duration;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushListener;
import org.elasticsearch.xpack.ml.job.process.normalizer.Renormalizer;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class AutoDetectResultProcessor {
    private static final Logger LOGGER = Loggers.getLogger(AutoDetectResultProcessor.class);
    private static final TimeValue ESTABLISHED_MODEL_MEMORY_UPDATE_DELAY = TimeValue.timeValueSeconds((long)5L);
    private final Client client;
    private final Auditor auditor;
    private final String jobId;
    private final Renormalizer renormalizer;
    private final JobResultsPersister persister;
    private final JobResultsProvider jobResultsProvider;
    private final boolean restoredSnapshot;
    final CountDownLatch completionLatch = new CountDownLatch(1);
    final Semaphore updateModelSnapshotIdSemaphore = new Semaphore(1);
    private final FlushListener flushListener;
    private volatile boolean processKilled;
    private volatile boolean failed;
    private int bucketCount;
    private volatile ModelSizeStats latestModelSizeStats;
    private volatile Date latestDateForEstablishedModelMemoryCalc;
    private volatile long latestEstablishedModelMemory;
    private volatile boolean haveNewLatestModelSizeStats;
    private Future<?> scheduledEstablishedModelMemoryUpdate;

    public AutoDetectResultProcessor(Client client, Auditor auditor, String jobId, Renormalizer renormalizer, JobResultsPersister persister, JobResultsProvider jobResultsProvider, ModelSizeStats latestModelSizeStats, boolean restoredSnapshot) {
        this(client, auditor, jobId, renormalizer, persister, jobResultsProvider, latestModelSizeStats, restoredSnapshot, new FlushListener());
    }

    AutoDetectResultProcessor(Client client, Auditor auditor, String jobId, Renormalizer renormalizer, JobResultsPersister persister, JobResultsProvider jobResultsProvider, ModelSizeStats latestModelSizeStats, boolean restoredSnapshot, FlushListener flushListener) {
        this.client = Objects.requireNonNull(client);
        this.auditor = Objects.requireNonNull(auditor);
        this.jobId = Objects.requireNonNull(jobId);
        this.renormalizer = Objects.requireNonNull(renormalizer);
        this.persister = Objects.requireNonNull(persister);
        this.jobResultsProvider = Objects.requireNonNull(jobResultsProvider);
        this.flushListener = Objects.requireNonNull(flushListener);
        this.latestModelSizeStats = Objects.requireNonNull(latestModelSizeStats);
        this.restoredSnapshot = restoredSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AutodetectProcess process) {
        Context context = new Context(this.jobId, this.persister.bulkPersisterBuilder(this.jobId));
        try {
            this.bucketCount = 0;
            Iterator<AutodetectResult> iterator = process.readAutodetectResults();
            while (iterator.hasNext()) {
                try {
                    AutodetectResult result = iterator.next();
                    this.processResult(context, result);
                    if (result.getBucket() == null) continue;
                    LOGGER.trace("[{}] Bucket number {} parsed from output", (Object)this.jobId, (Object)this.bucketCount);
                }
                catch (Exception e) {
                    if (this.processKilled) {
                        throw e;
                    }
                    if (!process.isProcessAliveAfterWaiting()) {
                        throw e;
                    }
                    LOGGER.warn((Message)new ParameterizedMessage("[{}] Error processing autodetect result", (Object)this.jobId), (Throwable)e);
                }
            }
            try {
                if (!this.processKilled) {
                    context.bulkResultsPersister.executeRequest();
                }
            }
            catch (Exception e) {
                LOGGER.warn((Message)new ParameterizedMessage("[{}] Error persisting autodetect results", (Object)this.jobId), (Throwable)e);
            }
            LOGGER.info("[{}] {} buckets parsed from autodetect output", (Object)this.jobId, (Object)this.bucketCount);
            this.runEstablishedModelMemoryUpdate(true);
        }
        catch (Exception e) {
            this.failed = true;
            if (this.processKilled) {
                LOGGER.warn("[{}] some results not processed due to the process being killed", (Object)this.jobId);
            } else if (!process.isProcessAliveAfterWaiting()) {
                LOGGER.warn("[{}] some results not processed due to the termination of autodetect", (Object)this.jobId);
            } else {
                LOGGER.error((Message)new ParameterizedMessage("[{}] error parsing autodetect output", (Object)this.jobId), (Throwable)e);
            }
        }
        finally {
            this.flushListener.clear();
            this.completionLatch.countDown();
        }
    }

    public void setProcessKilled() {
        this.processKilled = true;
        this.renormalizer.shutdown();
    }

    void processResult(Context context, AutodetectResult result) {
        FlushAcknowledgement flushAcknowledgement;
        Quantiles quantiles;
        ModelSnapshot modelSnapshot;
        ModelSizeStats modelSizeStats;
        ForecastRequestStats forecastRequestStats;
        Forecast forecast;
        ModelPlot modelPlot;
        CategoryDefinition categoryDefinition;
        List<Influencer> influencers;
        List<AnomalyRecord> records;
        if (this.processKilled) {
            return;
        }
        Bucket bucket = result.getBucket();
        if (bucket != null) {
            if (context.deleteInterimRequired) {
                LOGGER.trace("[{}] Deleting interim results", (Object)context.jobId);
                this.persister.deleteInterimResults(context.jobId);
                context.deleteInterimRequired = false;
            }
            context.bulkResultsPersister.persistBucket(bucket).executeRequest();
            this.latestDateForEstablishedModelMemoryCalc = bucket.getTimestamp();
            ++this.bucketCount;
            long minEstablishedTimespanMs = 20L * bucket.getBucketSpan() * 1000L;
            if (this.haveNewLatestModelSizeStats && this.latestEstablishedModelMemory == 0L && this.latestDateForEstablishedModelMemoryCalc.getTime() > this.latestModelSizeStats.getTimestamp().getTime() + minEstablishedTimespanMs) {
                this.scheduleEstablishedModelMemoryUpdate(ESTABLISHED_MODEL_MEMORY_UPDATE_DELAY);
                this.haveNewLatestModelSizeStats = false;
            }
        }
        if ((records = result.getRecords()) != null && !records.isEmpty()) {
            context.bulkResultsPersister.persistRecords(records);
        }
        if ((influencers = result.getInfluencers()) != null && !influencers.isEmpty()) {
            context.bulkResultsPersister.persistInfluencers(influencers);
        }
        if ((categoryDefinition = result.getCategoryDefinition()) != null) {
            this.persister.persistCategoryDefinition(categoryDefinition);
        }
        if ((modelPlot = result.getModelPlot()) != null) {
            context.bulkResultsPersister.persistModelPlot(modelPlot);
        }
        if ((forecast = result.getForecast()) != null) {
            context.bulkResultsPersister.persistForecast(forecast);
        }
        if ((forecastRequestStats = result.getForecastRequestStats()) != null) {
            LOGGER.trace("Received Forecast Stats [{}]", (Object)forecastRequestStats.getId());
            context.bulkResultsPersister.persistForecastRequestStats(forecastRequestStats);
            switch (forecastRequestStats.getStatus()) {
                case OK: 
                case STARTED: {
                    break;
                }
                default: {
                    context.bulkResultsPersister.executeRequest();
                }
            }
        }
        if ((modelSizeStats = result.getModelSizeStats()) != null) {
            this.processModelSizeStats(context, modelSizeStats);
        }
        if ((modelSnapshot = result.getModelSnapshot()) != null) {
            this.persister.persistModelSnapshot(modelSnapshot, WriteRequest.RefreshPolicy.IMMEDIATE);
            this.updateModelSnapshotIdOnJob(modelSnapshot);
        }
        if ((quantiles = result.getQuantiles()) != null) {
            LOGGER.debug("[{}] Parsed Quantiles with timestamp {}", (Object)context.jobId, (Object)quantiles.getTimestamp());
            this.persister.persistQuantiles(quantiles);
            context.bulkResultsPersister.executeRequest();
            if (!this.processKilled && this.renormalizer.isEnabled()) {
                this.persister.commitResultWrites(context.jobId);
                LOGGER.debug("[{}] Quantiles queued for renormalization", (Object)context.jobId);
                this.renormalizer.renormalize(quantiles);
            }
        }
        if ((flushAcknowledgement = result.getFlushAcknowledgement()) != null) {
            LOGGER.debug("[{}] Flush acknowledgement parsed from output for ID {}", (Object)context.jobId, (Object)flushAcknowledgement.getId());
            context.bulkResultsPersister.executeRequest();
            this.persister.commitResultWrites(context.jobId);
            this.flushListener.acknowledgeFlush(flushAcknowledgement);
            context.deleteInterimRequired = true;
        }
    }

    private void processModelSizeStats(Context context, ModelSizeStats modelSizeStats) {
        LOGGER.trace("[{}] Parsed ModelSizeStats: {} / {} / {} / {} / {} / {}", (Object)context.jobId, (Object)modelSizeStats.getModelBytes(), (Object)modelSizeStats.getTotalByFieldCount(), (Object)modelSizeStats.getTotalOverFieldCount(), (Object)modelSizeStats.getTotalPartitionFieldCount(), (Object)modelSizeStats.getBucketAllocationFailuresCount(), (Object)modelSizeStats.getMemoryStatus());
        this.persister.persistModelSizeStats(modelSizeStats);
        this.notifyModelMemoryStatusChange(context, modelSizeStats);
        this.latestModelSizeStats = modelSizeStats;
        this.latestDateForEstablishedModelMemoryCalc = modelSizeStats.getTimestamp();
        this.haveNewLatestModelSizeStats = true;
        if (this.restoredSnapshot || this.bucketCount >= 20) {
            this.scheduleEstablishedModelMemoryUpdate(ESTABLISHED_MODEL_MEMORY_UPDATE_DELAY);
        }
    }

    private void notifyModelMemoryStatusChange(Context context, ModelSizeStats modelSizeStats) {
        ModelSizeStats.MemoryStatus memoryStatus = modelSizeStats.getMemoryStatus();
        if (memoryStatus != this.latestModelSizeStats.getMemoryStatus()) {
            if (memoryStatus == ModelSizeStats.MemoryStatus.SOFT_LIMIT) {
                this.auditor.warning(context.jobId, Messages.getMessage((String)"Job memory status changed to soft_limit; memory pruning will now be more aggressive"));
            } else if (memoryStatus == ModelSizeStats.MemoryStatus.HARD_LIMIT) {
                this.auditor.error(context.jobId, Messages.getMessage((String)"Job memory status changed to hard_limit at {0}; adjust the analysis_limits.model_memory_limit setting to ensure all data is analyzed", (Object[])new Object[]{new ByteSizeValue(modelSizeStats.getModelBytes(), ByteSizeUnit.BYTES).toString()}));
            }
        }
    }

    protected void updateModelSnapshotIdOnJob(final ModelSnapshot modelSnapshot) {
        JobUpdate update = new JobUpdate.Builder(this.jobId).setModelSnapshotId(modelSnapshot.getSnapshotId()).build();
        UpdateJobAction.Request updateRequest = UpdateJobAction.Request.internal((String)this.jobId, (JobUpdate)update);
        try {
            this.updateModelSnapshotIdSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("[{}] Interrupted acquiring update model snapshot semaphore", (Object)this.jobId);
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)new ActionListener<PutJobAction.Response>(){

            public void onResponse(PutJobAction.Response response) {
                AutoDetectResultProcessor.this.updateModelSnapshotIdSemaphore.release();
                LOGGER.debug("[{}] Updated job with model snapshot id [{}]", (Object)AutoDetectResultProcessor.this.jobId, (Object)modelSnapshot.getSnapshotId());
            }

            public void onFailure(Exception e) {
                AutoDetectResultProcessor.this.updateModelSnapshotIdSemaphore.release();
                LOGGER.error("[" + AutoDetectResultProcessor.this.jobId + "] Failed to update job with new model snapshot id [" + modelSnapshot.getSnapshotId() + "]", (Throwable)e);
            }
        });
    }

    synchronized void scheduleEstablishedModelMemoryUpdate(TimeValue delay) {
        if (this.scheduledEstablishedModelMemoryUpdate == null) {
            try {
                this.scheduledEstablishedModelMemoryUpdate = this.client.threadPool().schedule(delay, "ml_utility", () -> this.runEstablishedModelMemoryUpdate(false));
                LOGGER.trace("[{}] Scheduled established model memory update to run in [{}]", (Object)this.jobId, (Object)delay);
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    LOGGER.debug("failed to schedule established model memory update; shutting down", (Throwable)e);
                }
                throw e;
            }
        }
    }

    private synchronized void runEstablishedModelMemoryUpdate(boolean cancelExisting) {
        if (this.scheduledEstablishedModelMemoryUpdate != null) {
            if (cancelExisting) {
                LOGGER.debug("[{}] Bringing forward previously scheduled established model memory update", (Object)this.jobId);
                FutureUtils.cancel(this.scheduledEstablishedModelMemoryUpdate);
            }
            this.scheduledEstablishedModelMemoryUpdate = null;
            this.updateEstablishedModelMemoryOnJob();
        }
    }

    private void updateEstablishedModelMemoryOnJob() {
        Date latestBucketTimestamp = this.latestDateForEstablishedModelMemoryCalc;
        ModelSizeStats modelSizeStatsForCalc = this.latestModelSizeStats;
        this.persister.commitResultWrites(this.jobId);
        this.jobResultsProvider.getEstablishedMemoryUsage(this.jobId, latestBucketTimestamp, modelSizeStatsForCalc, establishedModelMemory -> {
            if (this.latestEstablishedModelMemory != establishedModelMemory) {
                JobUpdate update = new JobUpdate.Builder(this.jobId).setEstablishedModelMemory(establishedModelMemory).build();
                UpdateJobAction.Request updateRequest = UpdateJobAction.Request.internal((String)this.jobId, (JobUpdate)update);
                updateRequest.setWaitForAck(false);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)new ActionListener<PutJobAction.Response>(){

                    public void onResponse(PutJobAction.Response response) {
                        AutoDetectResultProcessor.this.latestEstablishedModelMemory = establishedModelMemory;
                        LOGGER.debug("[{}] Updated job with established model memory [{}]", (Object)AutoDetectResultProcessor.this.jobId, (Object)establishedModelMemory);
                    }

                    public void onFailure(Exception e) {
                        LOGGER.error("[" + AutoDetectResultProcessor.this.jobId + "] Failed to update job with new established model memory [" + establishedModelMemory + "]", (Throwable)e);
                    }
                });
            }
        }, e -> LOGGER.error("[" + this.jobId + "] Failed to calculate established model memory", (Throwable)e));
    }

    public void awaitCompletion() throws TimeoutException {
        try {
            if (!this.completionLatch.await(MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT.getMinutes(), TimeUnit.MINUTES)) {
                throw new TimeoutException("Timed out waiting for results processor to complete for job " + this.jobId);
            }
            this.updateModelSnapshotIdSemaphore.acquire();
            this.updateModelSnapshotIdSemaphore.release();
            this.waitUntilRenormalizerIsIdle();
            this.persister.commitResultWrites(this.jobId);
            this.persister.commitStateWrites(this.jobId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("[{}] Interrupted waiting for results processor to complete", (Object)this.jobId);
        }
    }

    @Nullable
    public FlushAcknowledgement waitForFlushAcknowledgement(String flushId, Duration timeout) throws InterruptedException {
        return this.failed ? null : this.flushListener.waitForFlush(flushId, timeout);
    }

    public void clearAwaitingFlush(String flushId) {
        this.flushListener.clear(flushId);
    }

    public void waitUntilRenormalizerIsIdle() {
        this.renormalizer.waitUntilIdle();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public ModelSizeStats modelSizeStats() {
        return this.latestModelSizeStats;
    }

    static class Context {
        private final String jobId;
        private JobResultsPersister.Builder bulkResultsPersister;
        boolean deleteInterimRequired;

        Context(String jobId, JobResultsPersister.Builder bulkResultsPersister) {
            this.jobId = jobId;
            this.deleteInterimRequired = true;
            this.bulkResultsPersister = bulkResultsPersister;
        }
    }
}

