/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.notifications;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.notifications.AuditMessage;

public class Auditor {
    private static final Logger LOGGER = Loggers.getLogger(Auditor.class);
    private final Client client;
    private final String nodeName;

    public Auditor(Client client, String nodeName) {
        this.client = Objects.requireNonNull(client);
        this.nodeName = Objects.requireNonNull(nodeName);
    }

    public void info(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newInfo((String)jobId, (String)message, (String)this.nodeName));
    }

    public void warning(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newWarning((String)jobId, (String)message, (String)this.nodeName));
    }

    public void error(String jobId, String message) {
        this.indexDoc(AuditMessage.TYPE.getPreferredName(), (ToXContent)AuditMessage.newError((String)jobId, (String)message, (String)this.nodeName));
    }

    private void indexDoc(final String type, ToXContent toXContent) {
        IndexRequest indexRequest = new IndexRequest(".ml-notifications", type);
        indexRequest.source(this.toXContentBuilder(toXContent));
        indexRequest.timeout(TimeValue.timeValueSeconds((long)5L));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                LOGGER.trace("Successfully persisted {}", (Object)type);
            }

            public void onFailure(Exception e) {
                LOGGER.debug((Message)new ParameterizedMessage("Error writing {}", new Object[]{type}, (Throwable)e));
            }
        }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
    }

    private XContentBuilder toXContentBuilder(ToXContent toXContent) {
        XContentBuilder xContentBuilder;
        block8: {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            try {
                xContentBuilder = toXContent.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
                if (jsonBuilder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonBuilder != null) {
                        try {
                            jsonBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonBuilder.close();
        }
        return xContentBuilder;
    }
}

