/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestCloseJobAction
extends BaseRestHandler {
    public RestCloseJobAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/_close", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_close_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        CloseJobAction.Request request;
        if (restRequest.hasContentOrSourceParam()) {
            request = CloseJobAction.Request.parseRequest((String)restRequest.param(Job.ID.getPreferredName()), (XContentParser)restRequest.contentParser());
        } else {
            request = new CloseJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
            if (restRequest.hasParam(CloseJobAction.Request.TIMEOUT.getPreferredName())) {
                request.setCloseTimeout(TimeValue.parseTimeValue((String)restRequest.param(CloseJobAction.Request.TIMEOUT.getPreferredName()), (String)CloseJobAction.Request.TIMEOUT.getPreferredName()));
            }
            if (restRequest.hasParam(CloseJobAction.Request.FORCE.getPreferredName())) {
                request.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), request.isForce()));
            }
            if (restRequest.hasParam(CloseJobAction.Request.ALLOW_NO_JOBS.getPreferredName())) {
                request.setAllowNoJobs(restRequest.paramAsBoolean(CloseJobAction.Request.ALLOW_NO_JOBS.getPreferredName(), request.allowNoJobs()));
            }
        }
        return channel -> client.execute((Action)CloseJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

