/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.transform.script.ExecutableScriptTransform;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;

public class ScriptTransformFactory
extends TransformFactory<ScriptTransform, ScriptTransform.Result, ExecutableScriptTransform> {
    private final ScriptService scriptService;

    public ScriptTransformFactory(ScriptService scriptService) {
        super(LogManager.getLogger(ExecutableScriptTransform.class));
        this.scriptService = scriptService;
    }

    public String type() {
        return "script";
    }

    public ScriptTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return ScriptTransform.parse(watchId, parser);
    }

    public ExecutableScriptTransform createExecutable(ScriptTransform transform) {
        return new ExecutableScriptTransform(transform, this.transformLogger, this.scriptService);
    }
}

