/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.Group;

public class TouchPoint {
    private int _id;
    private Location _location;
    private int _state;
    private boolean _changed;
    private long _time;
    private Group _group;

    public boolean isClaimed() {
        return this._group != null;
    }

    public TouchPoint(int id, Location location, long time) {
        this._id = id;
        this._location = location;
        this._time = time;
        this._state = 0;
    }

    public TouchPoint(TouchPoint tp) {
        this._id = tp._id;
        this._location = tp._location;
        this._state = tp._state;
        this._time = tp._time;
    }

    public long getTime() {
        return this._time;
    }

    public int getID() {
        return this._id;
    }

    public Location getLocation() {
        return this._location;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int state) {
        this._state = state;
    }

    public void setGroup(Group group) {
        this._group = group;
        this._group.update(this);
    }

    public void update(Location location, long time, int state) {
        this._location = location;
        this._state = state;
        this._changed = true;
        this._time = time;
        if (this._group != null) {
            this._group.update(this);
        }
    }

    public void resetChanged() {
        this._changed = false;
    }

    public boolean isChanged() {
        return this._changed;
    }

    public Object clone() {
        return new TouchPoint(this);
    }

    public boolean isNear(TouchPoint tp) {
        return (double)Math.abs(this._location.getX() - tp._location.getX()) < 0.005 && (double)Math.abs(this._location.getY() - tp._location.getY()) < 0.005;
    }
}

