/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ReadLocalPluginInformationTask
extends PleaseWaitRunnable {
    private final Map<String, PluginInformation> availablePlugins = new HashMap<String, PluginInformation>();
    private boolean canceled;

    public ReadLocalPluginInformationTask() {
        super(I18n.tr("Reading local plugin information..", new Object[0]), false);
    }

    public ReadLocalPluginInformationTask(ProgressMonitor monitor) {
        super(I18n.tr("Reading local plugin information..", new Object[0]), monitor, false);
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
    }

    protected void processJarFile(File f, String pluginName) throws PluginException {
        PluginInformation info = new PluginInformation(f, pluginName);
        if (!this.availablePlugins.containsKey(info.getName())) {
            info.updateLocalInfo(info);
            this.availablePlugins.put(info.getName(), info);
        } else {
            PluginInformation current = this.availablePlugins.get(info.getName());
            current.updateFromJar(info);
        }
    }

    private static File[] listFiles(File pluginsDirectory, String regex) {
        return pluginsDirectory.listFiles((dir, name) -> name.matches(regex));
    }

    protected void scanSiteCacheFiles(ProgressMonitor monitor, File pluginsDirectory) {
        File[] siteCacheFiles = ReadLocalPluginInformationTask.listFiles(pluginsDirectory, "^([0-9]+-)?site.*\\.txt$");
        if (siteCacheFiles == null || siteCacheFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr("Processing plugin site cache files...", new Object[0]));
        monitor.setTicksCount(siteCacheFiles.length);
        for (File f : siteCacheFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr("Processing file ''{0}''", fname));
            try {
                this.processLocalPluginInformationFile(f);
            }
            catch (PluginListParseException e) {
                Logging.warn(I18n.tr("Failed to scan file ''{0}'' for plugin information. Skipping.", fname));
                Logging.error(e);
            }
            monitor.worked(1);
        }
    }

    protected void scanPluginFiles(ProgressMonitor monitor, File pluginsDirectory) {
        File[] pluginFiles = pluginsDirectory.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".jar.new"));
        if (pluginFiles == null || pluginFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr("Processing plugin files...", new Object[0]));
        monitor.setTicksCount(pluginFiles.length);
        for (File f : pluginFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr("Processing file ''{0}''", fname));
            try {
                String pluginName;
                if (fname.endsWith(".jar")) {
                    pluginName = fname.substring(0, fname.length() - 4);
                    this.processJarFile(f, pluginName);
                } else if (fname.endsWith(".jar.new")) {
                    pluginName = fname.substring(0, fname.length() - 8);
                    this.processJarFile(f, pluginName);
                }
            }
            catch (PluginException e) {
                Logging.log(Logging.LEVEL_WARN, "PluginException: ", e);
                Logging.warn(I18n.tr("Failed to scan file ''{0}'' for plugin information. Skipping.", fname));
            }
            monitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanLocalPluginRepository(ProgressMonitor progressMonitor, File pluginsDirectory) {
        if (pluginsDirectory == null) {
            return;
        }
        ProgressMonitor monitor = progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE;
        try {
            monitor.beginTask("");
            try {
                this.scanSiteCacheFiles(monitor, pluginsDirectory);
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to scan site cache files", e);
            }
            try {
                this.scanPluginFiles(monitor, pluginsDirectory);
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to scan plugin files", e);
            }
        }
        finally {
            monitor.setCustomText("");
            monitor.finishTask();
        }
    }

    protected void processLocalPluginInformationFile(File file) throws PluginListParseException {
        try (InputStream fin = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            List<PluginInformation> pis = new PluginListParser().parse(fin);
            for (PluginInformation pi : pis) {
                this.availablePlugins.put(pi.name, pi);
            }
        }
        catch (IOException | InvalidPathException e) {
            throw new PluginListParseException(e);
        }
    }

    protected void analyseInProcessPlugins() {
        for (PluginProxy proxy : PluginHandler.pluginList) {
            PluginInformation info = proxy.getPluginInformation();
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(info.name)) {
                this.availablePlugins.put(info.name, info);
                continue;
            }
            this.availablePlugins.get((Object)info.name).localversion = info.localversion;
        }
    }

    protected void filterOldPlugins() {
        for (PluginHandler.DeprecatedPlugin p : PluginHandler.DEPRECATED_PLUGINS) {
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(p.name)) continue;
            this.availablePlugins.remove(p.name);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Collection<String> pluginLocations = PluginInformation.getPluginLocations();
        this.getProgressMonitor().setTicksCount(pluginLocations.size() + 2);
        if (this.canceled) {
            return;
        }
        for (String location : pluginLocations) {
            this.scanLocalPluginRepository(this.getProgressMonitor().createSubTaskMonitor(1, false), new File(location));
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        this.analyseInProcessPlugins();
        this.getProgressMonitor().worked(1);
        if (this.canceled) {
            return;
        }
        this.filterOldPlugins();
        this.getProgressMonitor().worked(1);
    }

    public List<PluginInformation> getAvailablePlugins() {
        return new ArrayList<PluginInformation>(this.availablePlugins.values());
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

