/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanOptional;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.FixedProxyException;
import Ice.Identity;
import Ice.IntOptional;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.ObjectPrxHelperBase;
import Ice.OutputStream;
import Ice.ProtocolVersion;
import Ice.RouterPrx;
import IceInternal.BatchRequestQueue;
import IceInternal.ConnectionRequestHandler;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.QueueRequestHandler;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import java.util.Map;

public class FixedReference
extends Reference {
    private ConnectionI _fixedConnection;
    private static EndpointI[] _emptyEndpoints = new EndpointI[0];

    public FixedReference(Instance instance, Communicator communicator, Identity identity, String facet, int mode, boolean secure, ProtocolVersion protocol, EncodingVersion encoding, ConnectionI connection, int invocationTimeout, Map<String, String> context, BooleanOptional compress) {
        super(instance, communicator, identity, facet, mode, secure, protocol, encoding, invocationTimeout, context);
        this._fixedConnection = connection;
        if (compress.isSet()) {
            this._overrideCompress = true;
            this._compress = compress.get();
        }
    }

    @Override
    public EndpointI[] getEndpoints() {
        return _emptyEndpoints;
    }

    @Override
    public String getAdapterId() {
        return "";
    }

    @Override
    public LocatorInfo getLocatorInfo() {
        return null;
    }

    @Override
    public RouterInfo getRouterInfo() {
        return null;
    }

    @Override
    public boolean getCollocationOptimized() {
        return false;
    }

    @Override
    public final boolean getCacheConnection() {
        return true;
    }

    @Override
    public boolean getPreferSecure() {
        return false;
    }

    @Override
    public final EndpointSelectionType getEndpointSelection() {
        return EndpointSelectionType.Random;
    }

    @Override
    public int getLocatorCacheTimeout() {
        return 0;
    }

    @Override
    public String getConnectionId() {
        return "";
    }

    @Override
    public IntOptional getTimeout() {
        return new IntOptional();
    }

    @Override
    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeAdapterId(String newAdapterId) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocator(LocatorPrx newLocator) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeRouter(RouterPrx newRouter) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeCollocationOptimized(boolean newCollocationOptimized) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeCacheConnection(boolean newCache) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changePreferSecure(boolean prefSec) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeEndpointSelection(EndpointSelectionType newType) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocatorCacheTimeout(int newTimeout) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeTimeout(int newTimeout) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeConnectionId(String connectionId) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeConnection(ConnectionI connection) {
        if (this._fixedConnection == connection) {
            return this;
        }
        FixedReference r = (FixedReference)this.getInstance().referenceFactory().copy(this);
        r._fixedConnection = connection;
        return r;
    }

    @Override
    public boolean isIndirect() {
        return false;
    }

    @Override
    public boolean isWellKnown() {
        return false;
    }

    @Override
    public void streamWrite(OutputStream s) throws MarshalException {
        throw new FixedProxyException();
    }

    @Override
    public Map<String, String> toProperty(String prefix) {
        throw new FixedProxyException();
    }

    @Override
    public RequestHandler getRequestHandler(ObjectPrxHelperBase proxy) {
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException(this.toString());
            }
            case 3: 
            case 4: {
                if (this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException(this.toString());
            }
        }
        DefaultsAndOverrides defaultsAndOverrides = this.getInstance().defaultsAndOverrides();
        boolean secure = defaultsAndOverrides.overrideSecure ? defaultsAndOverrides.overrideSecureValue : this.getSecure();
        if (secure && !this._fixedConnection.endpoint().secure()) {
            throw new NoEndpointException(this.toString());
        }
        this._fixedConnection.throwException();
        boolean compress = false;
        if (defaultsAndOverrides.overrideCompress) {
            compress = defaultsAndOverrides.overrideCompressValue;
        } else if (this._overrideCompress) {
            compress = this._compress;
        }
        RequestHandler handler = new ConnectionRequestHandler(this, this._fixedConnection, compress);
        if (this.getInstance().queueRequests()) {
            handler = new QueueRequestHandler(this.getInstance(), handler);
        }
        return proxy._setRequestHandler(handler);
    }

    @Override
    public BatchRequestQueue getBatchRequestQueue() {
        return this._fixedConnection.getBatchRequestQueue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedReference)) {
            return false;
        }
        FixedReference rhs = (FixedReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return this._fixedConnection.equals(rhs._fixedConnection);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

