/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import javajs.util.DF;
import javajs.util.PT;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Integral;
import jspecview.common.Measurement;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.source.JDXHeader;
import org.jmol.util.Logger;

public abstract class JDXDataObject
extends JDXHeader {
    public static final double ERROR = Double.MAX_VALUE;
    private String filePath;
    protected String filePathForwardSlash;
    public boolean isSimulation;
    public String sourceID = "";
    protected double blockID;
    public double fileFirstX = Double.MAX_VALUE;
    public double fileLastX = Double.MAX_VALUE;
    public int nPointsFile = -1;
    public double xFactor = Double.MAX_VALUE;
    public double yFactor = Double.MAX_VALUE;
    public String varName = "";
    protected String xUnits = "";
    protected String yUnits = "";
    protected String xLabel = null;
    protected String yLabel = null;
    public int nH;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_TOP = 1;
    public static final int SCALE_BOTTOM = 2;
    public static final int SCALE_TOP_BOTTOM = 3;
    public String observedNucl = "";
    public double observedFreq = Double.MAX_VALUE;
    protected Spectrum parent;
    public double offset = Double.MAX_VALUE;
    public int shiftRefType = -1;
    public int dataPointNum = -1;
    public int numDim = 1;
    public String nucleusX;
    public String nucleusY = "?";
    public double freq2dX = Double.NaN;
    public double freq2dY = Double.NaN;
    private double y2D = Double.NaN;
    public String y2DUnits = "";
    private static final double[] gyroData = new double[]{1.0, 42.5774806, 2.0, 6.53590131, 3.0, 45.4148, 3.0, 32.436, 6.0, 6.2661, 7.0, 16.5483, 9.0, 5.9842, 10.0, 4.5752, 11.0, 13.663, 13.0, 10.70839657, 14.0, 3.07770646, 15.0, 4.3172657, 17.0, 5.7742, 19.0, 40.07757016, 21.0, 3.3631, 23.0, 11.26952167, 25.0, 2.6083, 27.0, 11.1031, 29.0, 8.4655, 31.0, 17.2514409, 33.0, 3.2717, 35.0, 4.1765, 37.0, 3.4765, 37.0, 5.819, 39.0, 3.46, 39.0, 1.9893, 40.0, 2.4737, 41.0, 1.0919, 43.0, 2.8688, 45.0, 10.3591, 47.0, 2.4041, 49.0, 2.4048, 50.0, 4.2505, 51.0, 11.2133, 53.0, 2.4115, 55.0, 10.5763, 57.0, 1.3816, 59.0, 10.077, 61.0, 3.8114, 63.0, 11.2982, 65.0, 12.103, 67.0, 2.6694, 69.0, 10.2478, 71.0, 13.0208, 73.0, 1.4897, 75.0, 7.315, 77.0, 8.1571, 79.0, 10.7042, 81.0, 11.5384, 83.0, 1.6442, 85.0, 4.1254, 87.0, 13.9811, 87.0, 1.8525, 89.0, 2.0949, 91.0, 3.9748, 93.0, 10.4523, 95.0, 2.7874, 97.0, 2.8463, 99.0, 9.6294, 99.0, 1.9553, 101.0, 2.1916, 103.0, 1.3477, 105.0, 1.957, 107.0, 1.7331, 109.0, 1.9924, 111.0, 9.0692, 113.0, 9.4871, 113.0, 9.3655, 115.0, 9.3856, 115.0, 14.0077, 117.0, 15.261, 119.0, 15.966, 121.0, 10.2551, 123.0, 5.5532, 123.0, 11.2349, 125.0, 13.5454, 127.0, 8.5778, 129.0, 11.8604, 131.0, 3.5159, 133.0, 5.6234, 135.0, 4.2582, 137.0, 4.7634, 138.0, 5.6615, 139.0, 6.0612, 137.0, 4.88, 139.0, 5.39, 141.0, 2.37, 141.0, 13.0359, 143.0, 2.319, 145.0, 1.429, 143.0, 11.59, 147.0, 5.62, 147.0, 1.7748, 149.0, 14631.0, 151.0, 10.5856, 153.0, 4.6745, 155.0, 1.312, 157.0, 1.72, 159.0, 10.23, 161.0, 1.4654, 163.0, 2.0508, 165.0, 9.0883, 167.0, 1.2281, 169.0, 3.531, 171.0, 7.5261, 173.0, 2.073, 175.0, 4.8626, 176.0, 3.451, 177.0, 1.7282, 179.0, 1.0856, 180.0, 4.087, 181.0, 5.1627, 183.0, 1.7957, 185.0, 9.7176, 187.0, 9.817, 187.0, 0.9856, 189.0, 3.3536, 191.0, 0.7658, 191.0, 0.8319, 195.0, 9.2922, 197.0, 0.7406, 199.0, 7.7123, 201.0, 2.8469, 203.0, 24.7316, 205.0, 24.9749, 207.0, 9.034, 209.0, 6.963, 209.0, 11.7, 211.0, 9.16, 223.0, 5.95, 223.0, 1.3746, 225.0, 11.187, 227.0, 5.6, 229.0, 1.4, 231.0, 10.2, 235.0, 0.83, 237.0, 9.57, 239.0, 3.09, 243.0, 4.6, 1.0E100};
    protected boolean isHZtoPPM = false;
    private boolean xIncreases = true;
    private boolean continuous;
    public Coordinate[] xyCoords;
    private double minX = Double.NaN;
    private double minY = Double.NaN;
    private double maxX = Double.NaN;
    private double maxY = Double.NaN;
    private double deltaX = Double.NaN;
    double normalizationFactor = 1.0;

    public void setFilePath(String string) {
        if (string != null) {
            this.filePath = string.trim();
            this.filePathForwardSlash = this.filePath.replace('\\', '/');
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFilePathForwardSlash() {
        return this.filePathForwardSlash;
    }

    public void setBlockID(double d) {
        this.blockID = d;
    }

    public boolean isImaginary() {
        return this.varName.contains("IMAG");
    }

    public void setXFactor(double d) {
        this.xFactor = d;
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public void setYFactor(double d) {
        this.yFactor = d;
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public void checkRequiredTokens() throws JSVException {
        String string;
        String string2 = this.fileFirstX == Double.MAX_VALUE ? "##FIRSTX" : (this.fileLastX == Double.MAX_VALUE ? "##LASTX" : (this.nPointsFile == -1 ? "##NPOINTS" : (this.xFactor == Double.MAX_VALUE ? "##XFACTOR" : (string = this.yFactor == Double.MAX_VALUE ? "##YFACTOR" : null))));
        if (string != null) {
            throw new JSVException("Error Reading Data Set: " + string + " not found");
        }
    }

    public void setXUnits(String string) {
        this.xUnits = string;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public void setYUnits(String string) {
        if (string.equals("PPM")) {
            string = "ARBITRARY UNITS";
        }
        this.yUnits = string;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void setObservedNucleus(String string) {
        this.observedNucl = string;
        if (this.numDim == 1) {
            this.parent.nucleusX = this.nucleusX = this.fixNucleus(string);
        }
    }

    public void setObservedFreq(double d) {
        this.observedFreq = d;
    }

    public double getObservedFreq() {
        return this.observedFreq;
    }

    public boolean is1D() {
        return this.numDim == 1;
    }

    public void setY2D(double d) {
        this.y2D = d;
    }

    public double getY2D() {
        return this.y2D;
    }

    public void setY2DUnits(String string) {
        this.y2DUnits = string;
    }

    public double getY2DPPM() {
        double d = this.y2D;
        if (this.y2DUnits.equals("HZ")) {
            d /= this.freq2dY;
        }
        return d;
    }

    public void setNucleusAndFreq(String string, boolean bl) {
        double d;
        string = this.fixNucleus(string);
        if (bl) {
            this.nucleusX = string;
        } else {
            this.nucleusY = string;
        }
        if (this.observedNucl.indexOf(string) >= 0) {
            d = this.observedFreq;
        } else {
            double d2 = JDXDataObject.getGyroMagneticRatio(this.observedNucl);
            double d3 = JDXDataObject.getGyroMagneticRatio(string);
            d = this.observedFreq * d3 / d2;
        }
        if (bl) {
            this.freq2dX = d;
        } else {
            this.freq2dY = d;
        }
        Logger.info("Freq for " + string + " = " + d);
    }

    private String fixNucleus(String string) {
        return PT.rep(PT.trim(string, "[]^<>"), "NUC_", "");
    }

    private static double getGyroMagneticRatio(String string) {
        int n = 0;
        while (n < string.length() && !Character.isDigit(string.charAt(n))) {
            ++n;
        }
        n = PT.parseInt(string.substring(n));
        int n2 = 0;
        while (n2 < gyroData.length) {
            if (gyroData[n2] >= (double)n) break;
            n2 += 2;
        }
        return gyroData[n2] == (double)n ? gyroData[n2 + 1] : Double.NaN;
    }

    public boolean isTransmittance() {
        String string = this.yUnits.toLowerCase();
        return string.equals("transmittance") || string.contains("trans") || string.equals("t");
    }

    public boolean isAbsorbance() {
        String string = this.yUnits.toLowerCase();
        return string.equals("absorbance") || string.contains("abs") || string.equals("a");
    }

    public boolean canSaveAsJDX() {
        return this.getDataClass().equals("XYDATA");
    }

    public boolean canIntegrate() {
        return this.continuous && (this.isHNMR() || this.isGC()) && this.is1D();
    }

    public boolean isAutoOverlayFromJmolClick() {
        return this.isGC();
    }

    public boolean isGC() {
        return this.dataType.startsWith("GC") || this.dataType.startsWith("GAS");
    }

    public boolean isMS() {
        return this.dataType.startsWith("MASS") || this.dataType.startsWith("MS");
    }

    public boolean isStackable() {
        return !this.isMS();
    }

    public boolean isScalable() {
        return true;
    }

    public double getYRef() {
        return !this.isTransmittance() ? 0.0 : (Coordinate.getMaxY(this.xyCoords, 0, this.xyCoords.length) < 2.0 ? 1.0 : 100.0);
    }

    public boolean isInverted() {
        return this.isTransmittance();
    }

    public boolean canConvertTransAbs() {
        return this.continuous && this.yUnits.toLowerCase().contains("abs") || this.yUnits.toLowerCase().contains("trans");
    }

    public boolean canShowSolutionColor() {
        return this.isContinuous() && this.canConvertTransAbs() && (this.xUnits.toLowerCase().contains("nanometer") || this.xUnits.equalsIgnoreCase("nm")) && this.getFirstX() < 401.0 && this.getLastX() > 699.0 && this.xyCoords.length >= 30;
    }

    public boolean isHZtoPPM() {
        return this.isHZtoPPM;
    }

    public void setHZtoPPM(boolean bl) {
        this.isHZtoPPM = bl;
    }

    public void setIncreasing(boolean bl) {
        this.xIncreases = bl;
    }

    public boolean isXIncreasing() {
        return this.xIncreases;
    }

    public boolean shouldDisplayXAxisIncreasing() {
        String string = this.dataType.toUpperCase();
        String string2 = this.xUnits.toUpperCase();
        if (string.contains("NMR") && !string.contains("FID")) {
            return false;
        }
        if (string.contains("LINK") && string2.contains("CM")) {
            return false;
        }
        if (string.startsWith("IR") || string.contains("INFRA") && string2.contains("CM")) {
            return false;
        }
        if (string.contains("RAMAN") && string2.contains("CM")) {
            return false;
        }
        if (string.contains("VIS") && string2.contains("NANOMETERS")) {
            return true;
        }
        return this.xIncreases;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public String[][] getHeaderRowDataAsArray() {
        int n = 8;
        if (this.observedFreq != Double.MAX_VALUE) {
            ++n;
        }
        if (this.observedNucl != "") {
            ++n;
        }
        String[][] stringArray = this.getHeaderRowDataAsArray(true, n);
        int n2 = stringArray.length - n;
        if (this.observedFreq != Double.MAX_VALUE) {
            stringArray[n2++] = new String[]{"##.OBSERVE FREQUENCY", "" + this.observedFreq};
        }
        if (this.observedNucl != "") {
            stringArray[n2++] = new String[]{"##.OBSERVE NUCLEUS", this.observedNucl};
        }
        stringArray[n2++] = new String[]{"##XUNITS", this.isHZtoPPM ? "HZ" : this.xUnits};
        stringArray[n2++] = new String[]{"##YUNITS", this.yUnits};
        double d = this.xIncreases ? this.getFirstX() : this.getLastX();
        stringArray[n2++] = new String[]{"##FIRSTX", String.valueOf(this.isHZtoPPM() ? d * this.observedFreq : d)};
        d = this.xIncreases ? this.getLastX() : this.getFirstX();
        stringArray[n2++] = new String[]{"##FIRSTY", String.valueOf(this.xIncreases ? this.getFirstY() : this.getLastY())};
        stringArray[n2++] = new String[]{"##LASTX", String.valueOf(this.isHZtoPPM() ? d * this.observedFreq : d)};
        stringArray[n2++] = new String[]{"##XFACTOR", String.valueOf(this.getXFactor())};
        stringArray[n2++] = new String[]{"##YFACTOR", String.valueOf(this.getYFactor())};
        stringArray[n2++] = new String[]{"##NPOINTS", String.valueOf(this.xyCoords.length)};
        return stringArray;
    }

    public int getDefaultUnitPrecision() {
        return 2;
    }

    public String setMeasurementText(Measurement measurement) {
        double d = measurement.getValue();
        if (Double.isNaN(d)) {
            return "";
        }
        int n = 1;
        String string = "";
        if (this.isNMR()) {
            if (this.numDim == 1) {
                boolean bl = measurement instanceof Integral;
                if (this.isHNMR() || bl) {
                    if (!bl) {
                        d *= this.observedFreq;
                        string = " Hz";
                    }
                } else {
                    string = " ppm";
                    n = 2;
                }
            } else {
                return "";
            }
        }
        return d < 0.1 ? "" : String.valueOf(DF.formatDecimalDbl(d, n)) + string;
    }

    public boolean isNMR() {
        return this.dataType.toUpperCase().indexOf("NMR") >= 0;
    }

    public boolean isHNMR() {
        return this.isNMR() && this.observedNucl.toUpperCase().indexOf("H") >= 0;
    }

    public void setXYCoords(Coordinate[] coordinateArray) {
        this.xyCoords = coordinateArray;
    }

    public JDXDataObject invertYAxis() {
        int n = this.xyCoords.length;
        while (--n >= 0) {
            this.xyCoords[n].setYVal(-this.xyCoords[n].getYVal());
        }
        double d = this.minY;
        this.minY = -this.maxY;
        this.maxY = -d;
        return this;
    }

    public double getFirstX() {
        return this.xyCoords[0].getXVal();
    }

    public double getFirstY() {
        return this.xyCoords[0].getYVal();
    }

    public double getLastX() {
        return this.xyCoords[this.xyCoords.length - 1].getXVal();
    }

    public double getLastY() {
        return this.xyCoords[this.xyCoords.length - 1].getYVal();
    }

    public double getMinX() {
        return Double.isNaN(this.minX) ? (this.minX = Coordinate.getMinX(this.xyCoords, 0, this.xyCoords.length)) : this.minX;
    }

    public double getMinY() {
        return Double.isNaN(this.minY) ? (this.minY = Coordinate.getMinY(this.xyCoords, 0, this.xyCoords.length)) : this.minY;
    }

    public double getMaxX() {
        return Double.isNaN(this.maxX) ? (this.maxX = Coordinate.getMaxX(this.xyCoords, 0, this.xyCoords.length)) : this.maxX;
    }

    public double getMaxY() {
        return Double.isNaN(this.maxY) ? (this.maxY = Coordinate.getMaxY(this.xyCoords, 0, this.xyCoords.length)) : this.maxY;
    }

    public void doNormalize(double d) {
        if (!this.isNMR() || !this.is1D()) {
            return;
        }
        this.normalizationFactor = d / this.getMaxY();
        this.maxY = Double.NaN;
        Coordinate.applyScale(this.xyCoords, 1.0, this.normalizationFactor);
        Logger.info("Y values have been scaled by a factor of " + this.normalizationFactor);
    }

    public double getDeltaX() {
        return Double.isNaN(this.deltaX) ? (this.deltaX = Coordinate.deltaX(this.getLastX(), this.getFirstX(), this.xyCoords.length)) : this.deltaX;
    }

    public void copyTo(JDXDataObject jDXDataObject) {
        jDXDataObject.setTitle(this.title);
        jDXDataObject.setJcampdx(this.jcampdx);
        jDXDataObject.setOrigin(this.origin);
        jDXDataObject.setOwner(this.owner);
        jDXDataObject.setDataClass(this.dataClass);
        jDXDataObject.setDataType(this.dataType);
        jDXDataObject.setHeaderTable(this.headerTable);
        jDXDataObject.setXFactor(this.xFactor);
        jDXDataObject.setYFactor(this.yFactor);
        jDXDataObject.setXUnits(this.xUnits);
        jDXDataObject.setYUnits(this.yUnits);
        jDXDataObject.setXLabel(this.xLabel);
        jDXDataObject.setYLabel(this.yLabel);
        jDXDataObject.setXYCoords(this.xyCoords);
        jDXDataObject.setContinuous(this.continuous);
        jDXDataObject.setIncreasing(this.xIncreases);
        jDXDataObject.observedFreq = this.observedFreq;
        jDXDataObject.observedNucl = this.observedNucl;
        jDXDataObject.offset = this.offset;
        jDXDataObject.dataPointNum = this.dataPointNum;
        jDXDataObject.shiftRefType = this.shiftRefType;
        jDXDataObject.isHZtoPPM = this.isHZtoPPM;
        jDXDataObject.numDim = this.numDim;
        jDXDataObject.nucleusX = this.nucleusX;
        jDXDataObject.nucleusY = this.nucleusY;
        jDXDataObject.freq2dX = this.freq2dX;
        jDXDataObject.freq2dY = this.freq2dY;
        jDXDataObject.setFilePath(this.filePath);
        jDXDataObject.nH = this.nH;
    }

    public String getTypeLabel() {
        return this.isNMR() ? String.valueOf(this.nucleusX) + "NMR" : this.dataType;
    }

    public Object[] getDefaultAnnotationInfo(Annotation.AType aType) {
        boolean bl = this.isNMR();
        switch (aType) {
            case Integration: {
                Object[] objectArray = new Object[3];
                objectArray[1] = new int[]{1};
                return objectArray;
            }
            case Measurements: {
                int[] nArray;
                String[] stringArray;
                if (bl) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Hz";
                    stringArray = stringArray2;
                    stringArray2[1] = "ppm";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "";
                }
                String[] stringArray4 = stringArray;
                if (this.isHNMR()) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 1;
                    nArray = nArray2;
                    nArray2[1] = 4;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 1;
                    nArray = nArray3;
                    nArray3[1] = 3;
                }
                int[] nArray4 = nArray;
                return new Object[]{stringArray4, nArray4, 0};
            }
            case PeakList: {
                int[] nArray;
                String[] stringArray;
                if (bl) {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "Hz";
                    stringArray = stringArray5;
                    stringArray5[1] = "ppm";
                } else {
                    String[] stringArray6 = new String[1];
                    stringArray = stringArray6;
                    stringArray6[0] = "";
                }
                String[] stringArray7 = stringArray;
                if (this.isHNMR()) {
                    int[] nArray5 = new int[2];
                    nArray5[0] = 1;
                    nArray = nArray5;
                    nArray5[1] = 2;
                } else {
                    int[] nArray6 = new int[2];
                    nArray6[0] = 1;
                    nArray = nArray6;
                    nArray6[1] = 1;
                }
                int[] nArray7 = nArray;
                return new Object[]{stringArray7, nArray7, bl ? 1 : 0};
            }
            case OverlayLegend: 
            case NONE: {
                break;
            }
        }
        return null;
    }

    public double[] getPeakListArray(Measurement measurement, double[] dArray, double d) {
        double d2 = measurement.getXVal();
        double d3 = measurement.getYVal();
        if (this.isNMR()) {
            d3 /= d;
        }
        double d4 = Math.abs(d2 - dArray[0]);
        dArray[0] = d2;
        double d5 = d4 + dArray[1];
        dArray[1] = d4;
        double d6 = d5 + dArray[2];
        dArray[2] = d5;
        if (this.isNMR()) {
            return new double[]{d2, d3, d2 * this.observedFreq, d4 * this.observedFreq > 20.0 ? 0.0 : d4 * this.observedFreq, d5 * this.observedFreq > 20.0 ? 0.0 : d5 * this.observedFreq, d6 * this.observedFreq > 20.0 ? 0.0 : d6 * this.observedFreq};
        }
        return new double[]{d2, d3};
    }
}

