/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;

public abstract class BondCollection
extends AtomCollection {
    public Bond[] bo;
    public int bondCount;
    protected int[] numCached;
    protected Bond[][][] freeBonds;
    protected JmolMolecule[] molecules;
    protected int moleculeCount;
    protected short defaultCovalentMad;
    private BS bsAromaticSingle;
    private BS bsAromaticDouble;
    protected BS bsAromatic;
    public boolean haveHiddenBonds;
    protected static final int BOND_GROWTH_INCREMENT = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;

    protected void setupBC() {
        this.bsAromatic = new BS();
        this.numCached = new int[5];
        this.freeBonds = new Bond[5][][];
        int n = 5;
        while (--n > 0) {
            this.freeBonds[n] = new Bond[200][];
        }
        this.setupAC();
    }

    protected void releaseModelSetBC() {
        this.bo = null;
        this.freeBonds = null;
        this.releaseModelSetAC();
    }

    public BondIterator getBondIteratorForType(int n, BS bS) {
        return new BondIteratorSelected(this.bo, this.bondCount, n, bS, this.vwr.getBoolean(0x24000024));
    }

    public BondIterator getBondIterator(BS bS) {
        return new BondIteratorSelected(this.bo, this.bondCount, 131071, bS, false);
    }

    public short getBondColix1(int n) {
        return C.getColixInherited(this.bo[n].colix, this.bo[n].atom1.colixAtom);
    }

    public short getBondColix2(int n) {
        return C.getColixInherited(this.bo[n].colix, this.bo[n].atom2.colixAtom);
    }

    protected int getBondCountInModel(int n) {
        int n2 = 0;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (this.bo[n3].atom1.mi != n) continue;
            ++n2;
        }
        return n2;
    }

    public BS getBondsForSelectedAtoms(BS bS, boolean bl) {
        BS bS2 = new BS();
        int n = 0;
        while (n < this.bondCount) {
            Bond bond = this.bo[n];
            boolean bl2 = bS.get(bond.atom1.i);
            boolean bl3 = bS.get(bond.atom2.i);
            if (bl ? bl2 || bl3 : bl2 && bl3) {
                bS2.set(n);
            }
            ++n;
        }
        return bS2;
    }

    public Bond bondAtoms(Atom atom, Atom atom2, int n, short s, BS bS, float f, boolean bl, boolean bl2) {
        Bond bond = this.getOrAddBond(atom, atom2, n, s, bS, f, true);
        if (bl2) {
            bond.order |= 0x20000;
            if (bl) {
                atom.group = atom2.group;
                atom.group.addAtoms(atom.i);
            }
        }
        return bond;
    }

    protected Bond getOrAddBond(Atom atom, Atom atom2, int n, short s, BS bS, float f, boolean bl) {
        int n2;
        if (n == 131071 || n == 65535) {
            n = 1;
        }
        if (atom.isBonded(atom2)) {
            n2 = atom.getBond((Atom)atom2).index;
            if (bl) {
                this.bo[n2].setOrder(n);
                this.bo[n2].setMad(s);
                if (this.bo[n2] instanceof HBond) {
                    ((HBond)this.bo[n2]).energy = f;
                }
            }
        } else {
            if (this.bondCount == this.bo.length) {
                this.bo = (Bond[])AU.arrayCopyObject(this.bo, this.bondCount + 250);
            }
            n2 = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)s, (float)f)).index;
        }
        if (bS != null) {
            bS.set(n2);
        }
        return this.bo[n2];
    }

    protected Bond setBond(int n, Bond bond) {
        bond.index = n;
        this.bo[bond.index] = bond;
        return this.bo[bond.index];
    }

    protected Bond bondMutually(Atom atom, Atom atom2, int n, short s, float f) {
        Bond bond = Edge.isOrderH(n) ? new HBond(atom, atom2, n, s, 0, f) : new Bond(atom, atom2, n, s, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atom2, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond bond, Bond[] bondArray) {
        Bond[] bondArray2;
        if (bondArray == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                bondArray2 = this.freeBonds[1][this.numCached[1]];
            } else {
                bondArray2 = new Bond[]{bond};
            }
        } else {
            int n = bondArray.length;
            int n2 = n + 1;
            if (n2 < 5 && this.numCached[n2] > 0) {
                int n3 = n2;
                int n4 = this.numCached[n3] - 1;
                this.numCached[n3] = n4;
                bondArray2 = this.freeBonds[n2][n4];
            } else {
                bondArray2 = new Bond[n2];
            }
            bondArray2[n] = bond;
            int n5 = n;
            while (--n5 >= 0) {
                bondArray2[n5] = bondArray[n5];
            }
            if (n < 5 && this.numCached[n] < 200) {
                int n6 = n;
                int n7 = this.numCached[n6];
                this.numCached[n6] = n7 + 1;
                this.freeBonds[n][n7] = bondArray;
            }
        }
        return bondArray2;
    }

    public int addHBond(Atom atom, Atom atom2, int n, float f) {
        if (this.bondCount == this.bo.length) {
            this.bo = (Bond[])AU.arrayCopyObject(this.bo, this.bondCount + 250);
        }
        return this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)1, (float)f)).index;
    }

    protected void deleteAllBonds2() {
        this.vwr.setShapeProperty(1, "reset", null);
        int n = this.bondCount;
        while (--n >= 0) {
            this.bo[n].deleteAtomReferences();
            this.bo[n] = null;
        }
        this.bondCount = 0;
    }

    public short getDefaultMadFromOrder(int n) {
        return (short)(Edge.isOrderH(n) ? 1 : (n == 32768 ? (int)Math.floor(this.vwr.getFloat(570425406) * 2000.0f) : this.defaultCovalentMad));
    }

    protected int[] deleteConnections(float f, float f2, int n, BS bS, BS bS2, boolean bl, boolean bl2) {
        Object object;
        int n2;
        BS bS3;
        boolean bl3 = f < 0.0f;
        boolean bl4 = f2 < 0.0f;
        boolean bl5 = bl3 || bl4;
        f = this.fixD(f, bl3);
        f2 = this.fixD(f2, bl4);
        BS bS4 = new BS();
        int n3 = 0;
        int n4 = n |= 0x20000;
        if (!bl2 && Edge.isOrderH(n)) {
            n = 30720;
        }
        if (bl) {
            bS3 = bS;
        } else {
            bS3 = new BS();
            n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                object = this.at[n2];
                if (((Atom)object).bonds != null) {
                    int n5 = ((Atom)object).bonds.length;
                    while (--n5 >= 0) {
                        if (!bS2.get(((Atom)object).getBondedAtomIndex(n5))) continue;
                        bS3.set(((Atom)object).bonds[n5].index);
                    }
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        n2 = bS3.nextSetBit(0);
        while (n2 < this.bondCount && n2 >= 0) {
            object = this.bo[n2];
            if (this.isInRange(((Bond)object).atom1, ((Bond)object).atom2, f, f2, bl3, bl4, bl5) && (bl2 || n4 == (((Bond)object).order & 0xFFFFFEFF | 0x20000) || (n & ((Bond)object).order & 0x7800) != 0)) {
                bS4.set(n2);
                ++n3;
            }
            n2 = bS3.nextSetBit(n2 + 1);
        }
        if (n3 > 0) {
            this.dBm(bS4, false);
        }
        int[] nArray = new int[2];
        nArray[1] = n3;
        return nArray;
    }

    protected float fixD(float f, boolean bl) {
        return bl ? -f : f * f;
    }

    protected boolean isInRange(Atom atom, Atom atom2, float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        float f3 = atom.distanceSquared(atom2);
        if (bl3) {
            float f4 = (float)Math.sqrt(f3);
            float f5 = atom.getBondingRadius() + atom2.getBondingRadius();
            return (bl ? f4 >= f5 * f : f3 >= f) && (bl2 ? f4 <= f5 * f2 : f3 <= f2);
        }
        return f3 >= f && f3 <= f2;
    }

    protected void dBm(BS bS, boolean bl) {
        ((ModelSet)this).deleteBonds(bS, bl);
    }

    protected void dBb(BS bS, boolean bl) {
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return;
        }
        ((ModelSet)this).resetMolecules();
        short s = -1;
        int n2 = bS.cardinality();
        int n3 = n;
        while (n3 < this.bondCount) {
            Bond bond = this.bo[n3];
            if (n2 > 0 && bS.get(n3)) {
                short s2;
                --n2;
                if (!bl && (s2 = bond.atom1.mi) != s) {
                    s = s2;
                    ((ModelSet)this).am[s].resetBoundCount();
                }
                bond.deleteAtomReferences();
            } else {
                this.setBond(n++, bond);
            }
            ++n3;
        }
        n3 = this.bondCount;
        while (--n3 >= n) {
            this.bo[n3] = null;
        }
        this.bondCount = n;
        BS[] bSArray = (BS[])this.vwr.getShapeProperty(1, "sets");
        if (bSArray != null) {
            int n4 = 0;
            while (n4 < bSArray.length) {
                BSUtil.deleteBits(bSArray[n4], bS);
                ++n4;
            }
        }
        BSUtil.deleteBits(this.bsAromatic, bS);
    }

    public void resetAromatic() {
        int n = this.bondCount;
        while (--n >= 0) {
            Bond bond = this.bo[n];
            if (!bond.isAromatic()) continue;
            bond.setOrder(515);
        }
    }

    public void assignAromaticBondsBs(boolean bl, BS bS) {
        Object object;
        int n;
        if (!bl) {
            this.bsAromatic = new BS();
        }
        this.bsAromaticSingle = new BS();
        this.bsAromaticDouble = new BS();
        boolean bl2 = bS == null;
        int n2 = n = bl2 ? this.bondCount - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            object = this.bo[n2];
            if (this.bsAromatic.get(n2)) {
                ((Bond)object).setOrder(515);
            }
            switch (((Bond)object).order & 0xFFFDFFFF) {
                case 515: {
                    if (!this.assignAromaticMustBeSingle(((Bond)object).atom1) && !this.assignAromaticMustBeSingle(((Bond)object).atom2)) {
                        this.bsAromatic.set(n2);
                        break;
                    }
                    ((Bond)object).order = 513;
                }
                case 513: {
                    this.bsAromaticSingle.set(n2);
                    break;
                }
                case 514: {
                    this.bsAromaticDouble.set(n2);
                }
            }
            int n3 = n2 = bl2 ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        bl2 = bS == null;
        n = bl2 ? this.bondCount - 1 : bS.nextSetBit(0);
        object = new BS();
        int n4 = n;
        while (n4 >= 0) {
            Bond bond = this.bo[n4];
            if (bond.is(515) && !this.bsAromaticDouble.get(n4) && !this.bsAromaticSingle.get(n4)) {
                ((BS)object).set(n4);
                if (bond.atom1.getElementNumber() == 8 || bond.atom2.getElementNumber() == 8) {
                    if (!this.assignAromaticDouble(bond)) {
                        this.assignAromaticSingle(bond);
                    }
                } else {
                    ((BS)object).set(n4);
                }
            }
            int n5 = n4 = bl2 ? n4 - 1 : bS.nextSetBit(n4 + 1);
        }
        n4 = ((BS)object).nextSetBit(0);
        while (n4 >= 0) {
            Bond bond = this.bo[n4];
            if (!this.assignAromaticDouble(bond)) {
                this.assignAromaticSingle(bond);
            }
            n4 = ((BS)object).nextSetBit(n4 + 1);
        }
        BS bS2 = new BS();
        int n6 = n;
        while (n6 >= 0) {
            Bond bond = this.bo[n6];
            if (this.bsAromaticDouble.get(n6)) {
                if (!bond.is(514)) {
                    this.bsAromatic.set(n6);
                    bS2.set(bond.atom1.mi);
                    bond.setOrder(514);
                }
            } else if ((this.bsAromaticSingle.get(n6) || bond.isAromatic()) && !bond.is(513)) {
                this.bsAromatic.set(n6);
                bond.setOrder(513);
            }
            int n7 = n6 = bl2 ? n6 - 1 : bS.nextSetBit(n6 + 1);
        }
        Model[] modelArray = ((ModelSet)this).am;
        int n8 = bS2.nextSetBit(0);
        while (n8 >= 0) {
            if (modelArray[n8].isBioModel) {
                modelArray[n8].isPdbWithMultipleBonds = true;
            }
            n8 = bS2.nextSetBit(n8 + 1);
        }
        this.assignAromaticNandO(bS);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticSingle.get(n)) {
            return false;
        }
        if (this.bsAromaticDouble.get(n)) {
            return true;
        }
        this.bsAromaticDouble.set(n);
        if (!this.assignAromaticSingleForAtom(bond.atom1, n) || !this.assignAromaticSingleForAtom(bond.atom2, n)) {
            this.bsAromaticDouble.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticDouble.get(n)) {
            return false;
        }
        if (this.bsAromaticSingle.get(n)) {
            return true;
        }
        this.bsAromaticSingle.set(n);
        if (!this.assignAromaticDoubleForAtom(bond.atom1) || !this.assignAromaticDoubleForAtom(bond.atom2)) {
            this.bsAromaticSingle.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingleForAtom(Atom atom, int n) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return false;
        }
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (n3 == n || !bond.isAromatic() || this.bsAromaticSingle.get(n3) || !this.bsAromaticDouble.get(n3) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDoubleForAtom(Atom atom) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            if (this.bsAromaticDouble.get(bondArray[n2].index)) {
                bl = true;
            }
            if (!bondArray[n2].isAromatic()) continue;
            n = n2;
        }
        n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(n3) || this.bsAromaticSingle.get(n3)) continue;
            if (!bl && this.assignAromaticDouble(bond)) {
                bl = true;
                continue;
            }
            if (!bl && n2 >= n || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return bl;
    }

    protected boolean allowAromaticBond(Bond bond) {
        if (this.assignAromaticMustBeSingle(bond.atom1) || this.assignAromaticMustBeSingle(bond.atom2)) {
            return false;
        }
        switch (bond.getCovalentOrder()) {
            case 1: 
            case 2: {
                return bond.atom1.getCovalentBondCount() <= 3 && bond.atom2.getCovalentBondCount() <= 3;
            }
        }
        return false;
    }

    private boolean assignAromaticMustBeSingle(Atom atom) {
        int n = atom.getElementNumber();
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int n2 = atom.getValence();
        switch (n) {
            case 6: {
                return n2 == 4;
            }
            case 7: {
                return atom.group.getNitrogenAtom() == atom || n2 == 3 && atom.getFormalCharge() < 1;
            }
            case 8: {
                return atom.group.getCarbonylOxygenAtom() != atom && n2 == 2 && atom.getFormalCharge() < 1;
            }
            case 16: {
                return atom.group.groupID == 5 || n2 == 2 && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BS bS) {
        int n;
        boolean bl = bS == null;
        int n2 = n = bl ? this.bondCount - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            Bond bond = this.bo[n2];
            if (bond.is(513)) {
                int n3;
                Atom atom;
                int n4;
                Atom atom2 = bond.atom2;
                int n5 = atom2.getElementNumber();
                if (n5 == 7 || n5 == 8) {
                    n4 = n5;
                    atom = atom2;
                    atom2 = bond.atom1;
                    n5 = atom2.getElementNumber();
                } else {
                    atom = bond.atom1;
                    n4 = atom.getElementNumber();
                }
                if ((n4 == 7 || n4 == 8) && (n3 = atom.getValence()) >= 0) {
                    int n6 = atom.getCovalentBondCount();
                    int n7 = atom.getFormalCharge();
                    switch (n4) {
                        case 7: {
                            if (n3 != 3 || n6 != 3 || n7 >= 1 || n5 != 6 || atom2.getValence() != 3) break;
                            bond.setOrder(514);
                            break;
                        }
                        case 8: {
                            if (n3 != 1 || n7 != 0 || n5 != 14 && n5 != 16) break;
                            bond.setOrder(514);
                        }
                    }
                }
            }
            int n8 = n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
    }

    protected BS getAtomBitsMDb(int n, Object object) {
        BS bS = new BS();
        switch (n) {
            default: {
                return this.getAtomBitsMDa(n, object, bS);
            }
            case 1677721602: {
                BS bS2 = (BS)object;
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    bS.set(this.bo[n2].atom1.i);
                    bS.set(this.bo[n2].atom2.i);
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                return bS;
            }
            case 1073742331: 
        }
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (!this.bo[n3].isAromatic()) continue;
            bS.set(this.bo[n3].atom1.i);
            bS.set(this.bo[n3].atom2.i);
        }
        return bS;
    }

    public BS assignBond(int n, char c) {
        int n2 = c - 48;
        Bond bond = this.bo[n];
        ((ModelSet)this).clearDB(bond.atom1.i);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                break;
            }
            case 'm': 
            case 'p': {
                n2 = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (c == 'p' ? 1 : -1);
                if (n2 > 3) {
                    n2 = 1;
                    break;
                }
                if (n2 >= 0) break;
                n2 = 3;
                break;
            }
            default: {
                return null;
            }
        }
        BS bS = new BS();
        try {
            if (n2 == 0) {
                BS bS2 = new BS();
                bS2.set(bond.index);
                bS.set(bond.atom1.i);
                bS.set(bond.atom2.i);
                this.dBm(bS2, false);
                return bS;
            }
            bond.setOrder(n2 | 0x20000);
            if (bond.atom1.getElementNumber() != 1 && bond.atom2.getElementNumber() != 1) {
                this.removeUnnecessaryBonds(bond.atom1, false);
                this.removeUnnecessaryBonds(bond.atom2, false);
            }
            bS.set(bond.atom1.i);
            bS.set(bond.atom2.i);
        }
        catch (Exception exception) {
            Logger.error("Exception in seBondOrder: " + exception.toString());
        }
        return bS;
    }

    protected void removeUnnecessaryBonds(Atom atom, boolean bl) {
        BS bS = new BS();
        BS bS2 = new BS();
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return;
        }
        int n = 0;
        while (n < bondArray.length) {
            if (bondArray[n].isCovalent()) {
                Atom atom2 = bondArray[n].getOtherAtom(atom);
                if (atom2.getElementNumber() == 1) {
                    bS.set(bondArray[n].getOtherAtom((Atom)atom).i);
                }
            } else {
                bS2.set(bondArray[n].index);
            }
            ++n;
        }
        if (bS2.nextSetBit(0) >= 0) {
            this.dBm(bS2, false);
        }
        if (bl) {
            bS.set(atom.i);
        }
        if (bS.nextSetBit(0) >= 0) {
            this.vwr.deleteAtoms(bS, false);
        }
    }

    public void displayBonds(BondSet bondSet, boolean bl) {
        if (!bl) {
            this.haveHiddenBonds = true;
        }
        int n = bondSet.nextSetBit(0);
        while (n >= 0) {
            if (n < this.bondCount && this.bo[n].mad != 0) {
                this.bo[n].setShapeVisibility(bl);
            }
            n = bondSet.nextSetBit(n + 1);
        }
    }

    public BS getAtomsConnected(float f, float f2, int n, BS bS) {
        int n2;
        boolean bl = bS instanceof BondSet;
        BS bS2 = bl ? new BondSet() : new BS();
        int[] nArray = new int[this.ac];
        boolean bl2 = n == 30720;
        boolean bl3 = n == 65535;
        int n3 = 0;
        while (n3 < this.bondCount) {
            Bond bond = this.bo[n3];
            if (bl3 || bond.is(n) || bl2 && bond.isHydrogen()) {
                if (bl) {
                    bS2.set(n3);
                } else {
                    if (bS.get(bond.atom1.i)) {
                        n2 = bond.atom2.i;
                        nArray[n2] = nArray[n2] + 1;
                        bS2.set(n2);
                    }
                    if (bS.get(bond.atom2.i)) {
                        n2 = bond.atom1.i;
                        nArray[n2] = nArray[n2] + 1;
                        bS2.set(n2);
                    }
                }
            }
            ++n3;
        }
        if (bl) {
            return bS2;
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.ac;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bS2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bS2.set(n2);
        }
        return bS2;
    }
}

