##============================================================================
##  Copyright (c) Kitware, Inc.
##  All rights reserved.
##  See LICENSE.txt for details.
##  This software is distributed WITHOUT ANY WARRANTY; without even
##  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
##  PURPOSE.  See the above copyright notice for more information.
##
##  Copyright 2014 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
##  Copyright 2014 UT-Battelle, LLC.
##  Copyright 2014 Los Alamos National Security.
##
##  Under the terms of Contract DE-NA0003525 with NTESS,
##  the U.S. Government retains certain rights in this software.
##
##  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
##  Laboratory (LANL), the U.S. Government retains certain rights in
##  this software.
##============================================================================

# When this file is run by CMake through the find_package command, the
# following variables will be defined:
#
# VTKm_INCLUDE_DIRS - Directories containing VTK-m and dependent headers
# VTKm_LIBRARIES - The libraries required when using VTK-m
# VTKm_COMPILE_OPTIONS - Options VTK-m suggests to add to the compiler
#
# Note that the VTK-m package supports several components. It is important
# to request the components being used (as done through find_package arguments).
# If no components are requested, then the dependent packages will not be
# found and loaded. The following components are supported:
#
# Base Serial OpenGL OSMesa EGL GLFW GLUT Rendering TBB CUDA
#

cmake_minimum_required(VERSION 3.3 FATAL_ERROR)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was VTKmConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/vtk-8.1/vtkm" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################


# The VTKm version number
set(VTKm_VERSION_MAJOR "1")
set(VTKm_VERSION_MINOR "1")
set(VTKm_VERSION_PATCH "0")
set(VTKm_VERSION_FULL "1.1.0")
set(VTKm_VERSION "1.1")

# This is true when the package is still in the build directory (not installed)
if(CMAKE_CURRENT_LIST_DIR STREQUAL "/build/vtk/src/build/ThirdParty/vtkm/vtk-m/lib/cmake/vtk-8.1/vtkm")
  set(VTKm_PACKAGE_IN_BUILD TRUE)
endif()

if(VTKm_PACKAGE_IN_BUILD)
  set_and_check(VTKm_CMAKE_MODULE_PATH "/build/vtk/src/VTK-8.1.2/ThirdParty/vtkm/vtk-m/CMake")
  set_and_check(VTKm_INCLUDE_DIRS ${VTKm_INCLUDE_DIRS} "/build/vtk/src/VTK-8.1.2/ThirdParty/vtkm/vtk-m")
else()
  set_and_check(VTKm_CMAKE_MODULE_PATH "${PACKAGE_PREFIX_DIR}/lib/cmake/vtk-8.1/vtkm")
  set_and_check(VTKm_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/vtk")
endif()

set(VTKm_BUILD_SHARED_LIBS "ON")
set(VTKm_ENABLE_CUDA "OFF")
set(VTKm_ENABLE_TBB "OFF")
set(VTKm_ENABLE_OSMESA "OFF")
set(VTKm_ENABLE_RENDERING "OFF")

# Load the library exports, but only if not compiling VTK-m itself
set_and_check(VTKm_CONFIG_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/vtk-8.1/vtkm")
if(NOT "${CMAKE_BINARY_DIR}" STREQUAL "/build/vtk/src/build")
  include(${VTKm_CONFIG_DIR}/VTKmTargets.cmake)
endif()

# Clear out the libraries. We will add more when loading components.
set(VTKm_LIBRARIES)

# The VTKm variables used to configure components and packages silently.
set(VTKm_CONFIGURE_QUIET "${VTKm_FIND_QUIETLY}")
set(VTKm_FIND_PACKAGE_QUIETLY "")
if(VTKm_CONFIGURE_QUIET)
  set(VTKm_FIND_PACKAGE_QUIETLY "QUIET")
endif()

# VTKm requires some CMake Find modules not included with CMake, so
# include the CMake modules distributed with VTKm.
set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${VTKm_CMAKE_MODULE_PATH})

# This includes a host of macros used by VTK-m CMake.
include(VTKmMacros)

# Extra compile options that VTKm has generated, such as vectorization settings.
# This should be specified to any target with the CMake command target_compile_options
# that uses VTK-m.
set(VTKm_COMPILE_OPTIONS "")

# All projects using VTK-m should include the "Base" configuration (otherwise
# nothing may compile). Make sure the Base configuration is added to
# VTKm_FIND_COMPONENTS and the component is required.
set(VTKm_FIND_COMPONENTS "Base" ${VTKm_FIND_COMPONENTS})
set(VTKm_FIND_REQUIRED_Base TRUE)

# Load the selected components
# Clear out old FOUND flags
set(VTKm_Base_FOUND)
set(VTKm_Serial_FOUND)
set(VTKm_OpenGL_FOUND)
set(VTKm_OSMesa_FOUND)
set(VTKm_EGL_FOUND)
set(VTKm_GLFW_FOUND)
set(VTKm_GLUT_FOUND)
set(VTKm_Rendering_FOUND)
set(VTKm_TBB_FOUND)
set(VTKm_CUDA_FOUND)

# Load each component selected in find_package
foreach(comp ${VTKm_FIND_COMPONENTS})
  if("Base" STREQUAL ${comp})
    vtkm_configure_component_Base()
    if(VTKm_Base_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component Base")
    else()
      if(VTKm_FIND_REQUIRED_Base AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component Base")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component Base")
      endif()
    endif()
    continue()
  endif()
  if("Serial" STREQUAL ${comp})
    vtkm_configure_component_Serial()
    if(VTKm_Serial_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component Serial")
    else()
      if(VTKm_FIND_REQUIRED_Serial AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component Serial")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component Serial")
      endif()
    endif()
    continue()
  endif()
  if("OpenGL" STREQUAL ${comp})
    vtkm_configure_component_OpenGL()
    if(VTKm_OpenGL_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component OpenGL")
    else()
      if(VTKm_FIND_REQUIRED_OpenGL AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component OpenGL")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component OpenGL")
      endif()
    endif()
    continue()
  endif()
  if("OSMesa" STREQUAL ${comp})
    vtkm_configure_component_OSMesa()
    if(VTKm_OSMesa_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component OSMesa")
    else()
      if(VTKm_FIND_REQUIRED_OSMesa AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component OSMesa")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component OSMesa")
      endif()
    endif()
    continue()
  endif()
  if("EGL" STREQUAL ${comp})
    vtkm_configure_component_EGL()
    if(VTKm_EGL_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component EGL")
    else()
      if(VTKm_FIND_REQUIRED_EGL AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component EGL")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component EGL")
      endif()
    endif()
    continue()
  endif()
  if("GLFW" STREQUAL ${comp})
    vtkm_configure_component_GLFW()
    if(VTKm_GLFW_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component GLFW")
    else()
      if(VTKm_FIND_REQUIRED_GLFW AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component GLFW")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component GLFW")
      endif()
    endif()
    continue()
  endif()
  if("GLUT" STREQUAL ${comp})
    vtkm_configure_component_GLUT()
    if(VTKm_GLUT_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component GLUT")
    else()
      if(VTKm_FIND_REQUIRED_GLUT AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component GLUT")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component GLUT")
      endif()
    endif()
    continue()
  endif()
  if("Rendering" STREQUAL ${comp})
    vtkm_configure_component_Rendering()
    if(VTKm_Rendering_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component Rendering")
    else()
      if(VTKm_FIND_REQUIRED_Rendering AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component Rendering")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component Rendering")
      endif()
    endif()
    continue()
  endif()
  if("TBB" STREQUAL ${comp})
    vtkm_configure_component_TBB()
    if(VTKm_TBB_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component TBB")
    else()
      if(VTKm_FIND_REQUIRED_TBB AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component TBB")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component TBB")
      endif()
    endif()
    continue()
  endif()
  if("CUDA" STREQUAL ${comp})
    vtkm_configure_component_CUDA()
    if(VTKm_CUDA_FOUND AND NOT VTKm_CONFIGURE_QUIET)
      message(STATUS "Successfully loaded VTK-m component CUDA")
    else()
      if(VTKm_FIND_REQUIRED_CUDA AND NOT VTKm_CONFIGURE_QUIET)
        message("Could not load REQUIRED VTK-m component CUDA")
      elseif(NOT VTKm_CONFIGURE_QUIET)
        message(STATUS "Could not load optional VTK-m component CUDA")
      endif()
    endif()
    continue()
  endif()
  if(NOT VTKm_CONFIGURE_QUIET)
    message(WARNING "No such VTK-m component: ${comp}")
  endif()
endforeach()

check_required_components(VTKm)
