#ifndef _EFL_CANVAS_VG_NODE_EO_H_
#define _EFL_CANVAS_VG_NODE_EO_H_

#ifndef _EFL_CANVAS_VG_NODE_EO_CLASS_TYPE
#define _EFL_CANVAS_VG_NODE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Vg_Node;

#endif

#ifndef _EFL_CANVAS_VG_NODE_EO_TYPES
#define _EFL_CANVAS_VG_NODE_EO_TYPES


#endif
/** Efl vector graphics abstract class
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
#define EFL_CANVAS_VG_NODE_CLASS efl_canvas_vg_node_class_get()

EWAPI const Efl_Class *efl_canvas_vg_node_class_get(void);

/**
 * @brief Sets the transformation matrix to be used for this node object.
 *
 * @note Pass @c null to cancel the applied transformation.
 *
 * @param[in] obj The object.
 * @param[in] m Transformation matrix.
 *
 * @since 1.14
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI void efl_canvas_vg_node_transformation_set(Eo *obj, const Eina_Matrix3 *m);

/**
 * @brief Gets the transformation matrix used for this node object.
 *
 * @param[in] obj The object.
 *
 * @return Transformation matrix.
 *
 * @since 1.14
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI const Eina_Matrix3 *efl_canvas_vg_node_transformation_get(const Eo *obj);

/**
 * @brief Sets the origin position of the node object.
 *
 * This origin position affects node transformation.
 *
 * @param[in] obj The object.
 * @param[in] x @c origin x position.
 * @param[in] y @c origin y position.
 *
 * @since 1.14
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI void efl_canvas_vg_node_origin_set(Eo *obj, double x, double y);

/**
 * @brief Gets the origin position of the node object.
 *
 * @param[in] obj The object.
 * @param[out] x @c origin x position.
 * @param[out] y @c origin y position.
 *
 * @since 1.14
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI void efl_canvas_vg_node_origin_get(const Eo *obj, double *x, double *y);

/**
 * @brief Vector graphics object mask
 *
 * @param[in] obj The object.
 * @param[in] m Object mask
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI void efl_canvas_vg_node_mask_set(Eo *obj, Efl_Canvas_Vg_Node *m);

/**
 * @brief Vector graphics object mask
 *
 * @param[in] obj The object.
 *
 * @return Object mask
 *
 * @ingroup Efl_Canvas_Vg_Node
 */
EOAPI Efl_Canvas_Vg_Node *efl_canvas_vg_node_mask_get(const Eo *obj);

#endif
