/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.text.Format;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.PercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class NumberPercentRenderer
extends MultiRenderer {
    private final ProfilerRenderer valueRenderer;
    private final PercentRenderer percentRenderer;
    private final ProfilerRenderer[] renderers;
    private Dimension percentSize;

    public NumberPercentRenderer() {
        this((Format)null);
    }

    public NumberPercentRenderer(Format format) {
        this(NumberPercentRenderer.createNumberRenderer(format));
    }

    public NumberPercentRenderer(ProfilerRenderer profilerRenderer) {
        int n;
        this.valueRenderer = profilerRenderer;
        this.percentRenderer = new PercentRenderer(){

            @Override
            public void setForeground(Color color) {
                if (color == null) {
                    color = Color.BLACK;
                }
                super.setForeground(UIUtils.getDisabledForeground(color));
            }

            @Override
            public Dimension getPreferredSize() {
                if (NumberPercentRenderer.this.percentSize == null) {
                    NumberPercentRenderer.this.percentSize = super.getPreferredSize();
                }
                return NumberPercentRenderer.this.percentSize;
            }
        };
        this.percentRenderer.changeFontSize(-1);
        this.percentRenderer.setMargin(3, 0, 3, 3);
        this.percentRenderer.setHorizontalAlignment(11);
        this.percentRenderer.setMaxValue(100L);
        this.percentRenderer.setValue(9999, -1);
        this.percentSize.width = n = this.percentRenderer.getPreferredSize().width;
        this.renderers = new ProfilerRenderer[]{this.valueRenderer, this.percentRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setMaxValue(long l) {
        this.percentRenderer.setMaxValue(l);
    }

    @Override
    public void setValue(Object object, int n) {
        this.valueRenderer.setValue(object, n);
        this.percentRenderer.setValue(object, n);
    }

    @Override
    public void setDiffMode(boolean bl) {
        this.percentRenderer.setVisible(!bl);
        super.setDiffMode(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.valueRenderer.getComponent().getPreferredSize();
        if (this.percentRenderer.isVisible()) {
            dimension.width += this.percentRenderer.getPreferredSize().width;
        }
        return this.sharedDimension(dimension);
    }

    private static ProfilerRenderer createNumberRenderer(Format format) {
        NumberRenderer numberRenderer = new NumberRenderer(format);
        numberRenderer.setMargin(3, 3, 3, 3);
        return numberRenderer;
    }

    @Override
    public String toString() {
        if (!this.percentRenderer.isVisible()) {
            return this.valueRenderer.toString();
        }
        return this.valueRenderer.toString() + " " + this.percentRenderer.toString();
    }
}

