/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.swing.tabcontrol.TabData;

public final class ArrayDiff {
    private TabData[] old;
    private TabData[] nue;
    private Set<Integer> deleted = null;
    private Set<Integer> added = null;

    private ArrayDiff(TabData[] tabDataArray, TabData[] tabDataArray2) {
        this.old = tabDataArray;
        this.nue = tabDataArray2;
        if (tabDataArray2 == null || tabDataArray == null) {
            throw new NullPointerException(tabDataArray == null && tabDataArray2 == null ? "Both arrays are null" : (tabDataArray == null ? "Old array is null" : "New array is null"));
        }
    }

    public TabData[] getOldData() {
        return this.old;
    }

    public TabData[] getNewData() {
        return this.nue;
    }

    public static ArrayDiff createDiff(TabData[] tabDataArray, TabData[] tabDataArray2) {
        if (!Arrays.equals(tabDataArray, tabDataArray2)) {
            return new ArrayDiff(tabDataArray, tabDataArray2);
        }
        return null;
    }

    public Set<Integer> getDeletedIndices() {
        if (this.deleted == null) {
            HashSet<TabData> hashSet = new HashSet<TabData>(Arrays.asList(this.nue));
            HashSet<Integer> hashSet2 = new HashSet<Integer>(this.old.length);
            for (int i = 0; i < this.old.length; ++i) {
                if (hashSet.contains(this.old[i])) continue;
                hashSet2.add(new Integer(i));
            }
            this.deleted = hashSet2;
        }
        return this.deleted;
    }

    public Set<Integer> getAddedIndices() {
        if (this.added == null) {
            HashSet<TabData> hashSet = new HashSet<TabData>(Arrays.asList(this.old));
            HashSet<Integer> hashSet2 = new HashSet<Integer>(this.nue.length);
            for (int i = 0; i < this.nue.length; ++i) {
                if (hashSet.contains(this.nue[i])) continue;
                hashSet2.add(new Integer(i));
            }
            this.added = hashSet2;
        }
        return this.added;
    }

    public Set<Integer> getChangedIndices() {
        int n = Math.max(this.nue.length, this.old.length);
        HashSet<Integer> hashSet = new HashSet<Integer>(n);
        for (int i = 0; i < n; ++i) {
            if (i < this.old.length && i < this.nue.length) {
                if (this.old[i].equals(this.nue[i])) continue;
                hashSet.add(new Integer(i));
                continue;
            }
            hashSet.add(new Integer(i));
        }
        return hashSet;
    }

    public Set<Integer> getMovedIndices() {
        HashSet<TabData> hashSet = new HashSet<TabData>(Arrays.asList(this.nue));
        HashSet<Integer> hashSet2 = new HashSet<Integer>(this.old.length);
        for (int i = 0; i < this.old.length; ++i) {
            boolean bl;
            boolean bl2 = hashSet.contains(this.old[i]);
            if (!bl2) continue;
            boolean bl3 = bl = i < this.nue.length && !this.nue[i].equals(this.old[i]) || i >= this.nue.length;
            if (!bl) continue;
            hashSet2.add(new Integer(i));
        }
        return hashSet2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ArrayDiff: deleted indices: [");
        stringBuffer.append(ArrayDiff.outCol(this.getDeletedIndices()));
        stringBuffer.append("] added indices: [");
        stringBuffer.append(ArrayDiff.outCol(this.getAddedIndices()));
        stringBuffer.append("] changed indices: [");
        stringBuffer.append(ArrayDiff.outCol(this.getChangedIndices()));
        stringBuffer.append("] moved indices: [");
        stringBuffer.append(ArrayDiff.outCol(this.getChangedIndices()));
        stringBuffer.append("]>");
        return stringBuffer.toString();
    }

    private static String outCol(Collection collection) {
        Iterator iterator = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(e.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayDiff) {
            if (object == this) {
                return true;
            }
            Object[] objectArray = ((ArrayDiff)object).getOldData();
            Object[] objectArray2 = ((ArrayDiff)object).getNewData();
            return Arrays.equals(this.old, objectArray) && Arrays.equals(this.nue, objectArray2);
        }
        return false;
    }

    public int hashCode() {
        return ArrayDiff.arrayHashCode(this.old) ^ ArrayDiff.arrayHashCode(this.nue);
    }

    private static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n += objectArray[i].hashCode() ^ i;
        }
        return n;
    }
}

