/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestExecuteWatchAction
extends WatcherRestHandler
implements RestRequestFilter {
    private static final List<String> RESERVED_FIELD_NAMES = Arrays.asList(WatchField.TRIGGER.getPreferredName(), WatchField.INPUT.getPreferredName(), WatchField.CONDITION.getPreferredName(), WatchField.ACTIONS.getPreferredName(), WatchField.TRANSFORM.getPreferredName(), WatchField.THROTTLE_PERIOD.getPreferredName(), WatchField.THROTTLE_PERIOD_HUMAN.getPreferredName(), WatchField.METADATA.getPreferredName(), WatchField.STATUS.getPreferredName(), WatchField.VERSION.getPreferredName());
    private static final Set<String> FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"watch.input.http.request.auth.basic.password", "watch.input.chain.inputs.*.http.request.auth.basic.password", "watch.actions.*.email.attachments.*.reporting.auth.basic.password", "watch.actions.*.webhook.auth.basic.password"}));

    public RestExecuteWatchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_execute", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/{id}/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_execute", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/{id}/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/_execute", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/_execute", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/_execute", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_watcher_execute_watch_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, WatcherClient client) throws IOException {
        ExecuteWatchRequest executeWatchRequest = this.parseRequest(request, client);
        return channel -> client.executeWatch(executeWatchRequest, (ActionListener)new RestBuilderListener<ExecuteWatchResponse>(channel){

            public RestResponse buildResponse(ExecuteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field(Field.ID.getPreferredName(), response.getRecordId());
                builder.field(Field.WATCH_RECORD.getPreferredName(), (ToXContent)response.getRecordSource(), (ToXContent.Params)request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    private ExecuteWatchRequest parseRequest(RestRequest request, WatcherClient client) throws IOException {
        ExecuteWatchRequestBuilder builder = client.prepareExecuteWatch();
        builder.setId(request.param("id"));
        builder.setDebug(WatcherParams.debug((ToXContent.Params)request));
        if (!request.hasContent()) {
            return (ExecuteWatchRequest)builder.request();
        }
        builder.setRecordExecution(request.paramAsBoolean(Field.RECORD_EXECUTION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isRecordExecution()));
        builder.setIgnoreCondition(request.paramAsBoolean(Field.IGNORE_CONDITION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isIgnoreCondition()));
        try (XContentParser parser = request.contentParser();){
            XContentParser.Token token;
            parser.nextToken();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    if (Field.IGNORE_CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setIgnoreCondition(parser.booleanValue());
                        continue;
                    }
                    if (Field.RECORD_EXECUTION.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setRecordExecution(parser.booleanValue());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse watch execution request. unexpected boolean field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (Field.ALTERNATIVE_INPUT.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setAlternativeInput(parser.map());
                        continue;
                    }
                    if (Field.TRIGGER_DATA.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setTriggerData(parser.map());
                        continue;
                    }
                    if (Field.WATCH.match(currentFieldName, parser.getDeprecationHandler())) {
                        XContentBuilder watcherSource = XContentBuilder.builder((XContent)parser.contentType().xContent());
                        try {
                            watcherSource.generator().copyCurrentStructure(parser);
                            builder.setWatchSource(BytesReference.bytes((XContentBuilder)watcherSource), parser.contentType());
                            continue;
                        }
                        finally {
                            if (watcherSource != null) {
                                watcherSource.close();
                            }
                            continue;
                        }
                    }
                    if (Field.ACTION_MODES.match(currentFieldName, parser.getDeprecationHandler())) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_STRING) {
                                try {
                                    ActionExecutionMode mode = ActionExecutionMode.resolve((String)parser.textOrNull());
                                    builder.setActionMode(currentFieldName, mode);
                                    continue;
                                }
                                catch (IllegalArgumentException iae) {
                                    throw new ElasticsearchParseException("could not parse watch execution request", (Throwable)iae, new Object[0]);
                                }
                            }
                            throw new ElasticsearchParseException("could not parse watch execution request. unexpected array field [{}]", new Object[]{currentFieldName});
                        }
                        continue;
                    }
                    if (RESERVED_FIELD_NAMES.contains(currentFieldName)) {
                        throw new ElasticsearchParseException("please wrap watch including field [{}] inside a \"watch\" field", new Object[]{currentFieldName});
                    }
                    throw new ElasticsearchParseException("could not parse watch execution request. unexpected object field [{}]", new Object[]{currentFieldName});
                }
                throw new ElasticsearchParseException("could not parse watch execution request. unexpected token [{}]", new Object[]{token});
            }
        }
        return (ExecuteWatchRequest)builder.request();
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static interface Field {
        public static final ParseField ID = new ParseField("_id", new String[0]);
        public static final ParseField WATCH_RECORD = new ParseField("watch_record", new String[0]);
        public static final ParseField RECORD_EXECUTION = new ParseField("record_execution", new String[0]);
        public static final ParseField ACTION_MODES = new ParseField("action_modes", new String[0]);
        public static final ParseField ALTERNATIVE_INPUT = new ParseField("alternative_input", new String[0]);
        public static final ParseField IGNORE_CONDITION = new ParseField("ignore_condition", new String[0]);
        public static final ParseField TRIGGER_DATA = new ParseField("trigger_data", new String[0]);
        public static final ParseField WATCH = new ParseField("watch", new String[0]);
    }
}

