/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Locale;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.xpack.core.XPackSettings;

public class FIPS140PasswordHashingAlgorithmBootstrapCheck
implements BootstrapCheck {
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        String selectedAlgorithm;
        if (((Boolean)XPackSettings.FIPS_MODE_ENABLED.get(context.settings)).booleanValue() && !(selectedAlgorithm = (String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(context.settings)).toLowerCase(Locale.ROOT).startsWith("pbkdf2")) {
            return BootstrapCheck.BootstrapCheckResult.failure((String)("Only PBKDF2 is allowed for password hashing in a FIPS-140 JVM. Please set the appropriate value for [ " + XPackSettings.PASSWORD_HASHING_ALGORITHM.getKey() + " ] setting."));
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }
}

