/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlLogoutResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRedirect;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;

public final class TransportSamlLogoutAction
extends HandledTransportAction<SamlLogoutRequest, SamlLogoutResponse> {
    private final Realms realms;
    private final TokenService tokenService;

    @Inject
    public TransportSamlLogoutAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Realms realms, TokenService tokenService) {
        super(settings, "cluster:admin/xpack/security/saml/logout", threadPool, transportService, actionFilters, indexNameExpressionResolver, SamlLogoutRequest::new);
        this.realms = realms;
        this.tokenService = tokenService;
    }

    protected void doExecute(SamlLogoutRequest request, ActionListener<SamlLogoutResponse> listener) {
        this.invalidateRefreshToken(request.getRefreshToken(), (ActionListener<Boolean>)ActionListener.wrap(ignore -> {
            try {
                String token = request.getToken();
                this.tokenService.getAuthenticationAndMetaData(token, (ActionListener<Tuple<Authentication, Map<String, Object>>>)ActionListener.wrap(tuple -> {
                    Authentication authentication = (Authentication)tuple.v1();
                    Map tokenMetadata = (Map)tuple.v2();
                    SamlLogoutResponse response = this.buildResponse(authentication, tokenMetadata);
                    this.tokenService.invalidateAccessToken(token, (ActionListener<Boolean>)ActionListener.wrap(created -> {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("SAML Logout User [{}], Token [{}...{}]", (Object)authentication.getUser().principal(), (Object)token.substring(0, 8), (Object)token.substring(token.length() - 8));
                        }
                        listener.onResponse((Object)response);
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
            catch (IOException | ElasticsearchException e) {
                this.logger.debug("Internal exception during SAML logout", e);
                listener.onFailure((Exception)e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void invalidateRefreshToken(String refreshToken, ActionListener<Boolean> listener) {
        if (refreshToken == null) {
            listener.onResponse(null);
        } else {
            this.tokenService.invalidateRefreshToken(refreshToken, listener);
        }
    }

    private SamlLogoutResponse buildResponse(Authentication authentication, Map<String, Object> tokenMetadata) {
        if (authentication == null) {
            throw SamlUtils.samlException("No active authentication", new Object[0]);
        }
        User user = authentication.getUser();
        if (user == null) {
            throw SamlUtils.samlException("No active user", new Object[0]);
        }
        SamlRealm realm = this.findRealm(authentication);
        String tokenRealm = this.getMetadataString(tokenMetadata, "saml_realm");
        if (!realm.name().equals(tokenRealm)) {
            throw SamlUtils.samlException("Authenticating realm [{}] does not match token realm [{}]", new Object[]{realm, tokenRealm});
        }
        SamlNameId nameId = new SamlNameId(this.getMetadataString(tokenMetadata, "saml_nameid_fmt"), this.getMetadataString(tokenMetadata, "saml_nameid_val"), this.getMetadataString(tokenMetadata, "saml_nameid_qual"), this.getMetadataString(tokenMetadata, "saml_nameid_sp_qual"), this.getMetadataString(tokenMetadata, "saml_nameid_sp_id"));
        String session = this.getMetadataString(tokenMetadata, "saml_session");
        LogoutRequest logout = realm.buildLogoutRequest(nameId.asXml(), session);
        if (logout == null) {
            return new SamlLogoutResponse(null);
        }
        String uri = new SamlRedirect((RequestAbstractType)logout, realm.getSigningConfiguration()).getRedirectUrl();
        return new SamlLogoutResponse(uri);
    }

    private String getMetadataString(Map<String, Object> metadata, String key) {
        Object value = metadata.get(key);
        if (value == null) {
            if (metadata.containsKey(key)) {
                return null;
            }
            throw SamlUtils.samlException("Access token does not have SAML metadata [{}]", key);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw SamlUtils.samlException("In access token, SAML metadata [{}] is [{}] rather than String", key, value.getClass());
    }

    private SamlRealm findRealm(Authentication authentication) {
        Authentication.RealmRef ref = authentication.getAuthenticatedBy();
        if (ref == null || Strings.isNullOrEmpty((String)ref.getName())) {
            throw SamlUtils.samlException("Authentication {} has no authenticating realm", authentication);
        }
        Realm realm = this.realms.realm(ref.getName());
        if (realm == null) {
            throw SamlUtils.samlException("Authenticating realm {} does not exist", ref.getName());
        }
        if (realm instanceof SamlRealm) {
            return (SamlRealm)realm;
        }
        throw SamlUtils.samlException("Authenticating realm {} is not a SAML realm", realm);
    }
}

