/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportHasPrivilegesAction
extends HandledTransportAction<HasPrivilegesRequest, HasPrivilegesResponse> {
    private final AuthorizationService authorizationService;
    private final NativePrivilegeStore privilegeStore;

    @Inject
    public TransportHasPrivilegesAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AuthorizationService authorizationService, NativePrivilegeStore privilegeStore) {
        super(settings, "cluster:admin/xpack/security/user/has_privileges", threadPool, transportService, actionFilters, indexNameExpressionResolver, HasPrivilegesRequest::new);
        this.authorizationService = authorizationService;
        this.privilegeStore = privilegeStore;
    }

    protected void doExecute(HasPrivilegesRequest request, ActionListener<HasPrivilegesResponse> listener) {
        String username = request.username();
        User user = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext()).getUser();
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only check the privileges of their own account"));
            return;
        }
        this.authorizationService.roles(user, (ActionListener<Role>)ActionListener.wrap(role -> this.resolveApplicationPrivileges(request, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(applicationPrivilegeLookup -> this.checkPrivileges(request, (Role)role, (Collection<ApplicationPrivilegeDescriptor>)applicationPrivilegeLookup, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveApplicationPrivileges(HasPrivilegesRequest request, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set<String> applications = this.getApplicationNames(request);
        this.privilegeStore.getPrivileges(applications, null, listener);
    }

    private Set<String> getApplicationNames(HasPrivilegesRequest request) {
        return Arrays.stream(request.applicationPrivileges()).map(RoleDescriptor.ApplicationResourcePrivileges::getApplication).collect(Collectors.toSet());
    }

    private void checkPrivileges(HasPrivilegesRequest request, Role userRole, Collection<ApplicationPrivilegeDescriptor> applicationPrivileges, ActionListener<HasPrivilegesResponse> listener) {
        this.logger.trace(() -> new ParameterizedMessage("Check whether role [{}] has privileges cluster=[{}] index=[{}] application=[{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), Strings.arrayToCommaDelimitedString((Object[])request.clusterPrivileges()), Strings.arrayToCommaDelimitedString((Object[])request.indexPrivileges()), Strings.arrayToCommaDelimitedString((Object[])request.applicationPrivileges())}));
        HashMap<String, Boolean> cluster = new HashMap<String, Boolean>();
        for (String string : request.clusterPrivileges()) {
            ClusterPrivilege checkPrivilege = ClusterPrivilege.get(Collections.singleton(string));
            ClusterPrivilege rolePrivilege = userRole.cluster().privilege();
            cluster.put(string, TransportHasPrivilegesAction.testPrivilege((Privilege)checkPrivilege, rolePrivilege.getAutomaton()));
        }
        boolean allMatch = cluster.values().stream().allMatch(Boolean::booleanValue);
        HashMap<IndicesPermission.Group, Automaton> predicateCache = new HashMap<IndicesPermission.Group, Automaton>();
        LinkedHashMap<String, HasPrivilegesResponse.ResourcePrivileges> indices = new LinkedHashMap<String, HasPrivilegesResponse.ResourcePrivileges>();
        for (RoleDescriptor.IndicesPrivileges check : request.indexPrivileges()) {
            for (String string : check.getIndices()) {
                HashMap<String, Boolean> privileges = new HashMap<String, Boolean>();
                HasPrivilegesResponse.ResourcePrivileges existing = (HasPrivilegesResponse.ResourcePrivileges)indices.get(string);
                if (existing != null) {
                    privileges.putAll(existing.getPrivileges());
                }
                for (String privilege : check.getPrivileges()) {
                    if (this.testIndexMatch(string, privilege, userRole, predicateCache)) {
                        this.logger.debug(() -> new ParameterizedMessage("Role [{}] has [{}] on index [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilege, index}));
                        privileges.put(privilege, true);
                        continue;
                    }
                    this.logger.debug(() -> new ParameterizedMessage("Role [{}] does not have [{}] on index [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), privilege, index}));
                    privileges.put(privilege, false);
                    allMatch = false;
                }
                indices.put(string, new HasPrivilegesResponse.ResourcePrivileges(string, privileges));
            }
        }
        HashMap hashMap = new HashMap();
        for (String applicationName : this.getApplicationNames(request)) {
            this.logger.debug("Checking privileges for application {}", (Object)applicationName);
            LinkedHashMap<String, HasPrivilegesResponse.ResourcePrivileges> appPrivilegesByResource = new LinkedHashMap<String, HasPrivilegesResponse.ResourcePrivileges>();
            for (String string : request.applicationPrivileges()) {
                if (!applicationName.equals(string.getApplication())) continue;
                for (String resource : string.getResources()) {
                    HashMap<String, Boolean> privileges = new HashMap<String, Boolean>();
                    HasPrivilegesResponse.ResourcePrivileges existing = (HasPrivilegesResponse.ResourcePrivileges)appPrivilegesByResource.get(resource);
                    if (existing != null) {
                        privileges.putAll(existing.getPrivileges());
                    }
                    for (String privilege : string.getPrivileges()) {
                        if (this.testResourceMatch(applicationName, resource, privilege, userRole, applicationPrivileges)) {
                            this.logger.debug(() -> new ParameterizedMessage("Role [{}] has [{} {}] on resource [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), applicationName, privilege, resource}));
                            privileges.put(privilege, true);
                            continue;
                        }
                        this.logger.debug(() -> new ParameterizedMessage("Role [{}] does not have [{} {}] on resource [{}]", new Object[]{Strings.arrayToCommaDelimitedString((Object[])userRole.names()), applicationName, privilege, resource}));
                        privileges.put(privilege, false);
                        allMatch = false;
                    }
                    appPrivilegesByResource.put(resource, new HasPrivilegesResponse.ResourcePrivileges(resource, privileges));
                }
            }
            hashMap.put(applicationName, appPrivilegesByResource.values());
        }
        listener.onResponse((Object)new HasPrivilegesResponse(allMatch, cluster, indices.values(), hashMap));
    }

    private boolean testIndexMatch(String checkIndex, String checkPrivilegeName, Role userRole, Map<IndicesPermission.Group, Automaton> predicateCache) {
        IndexPrivilege checkPrivilege = IndexPrivilege.get(Collections.singleton(checkPrivilegeName));
        Automaton checkIndexAutomaton = Automatons.patterns((String[])new String[]{checkIndex});
        ArrayList<Automaton> privilegeAutomatons = new ArrayList<Automaton>();
        for (IndicesPermission.Group group : userRole.indices().groups()) {
            Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, g -> Automatons.patterns((String[])g.indices()));
            if (!TransportHasPrivilegesAction.testIndex(checkIndexAutomaton, groupIndexAutomaton)) continue;
            IndexPrivilege rolePrivilege = group.privilege();
            if (rolePrivilege.name().contains(checkPrivilegeName)) {
                return true;
            }
            privilegeAutomatons.add(rolePrivilege.getAutomaton());
        }
        return TransportHasPrivilegesAction.testPrivilege((Privilege)checkPrivilege, Automatons.unionAndMinimize(privilegeAutomatons));
    }

    private static boolean testIndex(Automaton checkIndex, Automaton roleIndex) {
        return Operations.subsetOf((Automaton)checkIndex, (Automaton)roleIndex);
    }

    private static boolean testPrivilege(Privilege checkPrivilege, Automaton roleAutomaton) {
        return Operations.subsetOf((Automaton)checkPrivilege.getAutomaton(), (Automaton)roleAutomaton);
    }

    private boolean testResourceMatch(String application, String checkResource, String checkPrivilegeName, Role userRole, Collection<ApplicationPrivilegeDescriptor> privileges) {
        Set<String> nameSet = Collections.singleton(checkPrivilegeName);
        ApplicationPrivilege checkPrivilege = ApplicationPrivilege.get((String)application, nameSet, privileges);
        assert (checkPrivilege.getApplication().equals(application)) : "Privilege " + checkPrivilege + " should have application " + application;
        assert (checkPrivilege.name().equals(nameSet)) : "Privilege " + checkPrivilege + " should have name " + nameSet;
        return userRole.application().grants(checkPrivilege, checkResource);
    }
}

